/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qdesigner_customwidget.h"
#include "formwindow.h"

#include <abstractformeditor.h>
#include "widgetdatabase.h"

QDesignerCustomWidget::QDesignerCustomWidget(FormWindow *formWindow, QWidget *parent)
    : QDesignerWidget(formWindow, parent),
      m_widgetClassName(QLatin1String("QWidget"))
{
}

QDesignerCustomWidget::~QDesignerCustomWidget()
{
}

AbstractWidgetDataBaseItem *QDesignerCustomWidget::widgetItem() const
{
    AbstractFormEditor *core = formWindow()->core();
    int index = core->widgetDataBase()->indexOfClassName(widgetClassName());
    if (index != -1)
        return core->widgetDataBase()->item(index);
        
    qWarning("no widget item for %s", widgetClassName().latin1());
    return 0;
}

QString QDesignerCustomWidget::widgetClassName() const
{
    return m_widgetClassName;
}

void QDesignerCustomWidget::setWidgetClassName(const QString &widgetClassName)
{
    m_widgetClassName = widgetClassName;    
    createWidgetItem();
}

void QDesignerCustomWidget::createWidgetItem()
{
    if (!widgetItem()) {
        WidgetDataBaseItem *item = new WidgetDataBaseItem();
        item->setName(m_widgetClassName);
        formWindow()->core()->widgetDataBase()->append(item);
    }
}

bool QDesignerCustomWidget::isCompat() const
{
    if (AbstractWidgetDataBaseItem *item = widgetItem())
        return item->isCompat();
        
    return false;
}

void QDesignerCustomWidget::setCompat(bool compat)
{
    if (AbstractWidgetDataBaseItem *item = widgetItem()) {
        item->setCompat(compat);
        update();
    }
}

bool QDesignerCustomWidget::isContainer() const
{
    if (AbstractWidgetDataBaseItem *item = widgetItem())
        return item->isContainer();
        
    return false;
}

void QDesignerCustomWidget::setContainer(bool container)
{
    if (AbstractWidgetDataBaseItem *item = widgetItem()) {
        item->setContainer(container);
        update();
    }
}

