/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef METADATABASE_H
#define METADATABASE_H

#include "formeditor_global.h"

#include <abstractmetadatabase.h>

#include <QHash>
#include <QCursor>

struct MetaDataBaseItem: public AbstractMetaDataBaseItem
{
    MetaDataBaseItem(QObject *object);
    virtual ~MetaDataBaseItem();

    virtual QString name() const;
    virtual void setName(const QString &name);

    virtual QString author() const;
    virtual void setAuthor(const QString &author);

    virtual QString comment() const;
    virtual void setComment(const QString &comment);

    virtual QCursor cursor() const;
    virtual void setCursor(const QCursor &cursor);

    virtual QList<QWidget*> tabOrder() const;
    virtual void setTabOrder(const QList<QWidget*> &tabOrder);

    virtual int spacing() const;
    virtual void setSpacing(int spacing);

    virtual int margin() const;
    virtual void setMargin(int margin);

    virtual bool enabled() const;
    virtual void setEnabled(bool b);

private:
    QObject *m_object;
    QString m_author;
    QString m_comment;
    QCursor m_cursor;
    QList<QWidget*> m_tabOrder;
    int m_spacing;
    int m_margin;
    bool m_enabled;
};

class QT_FORMEDITOR_EXPORT MetaDataBase: public AbstractMetaDataBase
{
    Q_OBJECT
public:
    MetaDataBase(AbstractFormEditor *core, QObject *parent = 0);
    virtual ~MetaDataBase();

    virtual AbstractFormEditor *core() const;

    virtual AbstractMetaDataBaseItem *item(QObject *object) const;
    virtual void add(QObject *object);
    virtual void remove(QObject *object);

    virtual QList<QObject*> objects() const;

private slots:
    void slotDestroyed(QObject *object);

private:
    AbstractFormEditor *m_core;
    typedef QHash<QObject *, MetaDataBaseItem*> ItemMap;
    ItemMap m_items;
};

#endif // METADATABASE_H
