/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the network module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDNS_H
#define QDNS_H

#include <QtCore/qlist.h>
#include <QtNetwork/qhostaddress.h>

class QString;
class QObject;
class QDnsHostInfoPrivate;
class QDnsHostInfo;

class Q_NETWORK_EXPORT QDns
{
public:
    static void getHostByName(const QString &name, QObject *receiver, const char *member);
    static QDnsHostInfo getHostByName(const QString &name);
    static QString getHostName();
};

class Q_NETWORK_EXPORT QDnsHostInfo
{
public:
    QDnsHostInfo();
    QDnsHostInfo(const QDnsHostInfo &d);
    QDnsHostInfo &operator=(const QDnsHostInfo &d);
    ~QDnsHostInfo();

    QString host() const;
    QList<QHostAddress> addresses() const;

    enum Error { NoError, HostNotFound, UnknownError };

    Error error() const;
    QString errorString() const;

    friend class QDnsAgent;
    friend void QDns::getHostByName(const QString &, QObject *, const char *);
    friend QDnsHostInfo QDns::getHostByName(const QString &);

private:
    QDnsHostInfoPrivate *d;
};

#endif
