/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDOCKWINDOW_H
#define QDOCKWINDOW_H

#include <qframe.h>

class QDockWindowLayout;
class QDockWindowPrivate;
class QMainWindow;

class Q_GUI_EXPORT QDockWindow : public QFrame
{
    Q_OBJECT

    Q_FLAGS(DockWindowFeatures)
    Q_PROPERTY(DockWindowFeatures features READ features WRITE setFeatures)
    Q_PROPERTY(Qt::DockWindowAreas allowedAreas READ allowedAreas WRITE setAllowedAreas)

public:
    QDockWindow(QMainWindow *parent, Qt::WFlags flags = 0);
    ~QDockWindow();

    QMainWindow *mainWindow() const;
    void setParent(QMainWindow *parent);

    QWidget *widget() const;
    void setWidget(QWidget *widget);

    enum DockWindowFeature {
        DockWindowClosable    = 0x01,
        DockWindowMovable     = 0x02,
        DockWindowFloatable   = 0x04,

        DockWindowFeatureMask = 0x07,
        AllDockWindowFeatures = DockWindowFeatureMask,
        NoDockWindowFeatures  = 0x00
    };
    Q_DECLARE_FLAGS(DockWindowFeatures, DockWindowFeature)

    void setFeatures(DockWindowFeatures features);
    void setFeature(DockWindowFeature features, bool on = true);
    DockWindowFeatures features() const;
    bool hasFeature(DockWindowFeature feature) const;

    void setTopLevel(bool topLevel = true, const QPoint &pos = QPoint());

    void setAllowedAreas(Qt::DockWindowAreas areas);
    Qt::DockWindowAreas allowedAreas() const;

    inline bool isDockable(Qt::DockWindowArea area)
    { return (allowedAreas() & area) == area; }

    QAction *toggleViewAction() const;

protected:
    void changeEvent(QEvent *event);
    void closeEvent(QCloseEvent *event);
    bool event(QEvent *event);

private:
    Q_DECLARE_PRIVATE(QDockWindow)
    Q_DISABLE_COPY(QDockWindow)
    Q_PRIVATE_SLOT(d, void toggleView(bool))
    friend class QDockWindowLayout;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(QDockWindow::DockWindowFeatures)

#endif // QDOCKWINDOW_H
