/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the item views module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTREEVIEW_P_H
#define QTREEVIEW_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/qabstractitemview_p.h>

struct QTreeViewItem
{
    QTreeViewItem() : open(false), total(0), level(0), height(0) {}
    QModelIndex index; // we remove items whenever the indexes are invalidated (make persistent ?)
    uint open : 1;
    uint total : 30; // total number of children visible (+ hidden children)
    uint level : 16; // indentation
    uint height : 16; // row height
};

class QTreeViewPrivate: public QAbstractItemViewPrivate
{
    Q_DECLARE_PUBLIC(QTreeView)
public:

    QTreeViewPrivate()
        : QAbstractItemViewPrivate(),
          header(0), indent(20), itemHeight(-1),
          uniformRowHeights(false), rootDecoration(true), reopen(-1) { }

    ~QTreeViewPrivate() {}

    void open(int item);
    void close(int item);
    void layout(int item);

    int pageUp(int item) const;
    int pageDown(int item) const;

    inline int above(int item) const
        { return (--item < 0 ? 0 : item); }
    inline int below(int item) const
        { return (++item >= viewItems.count() ? viewItems.count() - 1 : item); }

    inline int height(int item) const {
        if (uniformRowHeights) return itemHeight;
        if (viewItems.at(item).height == 0)
            viewItems[item].height = q_func()->indexRowSizeHint(viewItems.at(item).index);
        return viewItems.at(item).height;
    }

    int indentation(int item) const;
    int coordinate(int item) const;
    int item(int coordinate) const;

    int viewIndex(const QModelIndex &index) const;
    QModelIndex modelIndex(int i) const;

    int itemAt(int value) const;
    int topItemDelta(int value, int iheight) const;
    int columnAt(int x) const;

    void relayout(const QModelIndex &parent);
    void reopenChildren(const QModelIndex &parent);

    void updateVerticalScrollbar();
    void updateHorizontalScrollbar();

    int itemDecorationAt(const QPoint &pos) const;

    void select(int start, int stop, QItemSelectionModel::SelectionFlags command);

    QHeaderView *header;
    int indent;

    mutable QVector<QTreeViewItem> viewItems;
    int itemHeight; // this is just a number; contentsHeight() / numItems
    bool uniformRowHeights; // used when all rows have the same height
    bool rootDecoration;

    // used for drawing
    int left;
    int right;
    int current;

    // used when opening and closing items
    QVector<QPersistentModelIndex> openedIndexes;
    int reopen;

    // used when hiding and showing items
    QVector<QPersistentModelIndex> hiddenIndexes;

    // used for hidden items
    int hiddenItemsCount;
};

#endif
