/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the painting module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QBITMAP_H
#define QBITMAP_H

#include "qpixmap.h"


class Q_GUI_EXPORT QBitmap : public QPixmap
{
public:
    QBitmap();
    QBitmap(int w, int h,  bool clear = false,
             QPixmap::Optimization = QPixmap::DefaultOptim);
    QBitmap(const QSize &, bool clear = false,
             QPixmap::Optimization = QPixmap::DefaultOptim);
    QBitmap(int w, int h,  const uchar *bits, bool isXbitmap=false);
    QBitmap(const QSize &, const uchar *bits, bool isXbitmap=false);
    QBitmap(const QBitmap &);
    QBitmap(const QPixmap &);
    QBitmap(const QImage &);
#ifndef QT_NO_IMAGEIO
    QBitmap(const QString &fileName, const char *format=0);
#endif
    QBitmap &operator=(const QBitmap &);
    QBitmap &operator=(const QPixmap &);
    QBitmap &operator=(const QImage  &);

#ifndef QT_NO_PIXMAP_TRANSFORMATION
    QBitmap transform(const QMatrix &) const;
#ifdef QT_COMPAT
    inline QT_COMPAT QBitmap xForm(const QMatrix &matrix) const { return transform(matrix); }
#endif
#endif
};
Q_DECLARE_SHARED(QBitmap);


#endif // QBITMAP_H
