/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the embedded classes of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QGFXDRIVERPLUGIN_QWS_H
#define QGFXDRIVERPLUGIN_QWS_H

#include "qplugin.h"
#include "qfactoryinterface.h"

#ifndef QT_NO_COMPONENT

class QScreen;

struct Q_GUI_EXPORT QGfxDriverFactoryInterface : public QFactoryInterface
{
    virtual QScreen* create(const QString& driver, int displayId) = 0;
};

Q_DECLARE_INTERFACE(QGfxDriverFactoryInterface, "http://trolltech.com/Qt/QGfxDriverFactoryInterface")


class Q_GUI_EXPORT QGfxDriverPlugin : public QObject, public QGfxDriverFactoryInterface
{
    Q_OBJECT
    Q_INTERFACES(QGfxDriverFactoryInterface:QFactoryInterface)
public:
    QGfxDriverPlugin(QObject *parent = 0);
    ~QGfxDriverPlugin();

    virtual QStringList keys() const = 0;
    virtual QScreen* create(const QString& driver, int displayId) = 0;
};

#endif // QT_NO_COMPONENT

#endif // QGFXDRIVERPLUGIN_QWS_H
