/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the dialog module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QPRINTDIALOG_H
#define QPRINTDIALOG_H

#include "qabstractprintdialog.h"

class QPrintDialogPrivate;
class QAbstractButton;
class QPrinter;

class Q_GUI_EXPORT QPrintDialog : public QAbstractPrintDialog
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QPrintDialog)
public:
    QPrintDialog(QPrinter *printer, QWidget *parent = 0);
    ~QPrintDialog();

#if defined (Q_OS_UNIX) && !defined (Q_OS_MAC) && defined (QT_COMPAT)
    void setPrinter(QPrinter *, bool = false);
    QPrinter *printer() const;
    void addButton(QPushButton *button);
#endif

    int exec();

private:
    Q_DISABLE_COPY(QPrintDialog)

// #if defined (Q_OS_UNIX) && !defined (Q_OS_MAC)
    Q_PRIVATE_SLOT(d, void browseClicked())
    Q_PRIVATE_SLOT(d, void okClicked())
    Q_PRIVATE_SLOT(d, void printerOrFileSelected(QAbstractButton *))
    Q_PRIVATE_SLOT(d, void landscapeSelected(int))
    Q_PRIVATE_SLOT(d, void paperSizeSelected(int))
    Q_PRIVATE_SLOT(d, void orientSelected(int))
    Q_PRIVATE_SLOT(d, void pageOrderSelected(QAbstractButton *))
    Q_PRIVATE_SLOT(d, void colorModeSelected(QAbstractButton *))
    Q_PRIVATE_SLOT(d, void setNumCopies(int))
    Q_PRIVATE_SLOT(d, void printRangeSelected(QAbstractButton *))
    Q_PRIVATE_SLOT(d, void setFirstPage(int))
    Q_PRIVATE_SLOT(d, void setLastPage(int))
    Q_PRIVATE_SLOT(d, void fileNameEditChanged(const QString &text))
// #endif
};

#endif // QPRINTDIALOG_H
