/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the motif module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QApplication>
#include <QMenuBar>
#include <QMenu>
#include <QStatusBar>

#include "mainwindow.h"

#include <QtMotif/QMotifWidget>

#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

MainWindow::MainWindow()
    : QMainWindow()
{
    QMenu *filemenu = new QMenu(tr("&File"), this);
    filemenu->addAction( tr("&Quit"), qApp, SLOT(quit()) );

    menuBar()->addMenu(filemenu);
    statusBar()->message( tr("This is a QMainWindow with an XmText widget.") );

    customwidget = new QMotifWidget("form", xmFormWidgetClass, this);

    XmString str;
    Arg args[6];

    str = XmStringCreateLocalized( "Push Button (XmPushButton)" );
    XtSetArg( args[0], XmNlabelString, str );
    XtSetArg( args[1], XmNleftAttachment, XmATTACH_FORM );
    XtSetArg( args[2], XmNrightAttachment, XmATTACH_FORM );
    XtSetArg( args[3], XmNbottomAttachment, XmATTACH_FORM );
    Widget button =
	XmCreatePushButton( customwidget->motifWidget(), "Push Button", args, 4 );
    XmStringFree( str );

    XtSetArg( args[0], XmNeditMode, XmMULTI_LINE_EDIT );
    XtSetArg( args[1], XmNleftAttachment, XmATTACH_FORM );
    XtSetArg( args[2], XmNrightAttachment, XmATTACH_FORM );
    XtSetArg( args[3], XmNtopAttachment, XmATTACH_FORM );
    XtSetArg( args[4], XmNbottomAttachment, XmATTACH_WIDGET );
    XtSetArg( args[5], XmNbottomWidget, button );
    Widget texteditor =
	XmCreateScrolledText( customwidget->motifWidget(), "Text Editor", args, 6 );

    XtManageChild( texteditor );
    XtManageChild( button );

    setCentralWidget( customwidget );

    resize( 400, 600 );
}
