/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "hexdelegate.h"
#include <qabstractitemmodel.h>
#include <qpainter.h>

HexDelegate::HexDelegate(QObject *parent) 
    : QItemDelegate(parent)
{
    sz = QSize(2, 2);
    textHex = "0x";
    textHex.reserve(8); // fine tuning
}

HexDelegate::~HexDelegate()
{
}

void HexDelegate::paint(QPainter *painter,
                        const QStyleOptionViewItem &option,
                        const QModelIndex &index) const
{
    static QRect emptyRect;
    static QPoint pt;

    textHex.resize(2);
    uint col = index.model()->data(index, QAbstractItemModel::DisplayRole).toInt();
    textHex += QString::number(col, 16).toUpper();

    // Layout text
    QRect textRect(pt, painter->fontMetrics().size(0, textHex) + sz);
    doLayout(option, &emptyRect, &textRect, false);

    // draw the item
    drawDisplay(painter, option, textRect, textHex);
}

QSize HexDelegate::sizeHint(const QStyleOptionViewItem &option,
                            const QModelIndex &) const
{
    static QString textSize("0xFFFFFFFF");
    return QFontMetrics(option.font).size(0, textSize) + sz;
}
