/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef TEXTOUTLINE_H
#define TEXTOUTLINE_H

#include "demowidget.h"

#include <qpainterpath.h>

class TextOutline : public DemoWidget
{
public:
    enum DragLocation { TopLeft, TopRight, BottomLeft, BottomRight };

    TextOutline(QWidget *parent=0);

    void paintEvent(QPaintEvent *e);

    void showEvent(QShowEvent *e);
    void startAnimation();
    void stopAnimation();
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);
    void resetState() { update(); }

private:

    void drawTarget(QPainter *p, const QPoint &pt);
    void updatePath();
    QPointF mapPoint(float x, float y, bool *ok);

    QPainterPath basePath;
    QRectF basePathBounds;
    QPainterPath xpath;
    DragLocation dragLocation;
    QPoint pul, pur, pbl, pbr;
};

#endif
