#include "qclockchange.h"
#include <qpushbutton.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qspinbox.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* 
 *  Constructs a Example which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
qclockchange::qclockchange( QWidget* parent,  const char* name, WFlags fl )
    : qclockchangebase( parent, name, fl )
{
    connect(changeL, SIGNAL(valueChanged(int)), this, SLOT(show_freq()));
    connect(changeM, SIGNAL(valueChanged(int)), this, SLOT(show_freq()));
    connect(changeN, SIGNAL(valueChanged(int)), this, SLOT(show_freq()));
    connect(writeCCCR, SIGNAL(clicked()), this, SLOT(write_cccr()));

    read_cccr();
    show_freq();
    setCaption( tr( "qclockchange" ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */

qclockchange::~qclockchange()
{
   // no need to delete child widgets, Qt does it all for us
}

int cpuregister;

char *IntToBin(long v, int len, char *s)
{
  char bin[] = "01";
  s[len--] = 0;
  do {
    s[len] = bin[v % 2];
    v = v / 2;
  } while (len--);
  return s;
}

	
void qclockchange::show_freq()
{
	float freq_mem;
	float freq_run_mode;
	float freq_turbo_mode;
	float freq_PXBus;
	int data_L;
	int data_M;
	float data_N;
	int cccr;
	char tmp[10];
	
	showLNumber_Bin->display(IntToBin(changeL->value(),5,tmp));
	showMNumber_Bin->display(IntToBin(changeM->value(),2,tmp));
	showNNumber_Bin->display(IntToBin(changeN->value(),3,tmp));

	switch (changeL->value()) {
	case 0:
		data_L = 0;
		break;
	case 1:
		data_L = 27;
		break;
	case 2:
		data_L = 32;
		break;
	case 3:
		data_L = 36;
		break;
	case 4:
		data_L = 40;
		break;
	case 5:
		data_L = 45;
		break;
	default:
		data_L = 0;
		break;
	}			
	
	switch (changeM->value()) {
	case 0:
		data_M = 0;
		break;
	case 1:
		data_M = 1;
		break;
	case 2:
		data_M = 2;
		break;
	case 3:
		data_M = 4;
		break;
	default:
		data_M = 0;
		break;
	}			

	switch (changeN->value()) {
	case 0:
		data_N = 0.0;
		break;
	case 1:
		data_N = 0.5;
		break;
	case 2:
		data_N = 1.0;
		break;
	case 3:
		data_N = 1.5;
		break;
	case 4:
		data_N = 2.0;
		break;
	case 5:
		data_N = 2.5;
		break;
	case 6:
		data_N = 3.0;
		break;
	case 7:
		data_N = 3.5;
		break;
	default:
		data_N = 0.0;
		break;
	}

	cccr = changeN->value() * 128 + changeM->value() * 32 + changeL->value();

	freq_mem = 3.6864 * data_L;
	freq_run_mode = freq_mem * data_M;
	freq_turbo_mode = freq_run_mode * data_N;
	freq_PXBus = freq_run_mode / 2.0;

	sprintf(tmp,"%08X",cccr);
	showCCCR->display(tmp);
	showLNumber->display(data_L);
	showMNumber->display(data_M);
	showNNumber->display(data_N);

	showMemoryFreq->display(freq_mem);
	showRunModeFreq->display(freq_run_mode);
	showTurboModeFreq->display(freq_turbo_mode);
	showPXBusFreq->display(freq_PXBus);

}

void qclockchange::read_cccr()
{
	FILE *fp;

	fp=fopen("/proc/cccr_change", "r");
	fscanf(fp, "%x", &cpuregister);
	fclose(fp);

	changeL->setValue(cpuregister & 0x001f);
	changeM->setValue((cpuregister >> 5) & 0x0003);
	changeN->setValue((cpuregister >> 7) & 0x0007);
}

void qclockchange::write_cccr()
{
	FILE *fp;

	sync();

	cpuregister = changeN->value() * 128 + changeM->value() * 32 + changeL->value();
	fp=fopen("/proc/cccr_change", "w");
	fprintf(fp, "%08X\n", cpuregister);
	fclose(fp);

}
