/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "KWQPushButton.h"
#include "KWIQMacros.h"
// We empirically determined that buttons have these extra pixels on all
// sides. It would be better to get this info from AppKit somehow.
#define TOP_MARGIN 0 //4
#define BOTTOM_MARGIN 0 //6
#define LEFT_MARGIN 0
#define RIGHT_MARGIN 0


enum {
    topMargin,
    bottomMargin,
    leftMargin,
    rightMargin,
    baselineFudgeFactor
};

QPushButton::QPushButton(QWidget * parent, const char * name)
    :QButton(parent,name)
{
    GtkWidget *w = gtk_button_new_with_label("");
    setGtkWidget(w);
}

QPushButton::QPushButton(const QString &text, QWidget * parent, const char * name)
    :QButton(parent,name)
{
    QCString cstr = text.utf8();
    
    GtkWidget *w =
	gtk_button_new_with_label(static_cast<const char*>(cstr));
    
    setGtkWidget(w);
}

QSize QPushButton::sizeHint() const 
{
    return QButton::sizeHint();
}

QRect QPushButton::frameGeometry() const
{
    return QButton::frameGeometry();
}

void QPushButton::setFrameGeometry(const QRect &r)
{
    QButton::setFrameGeometry(r);
}

int QPushButton::baselinePosition(int height) const
{
    return (int) ((15.0f/20.0f)*(float)height);
#if 0
    GtkWidget *w = getGtkWidget();
    PangoContext *pc= gtk_widget_get_pango_context(w);
    PangoFontDescription *fd = pango_context_get_font_description(pc);
    PangoFontMetrics *fm = pango_context_get_metrics(pc,fd,NULL); //lang=NULL    
    
    float ascender = pango_font_metrics_get_ascent(fm) / PANGO_SCALE;
    float descender =pango_font_metrics_get_descent(fm) / PANGO_SCALE;
    
    return (int)ceil(- TOP_MARGIN
        + ((height() + TOP_MARGIN + BOTTOM_MARGIN) - (ascender - descender)) / 2.0
        + ascender - VERTICAL_FUDGE_FACTOR);
#endif
}
