#include "NetscapePlugin.h"

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <npapi.h>
#include <npupp.h>

#include <assert.h>
#include <gtk2xtbin.h>

NetscapePlugin::NetscapePlugin(NPPluginFuncs *funcs)    
    :KWIQPlugin(EMBED),
     pluginFuncs(funcs)
     ,npp(0)
     ,argn(0)
     ,argv(0)
     ,argc(0)
     ,sdata(0)
     ,m_mimeType(g_strdup("application/octet-stream"))
{
    assert(pluginFuncs);
}


NetscapePlugin:: ~NetscapePlugin()
{
    if (npp) {
	NPSavedData *data = NULL;
	data = destroy();
	if (data) NPN_MemFree(data);
	
    }

    if (sdata) NPN_MemFree(sdata);
    if (m_mimeType) g_free(m_mimeType);

    clearParams();
}

void NetscapePlugin::create(KWIQBridgeApp* bridge)
{
    NPError err;
    assert(!npp);

    npp = new NPP_t;
    npp->ndata = bridge;

    if (pluginFuncs->newp){
	err = CallNPP_NewProc(pluginFuncs->newp, 
			      m_mimeType,
			      npp, 
			      mode()==KWIQPlugin::EMBED?NP_EMBED:NP_FULL, 
			      argc, 
			      argn, 
			      argv, 
			      sdata);
	sdata = NULL; // ownership of sdata transferred.
    }

    clearParams();
}

NPSavedData* NetscapePlugin::destroy()
{
    assert(npp);
    NPError err;

    NPSavedData *data = NULL;
    if (pluginFuncs->destroy) {
	err = CallNPP_DestroyProc(pluginFuncs->destroy, npp, &data);
    }

    delete npp;
    npp = 0;

    return data;
}

void NetscapePlugin::clearParams()
{
    int i;

    if (argn) g_strfreev(argn);
    if (argv) g_strfreev(argv);

    argn = argv = 0;

    argc=0;
}

void NetscapePlugin::setParams(gchar** namev, gchar** valuev)
{
    clearParams();
    argn = g_strdupv(namev);
    argv = g_strdupv(valuev);

    for (argc=0;namev[argc]!=NULL && valuev[argc]!=NULL;argc++)
    {		
    }
}

void NetscapePlugin::setSavedData(NPSavedData *data)
{
    sdata = data;
}

void NetscapePlugin::setMimeType(const gchar* type)
{
    if (m_mimeType) g_free(m_mimeType);
    m_mimeType = g_strdup(type);
}

void NetscapePlugin::setWindow(void* view)
{
    g_warning("%s", __PRETTY_FUNCTION__);
#if 0
    GtkWidget *widget = GTK_WIDGET (view);
    GtkAllocation *alloc = &widget->allocation;
    GdkWindow *gdkw = widget->window;
    
    window.window =(void*)xtbin->xtwindow;
    window.x = alloc->x;
    window.y = alloc->y;
    window.width = alloc->width;
    window.height = alloc->height;

    window.clipRect.top = alloc->y;
    window.clipRect.bottom = alloc->y + alloc->height;
    window.clipRect.left = alloc->x;    
    window.clipRect.right = alloc->x + alloc->width;

    window.ws_info = &ws_info;
    window.type = NPWindowTypeWindow;

    ws_info.type = NP_SETWINDOW;
    ws_info.display = xtbin->xtdisplay;
    ws_info.visual = xtbin->xtclient.visual; //GDK_VISUAL_XVISUAL(gdk_drawable_get_visual(gdkw));
    ws_info.colormap = GDK_COLORMAP_XCOLORMAP(gdk_drawable_get_colormap(gdkw));
    ws_info.depth = gdk_drawable_get_depth(gdkw);

    g_warning("winow %x  display %x visual %x colormap %x", window.window, ws_info.display, ws_info.visual, ws_info.colormap);

    CallNPP_SetWindowProc(pluginFuncs->setwindow, npp, &window);
#else
    GtkXtBin* xtbin = GTK_XTBIN (view);

    window.window =(void*)xtbin->xtwindow;
    window.x = xtbin->x;
    window.y = xtbin->y;
    window.width = xtbin->width;
    window.height = xtbin->height;

    window.clipRect.top = xtbin->y;
    window.clipRect.bottom = xtbin->y + xtbin->height;
    window.clipRect.left = xtbin->x;    
    window.clipRect.right = xtbin->x + xtbin->width;

    window.ws_info = &ws_info;
    window.type = NPWindowTypeWindow;

    ws_info.type = NP_SETWINDOW;
    ws_info.display = xtbin->xtdisplay;
    ws_info.visual = xtbin->xtclient.xtvisual;
    ws_info.colormap = xtbin->xtclient.xtcolormap;
    ws_info.depth = xtbin->xtclient.xtdepth;

    g_warning("winow %x  display %x visual %x colormap %x", window.window, ws_info.display, ws_info.visual, ws_info.colormap);

    CallNPP_SetWindowProc(pluginFuncs->setwindow, npp, &window);
    g_warning("setwindow end");

#endif
}

const gchar* NetscapePlugin::mimeType() const
{
    return m_mimeType;
}
