/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2002 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rigths reserved.                                                   */
/*                                                                        */
/**************************************************************************/



// Main for test

#include "SessionInterface.h"
#include "StringUtilities.h"
#include <stdio.h>
#include <iostream>
using namespace std;

#include <windows.h>


int SetNXSessionParameters( NXSessionPtr );


int main( int argc, char** argv )
{
  NXSessionPtr pSession = CreateSession();
  if( SetNXSessionParameters( pSession ) == NX_Exception )
  {
    char *pError = GetLastError( pSession );
    fprintf( stderr, "ERROR: %s\n", pError );
    delete pError;
    return 1;
  }

  NXConnectionPtr pConnection = CreateServerConnection( pSession, "nxssh" );
  NXXServerPtr pXServer = CreateXServerConnection( pSession );

  int iState = 0;
  bool sessionOk = false;
  string password = "";
  string username = "";
  char prompt[256];
  int iCount = 0;

  cout << "NX Session TEST: start session '"
       << GetStringParameter( pSession, NX_SessionName, "NULL" )
       << "'." << endl << flush;
  /* LOGIN */
  cout << "Login: " << flush;
  cin >> username;
  SetStringParameter( pSession, NX_Username, username.c_str() );
  sprintf( prompt, "%s's password: ", (const char*)GetStringParameter( pSession, NX_Username, "NULL" ) );
  cout << prompt << flush;
  cin >> password;
  SetStringParameter( pSession, NX_Password, password.c_str() );
  /* LOGIN END */

  if( InitXServerConnection( pXServer ) == NX_Exception )
  {
    fprintf( stderr, "ERROR: Cannot init XServer.\n" );
    return 0;
  }

  if( InitServerConnection( pConnection ) == NX_Exception )
  {
    char *pError = GetLastError( pSession );
    fprintf( stderr, "ERROR: %s\n", pError );
    delete pError;
  }
  else
  {
    if( AdvanceXServerConnection( pXServer ) == NX_Exception )
    {
      fprintf( stderr, "ERROR: XServer cannot start.\n" );
      return 0;
    }

    while( EndServerConnection( pConnection ) != NX_Ok )
    {
      iState = AdvanceServerConnection( pConnection );
      if( iState == NX_Exception )
      {
        char *pError = GetLastError( pSession );
        fprintf( stderr, "ERROR: %s\n", pError );
        delete pError;
        break;
      }

      if( iState == NX_SessionAccepted )
      {
        if( EndXServerConnection( pXServer ) == NX_Ok )
        {  
          fprintf( stdout, "SESSION ACCEPTED.\n" );
          launchProxy = true;
          break;
        }
        else
        {
          fprintf( stdout, "XWin.exe is not running.\n" );
          launchProxy = false;
          break;
        }
      }

      Sleep( 300 );
      
    }
  }

  DeleteServerConnection( pConnection );


  if( SessionNeedToStartNewProxy( pSession ) == NX_Ok )
  {
    sessionOk = true;
    NXProxyPtr pProxy = CreateProxyConnection( pSession );
    if( InitProxyConnection( pProxy ) == NX_Exception )
    {
      char *pError = GetLastError( pSession );
      fprintf( stderr, "ERROR: %s\n", pError );
      delete pError;
    }

    while( EndProxyConnection( pProxy ) != NX_Ok )
    {
      iState = AdvanceProxyConnection( pProxy );
      if( iState == NX_Exception )
      {
        char *pError = GetLastError( pSession );
        fprintf( stderr, "ERROR: %s\n", pError );
        sessionOk = false;
        delete pError;
        break;
      }

      Sleep( 300 );
    }

    if( sessionOk )
    {
      fprintf( stdout, "SESSION STARTED.\n" );
    }

    DeleteProxyConnection( pProxy );
  }
 

  if( !sessionOk )
    TerminateXServerConnection( pXServer );

  DeleteSession( pSession );
  DeleteXServerConnection( pXServer );

  return 0;

}

int SetNXSessionParameters( NXSessionPtr pSession )
{
  SetStringParameter( pSession, NX_SessionName, "xTerm on Testdrive" );
  SetStringParameter( pSession, NX_PersonalDirectory, "D:\\marco\\progetti\\NX\\nxcompshtest\\nx" );

  /* Server */
  SetStringParameter( pSession, NX_SshPath, "D:\\Programmi\\nxclient\\bin\\nxssh2.exe" );
  SetStringParameter( pSession, NX_HostName, "zenone.medialogic.it" );
  SetStringParameter( pSession, NX_SshKeyPath, "D:\\Programmi\\nxclient\\share\\client.id_dsa.key" );
  SetStringParameter( pSession, NX_SshLogPath, "ssh.log" );

  if( GetExistingSessionCookie( pSession ) != NX_Ok )
    if( GenerateSessionCookie( pSession ) != NX_Ok )
      return NX_Exception;

	
  //SetStringParameter( pSession, NX_SessionType, "unix-application" );
  //SetStringParameter( pSession, NX_ApplicationPath, "xterm" );
  //SetStringParameter( pSession, NX_UseVirtualDesktop, "0" );

  SetStringParameter( pSession, NX_SessionType, "unix-kde" );
  SetStringParameter( pSession, NX_DesktopGeometry, "fullscreen" );

  //SetStringParameter( pSession, NX_DesktopGeometry, "800x600+0+0" );
  //SetStringParameter( pSession, NX_SessionType, "windows" );
  //SetStringParameter( pSession, NX_AgentServer, "xp.nomachine.com" );

  //SetStringParameter( pSession, NX_UseEncryption, "1" );
  //SetStringParameter( pSession, NX_EncryptionPort, "11111" );

  /* Proxy */
  
  SetStringParameter( pSession, NX_ProxyPath, "D:\\Programmi\\nxclient\\bin\\nxproxy.exe" );
  SetStringParameter( pSession, NX_ProxyRoot, "D:\\marco\\progetti\\NX\\nxcompshtest\\nx" );
  SetStringParameter( pSession, NX_ProxyMode, "S" );
  SetStringParameter( pSession, NX_ProxyRender, "0" );
  SetStringParameter( pSession, NX_ProxyUseOptionsFile, "0" );
  SetStringParameter( pSession, NX_ProxyDisplay, "localhost:0" );

  /* XServer */
  SetStringParameter( pSession, NX_XServerPath, "D:\\Programmi\\nxclient\\bin\\nxwin.exe" );
  SetStringParameter( pSession, NX_XServerName, "nxwin.exe" );
  SetStringParameter( pSession, NX_XServerPort, ":0" );
 
  SetStringParameter( pSession, NX_XServer_FirstCustomOption, "-emulate3buttons" );
  SetStringParameter( pSession, NX_XServer_FirstCustomOption + 1, "-agent" );
  SetStringParameter( pSession, NX_XServer_FirstCustomOption + 2, "-hide" );
  SetStringParameter( pSession, NX_XServer_FirstCustomOption + 3 , "-noreset" );
  SetStringParameter( pSession, NX_XServer_FirstCustomOption + 4 , "-ac" );

  return NX_Ok;


}

