/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2006 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

//
// Include the template for
// this message class.
//

#include "RenderAddGlyphs.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

#include MESSAGE_TAGS

//
// Message handling methods.
//

MESSAGE_BEGIN_ENCODE_SIZE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  encodeBuffer.encodeCachedValue((size - MESSAGE_OFFSET) >> 2, 16,
                     clientCache -> renderLengthCache, 5);

  #ifdef TEST
  *logofs << name() << ": Encoded size with value "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_SIZE

MESSAGE_BEGIN_DECODE_SIZE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  decodeBuffer.decodeCachedValue(size, 16,
                     clientCache -> renderLengthCache, 5);

  size = MESSAGE_OFFSET + (size << 2);

  buffer = writeBuffer -> addMessage(size);

  #ifdef TEST
  *logofs << name() << ": Decoded size with value "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_SIZE

MESSAGE_BEGIN_ENCODE_MESSAGE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  encodeBuffer.encodeCachedValue(GetULONG(buffer + 4, bigEndian), 29,
                     clientCache -> renderGlyphSetCache);

  encodeBuffer.encodeCachedValue(GetULONG(buffer + 8, bigEndian), 32,
                     clientCache -> renderNumGlyphsCache, 8);

  #ifdef TEST
  *logofs << name() << ": Encoded message. Type is "
          << (unsigned int) *(buffer + 1) << " size is "
          << size << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_MESSAGE

MESSAGE_BEGIN_DECODE_MESSAGE
{
  ClientCache *clientCache = (ClientCache *) channelCache;

  unsigned int value;

  *(buffer + 1) = type;

  decodeBuffer.decodeCachedValue(value, 29,
                     clientCache -> renderGlyphSetCache);

  PutULONG(value, buffer + 4, bigEndian);

  decodeBuffer.decodeCachedValue(value, 32,
                     clientCache -> renderNumGlyphsCache, 8);

  PutULONG(value, buffer + 8, bigEndian);

  #ifdef TEST
  *logofs << name() << ": Decoded message. Type is "
          << (unsigned int) type << " size is " << size
          << ".\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_MESSAGE

MESSAGE_BEGIN_ENCODE_DATA
{
  encodeCharData(encodeBuffer, buffer, MESSAGE_OFFSET,
                     size, bigEndian, channelCache);

  #ifdef TEST
  *logofs << name() << ": Encoded " << size - MESSAGE_OFFSET
          << " bytes of data.\n" << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_DATA

MESSAGE_BEGIN_DECODE_DATA
{
  decodeCharData(decodeBuffer, buffer, MESSAGE_OFFSET,
                     size, bigEndian, channelCache);

  #ifdef TEST
  *logofs << name() << ": Decoded " << size - MESSAGE_OFFSET
          << " bytes of data.\n" << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_DATA

MESSAGE_BEGIN_PARSE_IDENTITY
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  renderExtension -> data.add_glyphs.type = *(buffer + 1);

  renderExtension -> data.add_glyphs.set_id  = GetULONG(buffer + 4, bigEndian);
  renderExtension -> data.add_glyphs.num_elm = GetULONG(buffer + 8,  bigEndian);

  //
  // Clean the padding bytes.
  //

  if (size > MESSAGE_OFFSET)
  {
    #ifdef TEST
    *logofs << name() << ": Cleaning the message with size "
            << size << " and size " << renderExtension -> size_
            << ".\n" << logofs_flush;
    #endif

    unsigned int nglyphs = renderExtension -> data.add_glyphs.num_elm;

    unsigned char *gids = (unsigned char *) buffer + 12;

    unsigned char *gi = gids + nglyphs * 4;

    unsigned char *bits = gi + nglyphs * 12;

    #ifdef TEST
    *logofs << name() << ": Glyphs are " << nglyphs << " gids at "
            << gids - buffer << " gi at " << gi - buffer << " bits at "
            << bits - buffer << ".\n" << logofs_flush;
    #endif

    unsigned int remain = size - 12;

    remain -= (4 + 12) * nglyphs;

    unsigned int width  = 0;
    unsigned int height = 0;

    //
    // Don't clean the padding if the glyphs do
    // not have depth 8 or the pixmap byte pad
    // is not 4.
    //
    // TODO: Should run the first loop to deter-
    // mine the offset of each glyph and a se-
    // cond loop cleaning the padding bytes. By
    // knowing the number of glyphs we would be
    // able to determine the depth and the byte
    // pad.
    //

    while (remain > 0 && nglyphs == 1)
    {
      if (gi <= buffer + size - 4)
      {
        width  = GetUINT(gi, bigEndian);
        height = GetUINT(gi + 2, bigEndian);
      }
      #ifdef WARNING
      else
      {
        *logofs << name() << ": WARNING! Glyph geometry at offset "
                << gi - buffer << " is beyond the end of the "
                << "buffer.\n" << logofs_flush;
      }
      #endif

      #ifdef TEST
      *logofs << name() << ": Glyph width is " << width
              << " height " << height << " bytes remaining "
              << remain << ".\n" << logofs_flush;
      #endif

      if (remain >= RoundUp4(width) * height)
      {
        for (unsigned int i = 0; i < height; i++)
        {
          #ifdef TEST
          *logofs << name() << ": Cleaning glyph data at offset "
                  << bits + width - buffer << ".\n"
                  << logofs_flush;
          #endif

          CleanData(bits + width, RoundUp4(width) - width);

          bits += RoundUp4(width);
        }
      }
      #ifdef TEST
      else
      {
        *logofs << name() << ": WARNING! Not cleaning the glyph "
                << "with width " << width << " height " << height
                << " and " << remain << " bytes remaining.\n"
                << logofs_flush;
      }
      #endif

      nglyphs--;

      remain -= RoundUp4(width) * height;

      gi += 12;
    }
  }

  #ifdef TEST
  *logofs << name() << ": Parsed identity. Type is "
          << (unsigned int) renderExtension -> data.add_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_PARSE_IDENTITY

MESSAGE_BEGIN_UNPARSE_IDENTITY
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  *(buffer + 1) = renderExtension -> data.add_glyphs.type;

  PutULONG(renderExtension -> data.add_glyphs.set_id,  buffer + 4,  bigEndian);
  PutULONG(renderExtension -> data.add_glyphs.num_elm, buffer + 8,  bigEndian);

  #ifdef TEST
  *logofs << name() << ": Unparsed identity. Type is "
          << (unsigned int) renderExtension -> data.add_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_UNPARSE_IDENTITY

MESSAGE_BEGIN_IDENTITY_CHECKSUM
{
  md5_append(md5_state, buffer + 1, 3);
  md5_append(md5_state, buffer + 8, 4);
}
MESSAGE_END_IDENTITY_CHECKSUM

MESSAGE_BEGIN_ENCODE_UPDATE
{
  RenderExtensionMessage *renderExtension       = (RenderExtensionMessage *) message;
  RenderExtensionMessage *cachedRenderExtension = (RenderExtensionMessage *) cachedMessage;

  ClientCache *clientCache = (ClientCache *) channelCache;

  encodeBuffer.encodeCachedValue(renderExtension -> data.add_glyphs.set_id, 29,
                     clientCache -> renderGlyphSetCache);

  cachedRenderExtension -> data.add_glyphs.set_id =
              renderExtension -> data.add_glyphs.set_id;

  #ifdef TEST
  *logofs << name() << ": Encoded update. Type is "
          << (unsigned int) renderExtension -> data.add_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_ENCODE_UPDATE

MESSAGE_BEGIN_DECODE_UPDATE
{
  RenderExtensionMessage *renderExtension = (RenderExtensionMessage *) message;

  ClientCache *clientCache = (ClientCache *) channelCache;

  decodeBuffer.decodeCachedValue(renderExtension -> data.add_glyphs.set_id, 29,
                     clientCache -> renderGlyphSetCache);

  #ifdef TEST
  *logofs << name() << ": Decoded update. Type is "
          << (unsigned int) renderExtension -> data.add_glyphs.type
          << " size is " << renderExtension -> size_ << ".\n"
          << logofs_flush;
  #endif
}
MESSAGE_END_DECODE_UPDATE
