/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Keeper_H
#define Keeper_H

#include "Misc.h"
#include "Types.h"

//
// Set the verbosity level.
//

#define PANIC
#undef  TEST

//
// Define this to know how many file
// nodes are allocated and deallocated.
//

#undef  REFERENCES

class Keeper;

class File
{
  friend class Keeper;

  public:

  File();

  ~File();

  //
  // Allow sort by time and size. If time
  // is the same, keep the bigger element.
  //

  bool compare(File *b) const;

  private:

  char *name_;

  int    size_;
  time_t time_;
};

class Keeper
{
  public:

  Keeper(int caches, int images, const char *root, int sleep);

  ~Keeper();

  //
  // Call this just once.
  //

  int keepCaches();

  //
  // Call this at a given interval.
  //

  int keepImages();

  private:

  //
  // Get a list of files in directory.
  //
  
  int collect(const char *path);

  //
  // At each run reduce total disk con-
  // sumption by a further 2% in respect
  // to requested size.
  //

  int threshold(int s)
  {
    return s - s / 50;
  }

  //
  // Sort the collected files according to
  // last modification time and delete the
  // older ones until disk size is below
  // the threshold.
  //

  int cleanup(int threshold);

  //
  // Empty the files repository.
  //

  void empty();

  //
  // Size in bytes of total allowed
  // storage for persistent caches.
  //

  int caches_;

  //
  // Size in bytes of total allowed
  // storage for images cache.
  //

  int images_;

  //
  // Path of NX root directory.
  //

  char *root_;

  //
  // The little delay to be introduced
  // before reading a new entry.
  //

  int sleep_;

  //
  // Total size of files in repository.
  //

  int total_;

  //
  // Repository where to collect files.
  //

  T_files *files_;
};

#endif /* Keeper_H */

