/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "scrnintstr.h"
#include "fontstruct.h"
#include "mistruct.h"
#include "region.h"

#include "Agent.h"

#include "Display.h"
#include "GC.h"
#include "GCOps.h"
#include "Drawable.h"
#include "Font.h"
#include "Color.h"

#include "../../fb/fb.h"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

int nxagentGCPrivateIndex;
extern Bool nxagentTrue24;

#ifdef NXAGENT_GCOPTIMIZE
int nDiscarded;
#endif

#ifdef NXAGENT_RECONNECT
extern void nxagentReConnectPixmap(void*, XID, void*);
static void nxagentGCReConnect(void*, XID, void*);
static Bool nxagentGCsCreation(void);
static void nxagentDummyChangeClip(GCPtr, int, pointer, int);
#endif

static GCFuncs nxagentFuncs = {
  nxagentValidateGC,
  nxagentChangeGC,
  nxagentCopyGC,
  nxagentDestroyGC,
  nxagentChangeClip,
  nxagentDestroyClip,
  nxagentCopyClip,
};

static GCOps nxagentOps = {
  nxagentFillSpans,
  nxagentSetSpans,
  nxagentPutImage,
  nxagentCopyArea,
  nxagentCopyPlane,
  nxagentPolyPoint,
  nxagentPolylines,
  nxagentPolySegment,
  nxagentPolyRectangle,
  nxagentPolyArc,
  nxagentFillPolygon,
  nxagentPolyFillRect,
  nxagentPolyFillArc,
  nxagentPolyText8,
  nxagentPolyText16,
  nxagentImageText8,
  nxagentImageText16,
  nxagentImageGlyphBlt,
  nxagentPolyGlyphBlt,
  nxagentPushPixels
};

Bool nxagentCreateGC(pGC)
     GCPtr pGC;
{
  pGC->clientClipType = CT_NONE;
  pGC->clientClip = NULL;

  pGC->funcs = &nxagentFuncs;
  pGC->ops = &nxagentOps;

  pGC->miTranslate = 1;

  nxagentGCPriv(pGC)->gc = XCreateGC(nxagentDisplay,
                                   nxagentDefaultDrawables[pGC->depth],
                                   0L, NULL);

#ifdef NXAGENT_MVFB
{
   FbGCPrivPtr pPriv;

#ifdef NXAGENT_MVFB_DEBUG
      fprintf(stderr, "nxagentCreateGC: GC [%lx]\n", pGC);
#endif

   pPriv = (pGC)->devPrivates[fbGCPrivateIndex].ptr;

   fbGetRotatedPixmap(pGC) = 0;
   fbGetExpose(pGC) = 1;
   fbGetFreeCompClip(pGC) = 0;
   fbGetCompositeClip(pGC) = 0;

   pPriv->bpp = BitsPerPixel (pGC->depth);
}
#endif

  nxagentGCPriv(pGC)->nClipRects = 0;
#ifdef NXAGENT_GCOPTIMIZE
  memset(&(nxagentGCPriv(pGC) -> lastServerValues),0,sizeof(XGCValues));
#endif
  return True;
}

void nxagentValidateGC(pGC, changes, pDrawable)
     GCPtr pGC;
     unsigned long changes;
     DrawablePtr pDrawable;
{
  PixmapPtr lastTile, lastStipple;

  DrawablePtr pVirtual = (pDrawable -> type == DRAWABLE_PIXMAP) ?
                          nxagentVirtualDrawable(pDrawable) :
                          pDrawable;

  #ifdef TEST
  fprintf(stderr, "nxagentValidateGC: Going to validate GC at [%p] for drawable at [%p] with changes [%lx].\n",
              (void *) pGC, (void *) pDrawable, changes);
  #endif

  pGC->lastWinOrg.x = pDrawable->x;
  pGC->lastWinOrg.y = pDrawable->y;

#ifdef NXAGENT_MVFB

  lastTile = pGC->tile.pixmap;
  lastStipple = pGC->stipple;

  if (lastStipple)
    pGC->stipple = nxagentVirtualPixmap(pGC->stipple);

  #ifdef TEST
  fprintf(stderr, "nxagentValidateGC: Drawable at [%p] has type [%s] virtual [%p] bits per pixel [%d].\n",
              (void *) pDrawable, (pDrawable -> type == DRAWABLE_PIXMAP) ? "PIXMAP" : "WINDOW",
                  (void *) pVirtual, pVirtual -> bitsPerPixel);
  #endif

  if (pVirtual -> bitsPerPixel == 0)
  {
    /*
     * Don't enter fbValidateGC() with 0 bpp
     * or agent will block in a endless loop.
     */

    #ifdef WARNING
    fprintf(stderr, "nxagentValidateGC: WARNING! Virtual drawable at [%p] has invalid bits per pixel.\n",
                (void *) pVirtual);

    fprintf(stderr, "nxagentValidateGC: WARNING! While validating GC at [%p] for drawable at [%p] with changes [%lx].\n",
                (void *) pGC, (void *) pDrawable, changes);

    fprintf(stderr, "nxagentValidateGC: WARNING! Bad drawable at [%p] has type [%s] virtual [%p] bits per pixel [%d].\n",
                (void *) pDrawable, (pDrawable -> type == DRAWABLE_PIXMAP) ? "PIXMAP" : "WINDOW",
                    (void *) pVirtual, pVirtual -> bitsPerPixel);
    #endif
  }
  else
  {
    fbValidateGC(pGC, changes, pVirtual);
  }

  if (pGC->tile.pixmap != lastTile)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentValidateGC: WARNING! Transforming pixmap at [%p] virtual at [%p] "
                "in virtual pixmap.\n", (void *) nxagentPixmapPriv(pGC -> tile.pixmap) -> pRealPixmap,
                    (void *) nxagentPixmapPriv(pGC -> tile.pixmap) -> pRealPixmap);
    #endif

#ifdef NXAGENT_MVFB_DEBUG
    fprintf(stderr, "nxagentValidateGC: GC [%lx] new tile [%x] from fb set as virtual\n", pGC, pGC->tile.pixmap);
#endif

    nxagentPixmapIsVirtual(pGC->tile.pixmap) = True;
    nxagentRealPixmap(pGC->tile.pixmap) = nxagentRealPixmap(lastTile);

    if (nxagentRealPixmap(lastTile))
    {
      nxagentPixmapPriv(nxagentRealPixmap(lastTile))->pVirtualPixmap = pGC->tile.pixmap;
    }
  }

  pGC->stipple = lastStipple;

#endif
}

void nxagentChangeGC(pGC, mask)
     GC *pGC;
     unsigned long mask;
{
  XGCValues values;

#ifdef NXAGENT_GCOPTIMIZE
  int changeFlag=0;
#endif

  if (mask & GCFunction)
  {
    values.function = pGC->alu;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag |= nxagentTestGC(alu, function);
#endif
  }

  if (mask & GCPlaneMask)
  {
    values.plane_mask = pGC->planemask;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(planemask, plane_mask);
#endif
  }

  if (mask & GCForeground)
  {
    values.foreground = nxagentPixel(pGC->fgPixel);
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += (values.foreground == nxagentGCPriv(pGC) -> lastServerValues.foreground)?0:1;
    nxagentGCPriv(pGC) -> lastServerValues.foreground=values.foreground;
#endif
  }

  if (mask & GCBackground)
  {
    values.background = nxagentPixel(pGC->bgPixel);
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += (values.background == nxagentGCPriv(pGC) -> lastServerValues.background)?0:1;
    nxagentGCPriv(pGC) -> lastServerValues.background=values.background;
#endif
  }

  if (mask & GCLineWidth)
  {
    values.line_width = pGC->lineWidth;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(lineWidth, line_width);
#endif
  }

  if (mask & GCLineStyle)
  {
    values.line_style = pGC->lineStyle;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(lineStyle, line_style);
#endif
  }

  if (mask & GCCapStyle)
  {
    values.cap_style = pGC->capStyle;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(capStyle, cap_style);
#endif
  }

  if (mask & GCJoinStyle)
  {
    values.join_style = pGC->joinStyle;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(joinStyle, join_style);
#endif
  }

  if (mask & GCFillStyle)
  {
    values.fill_style = pGC->fillStyle;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(fillStyle, fill_style);
#endif
  }

  if (mask & GCFillRule)
  {
    values.fill_rule = pGC->fillRule;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(fillRule, fill_rule);
#endif
  }

  if (mask & GCTile)
  {
    if (pGC->tileIsPixel)
    {
      mask &= ~GCTile;
    }
    else
    {
      values.tile = nxagentPixmap(pGC->tile.pixmap);

#ifdef NXAGENT_MVFB
      pGC->tile.pixmap = nxagentVirtualPixmap(pGC->tile.pixmap);
#ifdef NXAGENT_MVFB_DEBUG
      fprintf(stderr, "nxagentChangeGC: new tile on GC [%x] tile is [%lx]\n", pGC, pGC->tile.pixmap);
#endif
#endif
    }
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += (values.tile == nxagentGCPriv(pGC) -> lastServerValues.tile)?0:1;
    nxagentGCPriv(pGC) -> lastServerValues.tile = values.tile;
#endif
  }

  if (mask & GCStipple)
  {
    values.stipple = nxagentPixmap(pGC->stipple);

#ifdef NXAGENT_MVFB
    pGC->stipple = nxagentVirtualPixmap(pGC->stipple);
#ifdef NXAGENT_MVFB_DEBUG
      fprintf(stderr, "nxagentChangeGC: new stipple on GC [%x] tile is [%lx]\n", pGC, pGC->stipple);
#endif
#endif
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += (values.stipple == nxagentGCPriv(pGC) -> lastServerValues.stipple)? 0 : 1;
    nxagentGCPriv(pGC) -> lastServerValues.stipple = values.stipple;
#endif
  }

  if (mask & GCTileStipXOrigin)
  {
    values.ts_x_origin = pGC->patOrg.x;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(patOrg.x, ts_x_origin);
#endif
  }

  if (mask & GCTileStipYOrigin)
  {
    values.ts_y_origin = pGC->patOrg.y;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(patOrg.y, ts_y_origin);
#endif
  }

  if (mask & GCFont)
  {
    values.font = nxagentFont(pGC->font);
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += (values.font == nxagentGCPriv(pGC) -> lastServerValues.font)? 0 : 1;
    nxagentGCPriv(pGC) -> lastServerValues.font = values.font;
#endif
  }

  if (mask & GCSubwindowMode)
  {
    values.subwindow_mode = pGC->subWindowMode;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(subWindowMode, subwindow_mode);
#endif
  }

  if (mask & GCGraphicsExposures)
  {
    values.graphics_exposures = pGC->graphicsExposures;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(graphicsExposures, graphics_exposures);
#endif
  }

  if (mask & GCClipXOrigin)
  {
    values.clip_x_origin = pGC->clipOrg.x;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(clipOrg.x, clip_x_origin);
#endif
  }

  if (mask & GCClipYOrigin)
  {
    values.clip_y_origin = pGC->clipOrg.y;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(clipOrg.y, clip_y_origin);
#endif
  }

  if (mask & GCClipMask)
  { /* this is handled in change clip */
    mask &= ~GCClipMask;
  }

  if (mask & GCDashOffset)
  {
    values.dash_offset = pGC->dashOffset;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(dashOffset, dash_offset);
#endif
  }

  if (mask & GCDashList) {
    mask &= ~GCDashList;
    XSetDashes(nxagentDisplay, nxagentGC(pGC),
               pGC->dashOffset, (char *)pGC->dash, pGC->numInDashList);
  }

  if (mask & GCArcMode)
  {
    values.arc_mode = pGC->arcMode;
#ifdef NXAGENT_GCOPTIMIZE
    changeFlag += nxagentTestGC(arcMode, arc_mode);
#endif
  }

#ifdef NXAGENT_GCOPTIMIZE
  if (mask && changeFlag)
  {
    XChangeGC(nxagentDisplay, nxagentGC(pGC), mask, &values);
  }
#ifdef NXAGENT_GCOPTIMIZE_DEBUG
  else if (mask)
    fprintf(stderr, "ChangeGC: discarded = %d Mask=%d\n", ++nDiscarded, mask);
#endif
#else /*GCOPTIMIZE*/
  if (mask)
  {
    XChangeGC(nxagentDisplay, nxagentGC(pGC), mask, &values);
  }

#endif
}

void nxagentCopyGC(pGCSrc, mask, pGCDst)
     GCPtr pGCSrc;
     unsigned long mask;
     GCPtr pGCDst;
{
#ifdef NXAGENT_MVFB
#ifdef NXAGENT_MVFB_DEBUG
   fprintf(stderr, "nxagentCopyGC: going to copy GC\n");
#endif
/*   miCopyGC(pGCSrc, mask, pGCDst);*/
#endif
  XCopyGC(nxagentDisplay, nxagentGC(pGCSrc), mask, nxagentGC(pGCDst));

}

void nxagentDestroyGC(pGC)
     GC *pGC;
{
#ifdef NXAGENT_MVFB_DEBUG
  fprintf(stderr, "nxagentDestroyGC: GC [%lx]\n", pGC);
#endif
  XFreeGC(nxagentDisplay, nxagentGC(pGC));
  miDestroyGC(pGC);
}

void nxagentChangeClip(pGC, type, pValue, nRects)
     GCPtr pGC;
     int type;
     pointer pValue;
     int nRects;
{
  int i, size;
  BoxPtr pBox;
  XRectangle *pRects;

#ifdef NXAGENT_MVFB_DEBUG
   fprintf(stderr, "nxagentChangeClip: going to change clip on GC [%lx]\n", pGC);
#endif

  nxagentDestroyClipHelper(pGC);

  switch(type)
    {
    case CT_NONE:
      XSetClipMask(nxagentDisplay, nxagentGC(pGC), None);
      break;

    case CT_REGION:
      nRects = REGION_NUM_RECTS((RegionPtr)pValue);
      size = nRects * sizeof(*pRects);
      pRects = (XRectangle *) xalloc(size);
      pBox = REGION_RECTS((RegionPtr)pValue);
      for (i = nRects; i-- > 0;) {
        pRects[i].x = pBox[i].x1;
        pRects[i].y = pBox[i].y1;
        pRects[i].width = pBox[i].x2 - pBox[i].x1;
        pRects[i].height = pBox[i].y2 - pBox[i].y1;
      }
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC), 0, 0,
                         pRects, nRects, Unsorted);
      xfree((char *) pRects);
      break;

    case CT_PIXMAP:
      XSetClipMask(nxagentDisplay, nxagentGC(pGC),
                   nxagentPixmap((PixmapPtr)pValue));
      /*
       * Need to change into region, so subsequent uses are with
       * current pixmap contents.
       */

#if defined(NXAGENT_GCHACK) && !defined(NXAGENT_MVFB)
        {
          register RegionPtr pReg;

          pReg = REGION_CREATE(pValue->drawable.pScreen, NULL, 1);

          pGC->clientClip = pReg;

        }
#else
        {
          pGC->clientClip =
            (pointer) (*pGC->pScreen->BitmapToRegion)((PixmapPtr)pValue);
        }
#endif

      (*pGC->pScreen->DestroyPixmap)((PixmapPtr)pValue);
      pValue = pGC->clientClip;
      type = CT_REGION;

      break;

    case CT_UNSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, Unsorted);
      break;

    case CT_YSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YSorted);
      break;

    case CT_YXSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YXSorted);
      break;

    case CT_YXBANDED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YXBanded);
      break;
    }

  switch(type)
    {
    default:
      break;

    case CT_UNSORTED:
    case CT_YSORTED:
    case CT_YXSORTED:
    case CT_YXBANDED:

      /*
       * other parts of server can only deal with CT_NONE,
       * CT_PIXMAP and CT_REGION client clips.
       */

      pGC->clientClip = (pointer) RECTS_TO_REGION(pGC->pScreen, nRects,
                                                  (xRectangle *)pValue, type);
      xfree(pValue);
      pValue = pGC->clientClip;
      type = CT_REGION;

      break;
    }

  pGC->clientClipType = type;
  pGC->clientClip = pValue;
/*
#ifdef NXAGENT_MVFB
   fprintf(stderr, "nxagentChangeClip: going to change clip GC\n");
  if (type == CT_PIXMAP)
    miChangeClip(pGC, type,(type == CT_PIXMAP)?nxagentVirtualPixmap((PixmapPtr)pValue) : pValue, nRects);
#endif
*/
 nxagentGCPriv(pGC)->nClipRects = nRects;
}

void nxagentDestroyClip(pGC)
     GCPtr pGC;
{
#ifdef NXAGENT_MVFB

  miDestroyClip(pGC);

#endif

  if (pGC->clientClipType == CT_PIXMAP)
  {
     (*pGC->pScreen->DestroyPixmap) ((PixmapPtr) (pGC->clientClip));
  }

  nxagentDestroyClipHelper(pGC);
  XSetClipMask(nxagentDisplay, nxagentGC(pGC), None);

  pGC->clientClipType = CT_NONE;
  pGC->clientClip = NULL;
  nxagentGCPriv(pGC)->nClipRects = 0;
}

void nxagentDestroyClipHelper(pGC)
     GCPtr pGC;
{
  switch (pGC->clientClipType)
    {
    default:
    case CT_NONE:
       break;
    case CT_REGION:
      REGION_DESTROY(pGC->pScreen, pGC->clientClip);
      break;
    }
}

void nxagentCopyClip(pGCDst, pGCSrc)
     GCPtr pGCSrc;
     GCPtr pGCDst;
{
  RegionPtr pRgn;

  #ifdef TEST
  fprintf(stderr, "nxagentCopyClip: Going to copy clip from GC [%p] to GC [%p]\n",
              (void *) pGCDst, (void *) pGCSrc);
  #endif

/*
#ifdef NXAGENT_MVFB
  if (pGCSrc->clientClipType == CT_PIXMAP && pGCDst->clientClipType == CT_PIXMAP);
    miCopyClip(pGCDst, pGCSrc);
#endif
*/

  switch (pGCSrc->clientClipType)
    {
    default:
    case CT_PIXMAP:

/*
GFPZR: This used to increment the reference counter
       of the virtual pixmap. I'm not sure this is
       needed.

#ifdef NXAGENT_MVFB
       nxagentVirtualPixmap(((PixmapPtr) pGCSrc->clientClip))->refcnt++;
#endif
*/
      #ifdef WARNING
      fprintf(stderr, "nxagentCopyClip: WARNING! Not incrementing counter for virtual pixmap at [%p].\n",
                  (void *) nxagentVirtualPixmap((PixmapPtr) pGCSrc->clientClip));
      #endif
/*
GFPZR: Note also that both the default and the case
       CT_PIXMAP statements do not have a break, so
       we always call nxagentDestroyClip() as in
       CT_NONE.
*/

    case CT_NONE:
      nxagentDestroyClip(pGCDst);
      break;

    case CT_REGION:
      pRgn = REGION_CREATE(pGCDst->pScreen, NULL, 1);
      REGION_COPY(pGCDst->pScreen, pRgn, pGCSrc->clientClip);
      nxagentChangeClip(pGCDst, CT_REGION, pRgn, 0);
      break;
    }

}

#ifdef NXAGENT_RECONNECT

static Bool nxagentScratchGCsCreate(void)
{
  int i;
  /* FIXME: We are just implementing for only one screen!!. */
  ScreenPtr pScreen = screenInfo.screens[0];
  Bool succeding = True;

  for (i=0; (i <= pScreen->numDepths) && succeding; i++)
  {
#ifdef NXAGENT_RECONNECT_GC_DEBUG
    fprintf(stderr, "nxagentScratchGCsCreate: Creating scratch for depth %d\n",
             pScreen->GCperDepth[i]->depth);
#endif

    if (nxagentGC(pScreen->GCperDepth[i]))
      fprintf(stderr, "nxagentScratchGCsCreate: cleaning after disconnection, of scratchGCs not seem to be happened\n");

    if (0 && (pScreen->rgf & (1L << (i+1))))
       nxagentGCReConnect(pScreen->GCperDepth[i], (XID)0, &succeding);
    else
    {
      /* This scratch is not used. */
#ifdef NXAGENT_RECONNECT_GC_DEBUG
      fprintf(stderr, "nxagentScratchGCsCreate: not used drawable_ID %lx\n",
                      nxagentDefaultDrawables[pScreen->GCperDepth[i]->depth]);
#endif
      if (!(nxagentGC(pScreen->GCperDepth[i]) = 
             XCreateGC(nxagentDisplay,
                       nxagentDefaultDrawables[pScreen->GCperDepth[i]->depth],
                       0, NULL)))
        succeding = False;
#ifdef NXAGENT_RECONNECT_GC_DEBUG
      /* FIXME: REMOVEME */
      XSync(nxagentDisplay, False);
      /* end REMOVEME */
#endif
    }
#ifdef NXAGENT_RECONNECT_GC_DEBUG
    fprintf(stderr, "nxagentScratchGCsCreate: XCreateGC returned %p\n",
            nxagentGC(pScreen->GCperDepth[i]));
    fprintf(stderr, "nxagentScratchGCsCreate: Drawable ID %lx\n", 
                    nxagentDefaultDrawables[pScreen->GCperDepth[i]->depth]);
#endif
  }
#ifdef NXAGENT_RECONNECT_GC_DEBUG
  /* FIXME: REMOVEME */
  XSync(nxagentDisplay, False);
  /* end REMOVEME */
  fprintf(stderr, "nxagentScratchGCsCreate: exiting\n");
#endif
  return succeding;
}

static void nxagentGCReConnect(void *param0, XID param1, pointer param2)
{
  XGCValues values;
  unsigned long valuemask;
  GCPtr pGC = (GCPtr) param0;
  Bool *pBool = (Bool*)param2;

  if (pGC == NULL || !*pBool)
    return;

  if (nxagentGC(pGC))
    fprintf(stderr, "nxagentGCReConnect: cleaning after disconnection, of GCs not seem to be happened\n");

#ifdef NXAGENT_RECONNECT_GC_DEBUG
  fprintf(stderr, "nxagentGCReConnect: %p\n", pGC);
#endif

  valuemask = 0;
  memset(&values,0,sizeof(XGCValues));
  values.function = pGC->alu;
  valuemask |= GCFunction;
  values.plane_mask = pGC->planemask;
  valuemask |= GCPlaneMask;
  values.foreground = nxagentPixel(pGC->fgPixel);
  valuemask |= GCForeground;
  values.background = nxagentPixel(pGC->bgPixel);
  valuemask |= GCBackground;

  values.line_width = pGC->lineWidth;
  valuemask |= GCLineWidth;
  values.line_style = pGC->lineStyle;
  valuemask |= GCLineStyle;
  values.cap_style = pGC->capStyle;
  valuemask |= GCCapStyle;
  values.join_style = pGC->joinStyle;
  valuemask |= GCJoinStyle;
  values.fill_style = pGC->fillStyle;
  valuemask |= GCFillStyle;
  values.fill_rule = pGC->fillRule;
  valuemask |= GCFillRule;
  if (!pGC->tileIsPixel  && (pGC->tile.pixmap != NULL))
  {
      if (nxagentPixmapIsVirtual(pGC->tile.pixmap))
      values.tile = nxagentPixmap(nxagentRealPixmap(pGC->tile.pixmap));
     else
      values.tile = nxagentPixmap(pGC->tile.pixmap);

      valuemask |= GCTile;
  }
  if (pGC->stipple != NULL)
  {
    
    if (nxagentPixmapIsVirtual(pGC->stipple))
    {
      if (nxagentPixmap(nxagentRealPixmap(pGC -> stipple)) == 0)
        nxagentReConnectPixmap(nxagentRealPixmap(pGC -> stipple), 0, pBool);
      values.stipple = nxagentPixmap(nxagentRealPixmap(pGC->stipple));
    }
    else
    {
      if (nxagentPixmap(pGC -> stipple) == 0)
        nxagentReConnectPixmap(pGC -> stipple, 0, pBool);
      values.stipple = nxagentPixmap(pGC->stipple);
    }
    valuemask |= GCStipple;
  }
  values.ts_x_origin = pGC->patOrg.x;
  valuemask |= GCTileStipXOrigin;
  values.ts_y_origin = pGC->patOrg.y;
  valuemask |= GCTileStipYOrigin;
  if (pGC->font != NULL)
  {
    values.font = nxagentFont(pGC->font);
    valuemask |= GCFont;
  }
  values.subwindow_mode = pGC->subWindowMode;
  valuemask |= GCSubwindowMode;
  values.graphics_exposures = pGC->graphicsExposures;
  valuemask |= GCGraphicsExposures;
  values.clip_x_origin = pGC->clipOrg.x;
  valuemask |= GCClipXOrigin;
  values.clip_y_origin = pGC->clipOrg.y;
  valuemask |= GCClipYOrigin;
  valuemask |= GCClipMask;
  values.dash_offset = pGC->dashOffset;
  valuemask |= GCDashOffset;
  if (pGC->dash != NULL)
  {
     values.dashes = *pGC->dash;
     valuemask |= GCDashList;
  }
  values.arc_mode = pGC->arcMode;
  valuemask |= GCArcMode;

  if ((nxagentGC(pGC) = XCreateGC(nxagentDisplay,
                                nxagentDefaultDrawables[pGC->depth],
                                valuemask, &values)) == NULL)
    *pBool = False;

  nxagentDummyChangeClip(pGC, 
                    pGC -> clientClipType,
                    pGC -> clientClip,
                    nxagentGCPriv(pGC) -> nClipRects);

  /* FIXME: REMOVEME */
#ifdef NXAGENT_RECONNECT_DEBUG
  XSync(nxagentDisplay, False);
#endif
  /* end REMOVEME */
}

Bool nxagentReCreateGCs(void*p0)
{
  int flexibility;

  flexibility = *(int*)p0;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_GC_DEBUG)
  fprintf(stderr, "nxagentReCreatGCs\n");
#endif

  return nxagentGCsCreation();
}

void nxagentDisconnectGC(pointer p0, XID x1, pointer p2)
{
  GCPtr pGC = (GCPtr) p0;
  Bool* pBool = (Bool*) p2;

  if (!*pBool || !pGC)
  {
    if (!pGC) 
      fprintf(stderr, "nxagentDisconnectGC: pGC is NULL\n");
    return;
  }

  /* FIXME: look for memory leak. 
   * Shouldn't  nxagentGC(pGC) have any dinamyc data. But i could be wrong. */ 

  xfree(nxagentGC(pGC));
  nxagentGC(pGC) = NULL;
  
  if (pGC -> stipple)
  {
    PixmapPtr pMap = pGC -> stipple;

    if (nxagentPixmapIsVirtual(pMap))
      nxagentPixmap(nxagentPixmapPriv(pMap) -> pRealPixmap) = 0;
    else
      nxagentPixmap(pMap) = 0;
  }
} 

Bool nxagentDisconnectGCs(void)
{
  int cid, i;
  ScreenPtr pScreen = screenInfo.screens[0];
  Bool success = True;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_GC_DEBUG)
  fprintf(stderr, "nxagentDisconnectGCs\n");
#endif

  for(cid = 0; (cid < MAXCLIENTS) && success; cid++)
  {
    if (clients[cid])
    {
      FindClientResourcesByType(clients[cid], RT_GC, (FindResType)nxagentDisconnectGC, &success);
    }
  }

  for (i=0; (i <= pScreen->numDepths) && success; i++)
  {
#ifdef NXAGENT_RECONNECT_GC_DEBUG
    fprintf(stderr, "nxagentDisconnectGCs: destroying scratch for depth %d\n",
            pScreen->GCperDepth[i]->depth);
#endif
    nxagentDisconnectGC(pScreen->GCperDepth[i], (XID)0, &success);
  }

  return success;
}

static Bool nxagentGCsCreation(void)
{
  int cid;
  Bool GCSuccess = True;

#ifdef NXAGENT_RECONNECT_GC_DEBUG
  fprintf(stderr, "nxagentGCsCreation:\n");
#endif

  if (!nxagentScratchGCsCreate())
    return False;

  for(cid = 0; cid < MAXCLIENTS; cid++)
  {
    if (clients[cid] && GCSuccess)
    {
      FindClientResourcesByType(clients[cid], RT_GC, nxagentGCReConnect, &GCSuccess);
    }
  }
  return GCSuccess;
}

static void nxagentDummyChangeClip(pGC, type, pValue, nRects)
     GCPtr pGC;
     int type;
     pointer pValue;
     int nRects;
{
  int i, size;
  BoxPtr pBox;
  XRectangle *pRects;

#ifdef NXAGENT_MVFB_DEBUG
   fprintf(stderr, "nxagentChangeClip: going to change clip on GC [%lx]\n", pGC);
#endif

  /* nxagentDestroyClipHelper(pGC); */
#ifdef NXAGENT_RECONNECT_GC_DEBUG
  fprintf(stderr, "nxagentDummyChangeClip: type is %s\n",
          (type == CT_NONE) ? "CT_NONE" :
          (type == CT_REGION) ? "CT_REGION" :
          (type == CT_PIXMAP) ? "CT_REGION" :
          "UNKNOWN");
#endif
  switch(type)
    {
    case CT_NONE:
      XSetClipMask(nxagentDisplay, nxagentGC(pGC), None);
      break;

    case CT_REGION:
      nRects = REGION_NUM_RECTS((RegionPtr)pValue);
      size = nRects * sizeof(*pRects);
      pRects = (XRectangle *) xalloc(size);
      pBox = REGION_RECTS((RegionPtr)pValue);
      for (i = nRects; i-- > 0;) {
        pRects[i].x = pBox[i].x1;
        pRects[i].y = pBox[i].y1;
        pRects[i].width = pBox[i].x2 - pBox[i].x1;
        pRects[i].height = pBox[i].y2 - pBox[i].y1;
      }
      /* FIXME: originally the clip origin area were 0,0 but it didn't work with
       * kedit and family, because it got the clip mask of the pixmap all traslated. */
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC), pGC -> clipOrg.x, pGC -> clipOrg.y,
                         pRects, nRects, Unsorted);
      xfree((char *) pRects);
      break;

    case CT_PIXMAP:
      XSetClipMask(nxagentDisplay, nxagentGC(pGC),
                   nxagentPixmap((PixmapPtr)pValue));
      /*
       * Need to change into region, so subsequent uses are with
       * current pixmap contents.
       */

#if defined(NXAGENT_GCHACK) && !defined(NXAGENT_MVFB)
        {
          register RegionPtr pReg;

          pReg = REGION_CREATE(pValue->drawable.pScreen, NULL, 1);

          pGC->clientClip = pReg;

        }
#else
        {
          pGC->clientClip =
            (pointer) (*pGC->pScreen->BitmapToRegion)((PixmapPtr)pValue);
        }
#endif

      (*pGC->pScreen->DestroyPixmap)((PixmapPtr)pValue);
      pValue = pGC->clientClip;
      type = CT_REGION;

      break;

    case CT_UNSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, Unsorted);
      break;

    case CT_YSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YSorted);
      break;

    case CT_YXSORTED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YXSorted);
      break;

    case CT_YXBANDED:
      XSetClipRectangles(nxagentDisplay, nxagentGC(pGC),
                         pGC->clipOrg.x, pGC->clipOrg.y,
                         (XRectangle *)pValue, nRects, YXBanded);
      break;
    }

  switch(type)
    {
    default:
      break;

    case CT_UNSORTED:
    case CT_YSORTED:
    case CT_YXSORTED:
    case CT_YXBANDED:

      /*
       * other parts of server can only deal with CT_NONE,
       * CT_PIXMAP and CT_REGION client clips.
       */

      pGC->clientClip = (pointer) RECTS_TO_REGION(pGC->pScreen, nRects,
                                                  (xRectangle *)pValue, type);
      xfree(pValue);
      pValue = pGC->clientClip;
      type = CT_REGION;

      break;
    }

  pGC->clientClipType = type;
  pGC->clientClip = pValue;
/*
#ifdef NXAGENT_MVFB
   fprintf(stderr, "nxagentChangeClip: going to change clip GC\n");
  if (type == CT_PIXMAP)
    miChangeClip(pGC, type,(type == CT_PIXMAP)?nxagentVirtualPixmap((PixmapPtr)pValue) : pValue, nRects);
#endif
*/
 nxagentGCPriv(pGC)->nClipRects = nRects;
}


#endif
