/*
 * linux/include/asm-sh/sh7760.h
 *
 * Copyright (c) 2003 Lineo Solutions, Inc.
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Renesas SH7760 support.
 */
#ifndef __ASM_SH_SH7760_H
#define __ASM_SH_SH7760_H 1

/* INTC */
#define ICR             0xffd00000
#define IPRA            0xffd00004
#define IPRB            0xffd00008
#define IPRC            0xffd0000c
#define IPRD            0xffd00010
#define INTPRI00        0xfe080000
#define INTPRI04        0xfe080004
#define INTPRI08        0xfe080008
#define INTPRI0C        0xfe08000c
#define INTREQ00        0xfe080020
#define INTREQ04        0xfe080024
#define INTMSK00        0xfe080040
#define INTMSK04        0xfe080044
#define INTMSKCLR00     0xfe080060
#define INTMSKCLR04     0xfe080064

/* BSC */
#define BCR1            0xff800000
#define BCR2            0xff800004
#define BCR3            0xff800050
#define BCR4            0xfe0A00f0
#define WCR1            0xff800008
#define WCR2            0xff80000c
#define WCR3            0xff800010
#define WCR4            0xfe0A0028

#define MCR             0xff800014
#define PCR             0xff800018
#define RTCSR           0xff80001c
#define RTCNT           0xff800020
#define RTCOR           0xff800024
#define RFCR            0xff800028
#define GPIOIC          0xff800048

/* DMAC */
#define DMABRGCR        0xfe3c0000
#define DMAATXSAR0      0xfe3c0040
#define DMAARXDAR0      0xfe3c0044
#define DMAATXTCR0      0xfe3c0048
#define DMAARXTCR0      0xfe3c004c
#define DMAACR0         0xfe3c0050
#define DMAATXTCNT0     0xfe3c0054
#define DMAARXTCNT0     0xfe3c0058
#define DMAATXSAR1      0xfe3c0060
#define DMAARXDAR1      0xfe3c0064
#define DMAATXTCR1      0xfe3c0068
#define DMAARXTCR1      0xfe3c006c
#define DMAACR1         0xfe3c0070
#define DMAATXTCNT1     0xfe3c0074
#define DMAARXTCNT1     0xfe3c0078
#define DMAUSAR         0xfe3c0080
#define DMAUDAR         0xfe3c0084
#define DMAURWSZ        0xfe3c0088
#define DMAUCR          0xfe3c008c
#define SAR0            0xffa00000
#define DAR0            0xffa00004
#define DMATCR0         0xffa00008
#define CHCR0           0xffa0000c
#define SAR1            0xffa00010
#define DAR1            0xffa00014
#define DMATCR1         0xffa00018
#define CHCR1           0xffa0001c
#define SAR2            0xffa00020
#define DAR2            0xffa00024
#define DMATCR2         0xffa00028
#define CHCR2           0xffa0002c
#define SAR3            0xffa00030
#define DAR3            0xffa00034
#define DMATCR3         0xffa00038
#define CHCR3           0xffa0003c
#ifndef DMAOR
#define DMAOR           0xffa00040
#endif
#define SAR4            0xffa00050
#define DAR4            0xffa00054
#define DMATCR4         0xffa00058
#define CHCR4           0xffa0005c
#define SAR5            0xffa00060
#define DAR5            0xffa00064
#define DMATCR5         0xffa00068
#define CHCR5           0xffa0006c
#define SAR6            0xffa00070
#define DAR6            0xffa00074
#define DMATCR6         0xffa00078
#define CHCR6           0xffa0007c
#define SAR7            0xffa00080
#define DAR7            0xffa00084
#define DMATCR7         0xffa00088
#define CHCR7           0xffa0008c
#define DMARSRA         0xfe090000
#define DMARSRB         0xfe090004
#define DMARCR          0xfe090008

/* CPG */
#define FRQCR           0xffc00000
#define STBCR           0xffc00004
#define WTCNT           0xffc00008
#define WTCSR           0xffc0000c
#define STBCR2          0xffc00010
#define CLKSTP00        0xfe0a0000
#define CLKSTPCLR00     0xfe0a0010
#define DCKDR           0xfe0a0020
#define MCKCR           0xfe0a0024

/* CCN */
#define PTEH            0xff000000
#define PTEL            0xff000004
#define TTB             0xff000008
#define TEA             0xff00000c
#ifndef MMUCR
#define MMUCR           0xff000010
#endif
#define BASRA           0xff000014
#define BASRB           0xff000018
#define CCR             0xff00001c
#define TRA             0xff000020
#define EXPEVT          0xff000024
#define INTEVT          0xff000028
#define PTEA            0xff000034
#define QACR0           0xff000038
#define QACR1           0xff00003c

/* TMU */
#define TOCR            0xffd80000
#define TSTR            0xffd80004
#define TCOR0           0xffd80008
#define TCNT0           0xffd8000c
#define TCR0            0xffd80010
#define TCOR1           0xffd80014
#define TCNT1           0xffd80018
#define TCR1            0xffd8001c
#define TCOR2           0xffd80020
#define TCNT2           0xffd80024
#define TCR2            0xffd80028
#define TCPR2           0xffd8002c

/* CMT */
#define CMTCFG          0xfe1c0000
#define CMTFRT          0xfe1c0004
#define CMTCTL          0xfe1c0008
#define CMTIRQS         0xfe1c000c
#define CMTCH0T         0xfe1c0010
#define CMTCH1T         0xfe1c0014
#define CMTCH2T         0xfe1c0018
#define CMTCH3T         0xfe1c001c
#define CMTCH0ST        0xfe1c0020
#define CMTCH1ST        0xfe1c0024
#define CMTCH2ST        0xfe1c0028
#define CMTCH3ST        0xfe1c002c
#define CMTCH0C         0xfe1c0030
#define CMTCH1C         0xfe1c0034
#define CMTCH2C         0xfe1c0038
#define CMTCH3C         0xfe1c003c

/* SCIF */
#define SCSMR0          0xfe600000
#define SCBRR0          0xfe600004
#define SCSCR0          0xfe600008
#define SCFTDR0         0xfe60000c
#define SCFSR0          0xfe600010
#define SCFRDR0         0xfe600014
#define SCFCR0          0xfe600018
#define SCTFDR0         0xfe60001c
#define SCRFDR0         0xfe600020
#define SCSPTR0         0xfe600024
#define SCLSR0          0xfe600028
#define SCRER0          0xfe60002c
#define SCSMR1          0xfe610000
#define SCBRR1          0xfe610004
#define SCSCR1          0xfe610008
#define SCFTDR1         0xfe61000c
#define SCFSR1          0xfe610010
#define SCFRDR1         0xfe610014
#define SCFCR1          0xfe610018
#define SCTFDR1         0xfe61001c
#define SCRFDR1         0xfe610020
#define SCSPTR1         0xfe610024
#define SCLSR1          0xfe610028
#define SCRER1          0xfe61002c
#define SCSMR2          0xfe620000
#define SCBRR2          0xfe620004
#define SCSCR2          0xfe620008
#define SCFTDR2         0xfe62000c
#define SCFSR2          0xfe620010
#define SCFRDR2         0xfe620014
#define SCFCR2          0xfe620018
#define SCTFDR2         0xfe62001c
#define SCRFDR2         0xfe620020
#define SCSPTR2         0xfe620024
#define SCLSR2          0xfe620028
#define SCRER2          0xfe62002c

/* SIM */
#define SISMR           0xfe480000
#define SIBRR           0xfe480002
#define SISCR           0xfe480004
#define SITDR           0xfe480006
#define SISSR           0xfe480008
#define SIRDR           0xfe48000a
#define SISCMR          0xfe48000c
#define SISC2R          0xfe48000e
#define SIWAIT          0xfe480010
#define SIGRD           0xfe480012
#define SISMPL          0xfe480014

/* IIC */
#define ICSCR0          0xfe140000
#define ICMCR0          0xfe140004
#define ICSSR0          0xfe140008
#define ICMSR0          0xfe14000c
#define ICSIER0         0xfe140010
#define ICMIER0         0xfe140014
#define ICCCR0          0xfe140018
#define ICSAR0          0xfe14001c
#define ICMAR0          0xfe140020
#define ICRXD0          0xfe140024
#define ICTXD0          0xfe140024
#define ICFCR0          0xfe140028
#define ICFSR0          0xfe14002c
#define ICFIER0         0xfe140030
#define ICRFDR0         0xfe140034
#define ICTFDR0         0xfe140038
#define ICSCR1          0xfe150000
#define ICMCR1          0xfe150004
#define ICSSR1          0xfe150008
#define ICMSR1          0xfe15000c
#define ICSIER1         0xfe150010
#define ICMIER1         0xfe150014
#define ICCCR1          0xfe150018
#define ICSAR1          0xfe15001c
#define ICMAR1          0xfe150020
#define ICRXD1          0xfe150024
#define ICTXD1          0xfe150024
#define ICFCR1          0xfe150028
#define ICFSR1          0xfe15002c
#define ICFIER1         0xfe150030
#define ICRFDR1         0xfe150034
#define ICTFDR1         0xfe150038

/* SSI */
#define SSICR0          0xfe680000
#define SSISR0          0xfe680004
#define SSITDR0         0xfe680008
#define SSIRDR0         0xfe68000c
#define SSICR1          0xfe690000
#define SSISR1          0xfe690004
#define SSITDR1         0xfe690008
#define SSIRDR1         0xfe69000c

/* USB */    
#define USBH_BASE       0xfe340000

/* HCAN2 */
#define CAN0MCR         0xfe380000
#define CAN0GSR         0xfe380002
#define CAN0BCR1        0xfe380004
#define CAN0BCR0        0xfe380006
#define CAN0IRR         0xfe380008
#define CAN0IMR         0xfe38000a
#define CAN0TECREC      0xfe38000c
#define CAN0TXPR1       0xfe380020
#define CAN0TXPR0       0xfe380022
#define CAN0TXCR1       0xfe380028
#define CAN0TXCR0       0xfe38002a
#define CAN0TXACK1      0xfe380030
#define CAN0TXACK0      0xfe380032
#define CAN0ABACK1      0xfe380038
#define CAN0ABACK0      0xfe38003a
#define CAN0RXPR1       0xfe380040
#define CAN0RXPR0       0xfe380042
#define CAN0RFPR1       0xfe380048
#define CAN0RFPR0       0xfe38004a
#define CAN0MBIMR1      0xfe380050
#define CAN0MBIMR0      0xfe380052
#define CAN0UMSR1       0xfe380058
#define CAN0UMSR0       0xfe38005a
#define CAN0TCNTR       0xfe380080
#define CAN0TCR         0xfe380082
#define CAN0TSR         0xfe380084
#define CAN0TDCR        0xfe380086
#define CAN0LOSR        0xfe380088
#define CAN0ICR1        0xfe38008e
#define CAN0TCMR0       0xfe380090
#define CAN0TCMR1       0xfe380092
#define CAN0TCMR2       0xfe380094
#define CAN0CCR         0xfe380096
#define CAN0CMAX        0xfe380098
#define CAN0TMR         0xfe38009a
#define CAN0MB0         0xfe380100
#define CAN0MB1         0xfe380120
#define CAN0MB2         0xfe380140
#define CAN0MB3         0xfe380160
#define CAN0MB4         0xfe380180
#define CAN0MB5         0xfe3801a0
#define CAN0MB6         0xfe3801c0
#define CAN0MB7         0xfe3801e0
#define CAN0MB8         0xfe380200
#define CAN0MB9         0xfe380220
#define CAN0MB10        0xfe380240
#define CAN0MB11        0xfe380260
#define CAN0MB12        0xfe380280
#define CAN0MB13        0xfe3802a0
#define CAN0MB14        0xfe3802c0
#define CAN0MB15        0xfe3802e0
#define CAN0MB16        0xfe380300
#define CAN0MB17        0xfe380320
#define CAN0MB18        0xfe380340
#define CAN0MB19        0xfe380360
#define CAN0MB20        0xfe380380
#define CAN0MB21        0xfe3803a0
#define CAN0MB22        0xfe3803c0
#define CAN0MB23        0xfe3803e0
#define CAN0MB24        0xfe380400
#define CAN0MB25        0xfe380420
#define CAN0MB26        0xfe380440
#define CAN0MB27        0xfe380460
#define CAN0MB28        0xfe380480
#define CAN0MB29        0xfe3804a0
#define CAN0MB30        0xfe3804c0
#define CAN0MB31        0xfe3804e0
#define CAN1MCR         0xfe390000
#define CAN1GSR         0xfe390002
#define CAN1BCR1        0xfe390004
#define CAN1BCR0        0xfe390006
#define CAN1IRR         0xfe390008
#define CAN1IMR         0xfe39000a
#define CAN1TECREC      0xfe39000c
#define CAN1TXPR1       0xfe390020
#define CAN1TXPR0       0xfe390022
#define CAN1TXCR1       0xfe390028
#define CAN1TXCR0       0xfe39002a
#define CAN1TXACK1      0xfe390030
#define CAN1TXACK0      0xfe390032
#define CAN1ABACK1      0xfe390038
#define CAN1ABACK0      0xfe39003a
#define CAN1RXPR1       0xfe390040
#define CAN1RXPR0       0xfe390042
#define CAN1RFPR1       0xfe390048
#define CAN1RFPR0       0xfe39004a
#define CAN1MBIMR1      0xfe390050
#define CAN1MBIMR0      0xfe390052
#define CAN1UMSR1       0xfe390058
#define CAN1UMSR0       0xfe39005a
#define CAN1TCNTR       0xfe390080
#define CAN1TCR         0xfe390082
#define CAN1TSR         0xfe390084
#define CAN1TDCR        0xfe390086
#define CAN1LOSR        0xfe390088
#define CAN1ICR1        0xfe39008e
#define CAN1TCMR0       0xfe390090
#define CAN1TCMR1       0xfe390092
#define CAN1TCMR2       0xfe390094
#define CAN1CCR         0xfe390096
#define CAN1CMAX        0xfe390098
#define CAN1TMR         0xfe39009a
#define CAN1MB0         0xfe390100
#define CAN1MB1         0xfe390120
#define CAN1MB2         0xfe390140
#define CAN1MB3         0xfe390160
#define CAN1MB4         0xfe390180
#define CAN1MB5         0xfe3901a0
#define CAN1MB6         0xfe3901c0
#define CAN1MB7         0xfe3901e0
#define CAN1MB8         0xfe390200
#define CAN1MB9         0xfe390220
#define CAN1MB10        0xfe390240
#define CAN1MB11        0xfe390260
#define CAN1MB12        0xfe390280
#define CAN1MB13        0xfe3902a0
#define CAN1MB14        0xfe3902c0
#define CAN1MB15        0xfe3902e0
#define CAN1MB16        0xfe390300
#define CAN1MB17        0xfe390320
#define CAN1MB18        0xfe390340
#define CAN1MB19        0xfe390360
#define CAN1MB20        0xfe390380
#define CAN1MB21        0xfe3903a0
#define CAN1MB22        0xfe3903c0
#define CAN1MB23        0xfe3903e0
#define CAN1MB24        0xfe390400
#define CAN1MB25        0xfe390420
#define CAN1MB26        0xfe390440
#define CAN1MB27        0xfe390460
#define CAN1MB28        0xfe390480
#define CAN1MB29        0xfe3904a0
#define CAN1MB30        0xfe3904c0
#define CAN1MB31        0xfe3904e0

/* HSPI */
#define SPCR            0xfe180000
#define SPSR            0xfe180004
#define SPSCR           0xfe180008
#define SPTBR           0xfe18000c
#define SPRBR           0xfe180010

/* GPIO */
#define PACR            0xfe400000
#define PBCR            0xfe400004
#define PCCR            0xfe400008
#define PDCR            0xfe40000c
#define PECR            0xfe400010
#define PFCR            0xfe400014
#define PGCR            0xfe400018
#define PHCR            0xfe40001c
#define PJCR            0xfe400020
#define PKCR            0xfe400024
#define PADR            0xfe400040
#define PBDR            0xfe400044
#define PCDR            0xfe400048
#define PDDR            0xfe40004c
#define PEDR            0xfe400050
#define PFDR            0xfe400054
#define PGDR            0xfe400058
#define PHDR            0xfe40005c
#define PJDR            0xfe400060
#define PKDR            0xfe400064

/* AC97 */
#define AC97CR0         0xfe240008
#define AC97CSAR0       0xfe240020
#define AC97CSDR0       0xfe240024
#define AC97PCML0       0xfe240028
#define AC97PCMR0       0xfe24002c
#define AC97TIER0       0xfe240050
#define AC97TSR0        0xfe240054
#define AC97RIER0       0xfe240058
#define AC97RSR0        0xfe24005c
#define AC97ACR0        0xfe240060
#define AC97CR1         0xfe250008
#define AC97CSAR1       0xfe250020
#define AC97CSDR1       0xfe250024
#define AC97PCML1       0xfe250028
#define AC97PCMR1       0xfe25002c
#define AC97TIER1       0xfe250050
#define AC97TSR1        0xfe250054
#define AC97RIER1       0xfe250058
#define AC97RSR1        0xfe25005c
#define AC97ACR1        0xfe250060

/* MMCIF */
#define CMDR0           0xfe500000
#define CMDR1           0xfe500001
#define CMDR2           0xfe500002
#define CMDR3           0xfe500003
#define CMDR4           0xfe500004
#define CMDR5           0xfe500005
#define CMDSTRT         0xfe500006
#define OPCR            0xfe50000a
#define CSTR            0xfe50000b
#define INTCR0          0xfe50000c
#define INTCR1          0xfe50000d
#define INTSTR0         0xfe50000e
#define INTSTR1         0xfe50000f
#define CLKON           0xfe500010
#define CTOCR           0xfe500011
#define TBCR            0xfe500014
#define MODER           0xfe500016
#define CMDTYR          0xfe500018
#define RSPTYR          0xfe500019
#define TBNCR           0xfe50001a
#define RSPR0           0xfe500020
#define RSPR1           0xfe500021
#define RSPR2           0xfe500022
#define RSPR3           0xfe500023
#define RSPR4           0xfe500024
#define RSPR5           0xfe500025
#define RSPR6           0xfe500026
#define RSPR7           0xfe500027
#define RSPR8           0xfe500028
#define RSPR9           0xfe500029
#define RSPR10          0xfe50002a
#define RSPR11          0xfe50002b
#define RSPR12          0xfe50002c
#define RSPR13          0xfe50002d
#define RSPR14          0xfe50002e
#define RSPR15          0xfe50002f
#define RSPR16          0xfe500030
#define DTOUTR          0xfe500032
#define FIFOCLR         0xfe500042
#define DMACR           0xfe500044
#define INTCR2          0xfe500046
#define INTSTR2         0xfe500048
#define RDTIMSEL        0xfe50004a

/* MFI */
#define MFIIDX          0xfe2c0000
#define MFIGSR          0xfe2c0004
#define MFISCR          0xfe2c0008
#define MFIMCR          0xfe2c000c
#define MFIIICR         0xfe2c0010
#define MFIEICR         0xfe2c0014
#define MFIADR          0xfe2c0018
#define MFIDATA         0xfe2c001c

/* FLCTL */
#define FLCMNCR         0xfe440000
#define FLCMDCR         0xfe440004
#define FLCMCDR         0xfe440008
#define FLADR           0xfe44000c
#define FLDTCNTR        0xfe440010
#define FLDATAR         0xfe440014
#define FLINTDMACR      0xfe440018
#define FLBSYTMR        0xfe44001c
#define FLBSYCNT        0xfe440020
#define FLDTFIFO        0xfe440024
#define FLECFIFO        0xfe440028

/* ADC */
#define FLTRCR          0xfe44002c
#define ADDRA           0xfe280000
#define ADDRB           0xfe280002
#define ADDRC           0xfe280004
#define ADDRD           0xfe280006
#define ADCSR           0xfe280008

/* LCDC */
#define LDICKR          0xfe300c00
#define LDMTR           0xfe300c02
#define LDDFR           0xfe300c04
#define LDSMR           0xfe300c06
#define LDSARU          0xfe300c08
#define LDSARL          0xfe300c0c
#define LDLAOR          0xfe300c10
#define LDPALCR         0xfe300c12
#define LDHCNR          0xfe300c14
#define LDHSYNR         0xfe300c16
#define LDVDLNR         0xfe300c18
#define LDVTLNR         0xfe300c1a
#define LDVSYNR         0xfe300c1c
#define LDACLNR         0xfe300c1e
#define LDINTR          0xfe300c20
#define LDPMMR          0xfe300c24
#define LDPSPR          0xfe300c26
#define LDCNTR          0xfe300c28

/* UBC */
#define BARA            0xff200000
#define BAMRA           0xff200004
#define BBRA            0xff200008
#define BARB            0xff20000c
#define BAMRB           0xff200010
#define BBRB            0xff200014
#define BDRB            0xff200018
#define BDMRB           0xff20001c
#define BRCR            0xff200020

/* PFC */
#define INPUPA          0xfe400028
#define DMAPCR          0xfe40002c
#define SCIHZR          0xfe400030
#define IPSELR          0xfe400034
#define PAPUPR          0xfe400080
#define PBPUPR          0xfe400084
#define PCPUPR          0xfe400088
#define PDPUPR          0xfe40008c
#define PEPUPR          0xfe400090
#define PFPUPR          0xfe400094
#define PGPUPR          0xfe400098
#define PHPUPR          0xfe40009c
#define PJPUPR          0xfe4000a0
#define PKPUPR          0xfe4000a4
#define MDPUPR          0xfe4000a8
#define MODSELR         0xfe4000ac

/* H-UDI */
#define SDIR            0xfff00000
#define SDDR            0xfff00008
#define SDINT           0xfff00014

#endif /* __ASM_SH_SH7760_H */
