/*
 * linux/drivers/mq1100fb-h5400.c
 *
 * Copyright © 2003 Keith Packard
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive for
 * more details.
 *
 *	    MediaQ 1100/1132 LCD Controller Frame Buffer Driver
 *
 * Please direct your questions and comments on this driver to the following
 * email address:
 *
 *	keithp@keithp.com
 *
 * ChangeLog
 *
 * 2003-05-18: <keithp@keithp.com>
 *	- Ported from PCI development board to ARM H5400
 */

#include "mq1100.h"

#define MQ_BASE	0x04000000

/*
 * Some H5400 devices have different LCDs installed that require this
 * other timing.  Phil Blundell was blessed with one of these
 * This is marked in the ENVEE bit (fp[9] & 2), the sharp
 * LCD version has ENVEE bit 0, the phillips has that bit 1.
 */
static MqInitData  mqInitH5400_phillips = {
    /* DC */
    {
	/* dc00 */		0x00000001,
	/* dc01 */		0x00000003,
	/* dc02 */		0x00000001,
	/* dc03 NOT SET */	0x0,
	/* dc04 */		0x00000004,
	/* dc05 */		0x00000003,
    },
    /* CC */
    {
	/* cc00 */		0x00000000,
	/* cc01 */		0x00001010,
	/* cc02 */		0x00000a22,
	/* cc03 */		0x00000000,
	/* cc04 */		0x00000004,
    },
    /* MIU */
    {
	/* mm00 */		0x00000001,
	/* mm01 */		0x1b676ca8,
	/* mm02 */		0x00000000,
	/* mm03 */		0x00001479,
	/* mm04 */		0x6bfc2d76,
    },
    /* GC */
    {
	/* gc00 */		0x051100c8, /* powered down */
	/* gc01 */		0x00000000,
	/* gc02 */		0x00f8013b,
	/* gc03 */		0x013f0150,
	/* gc04 */		0x01370132,
	/* gc05 */		0x01510150,
	/* gc06 */		0x00000000,
	/* gc07 NOT SET */	0x0,
	/* gc08 */		0x00ef0000,
	/* gc09 */		0x013f0000,
	/* gc0a */		0x00000000,
	/* gc0b */		0x006e0037,
	/* gc0c */		0x00000000,
	/* gc0d */		0x00066373,
	/* gc0e */		0x000001e0,
	/* gc0f NOT SET */	0x0,
	/* gc10 */		0x02ff07ff,
	/* gc11 */		0x000000ff,
	/* gc12 NOT SET */	0x0,
	/* gc13 NOT SET */	0x0,
	/* gc14 */		0x00000000,
	/* gc15 */		0x00000000,
	/* gc16 */		0x00000000,
	/* gc17 */		0x00000000,
	/* gc18 */		0x00000000,
	/* gc19 */		0x00000000,
	/* gc1a */		0x00000000,
    },
    /* FP */
    {
	/* fp00 */		0x00006120,
	/* fp01 */		0x00bcc02c,
	/* fp02 */		0xfffcfcfd,
	/* fp03 */		0x00000002,
	/* fp04 */		0x80bd0001,
	/* fp05 */		0xc3000000,
	/* fp06 */		0xa0000000,
	/* fp07 */		0x00040005,
	/* fp08 */		0x00040005,
	/* fp09 NOT SET */	0x0,
	/* fp0a */		0x00000000,
	/* fp0b */		0x00000000,
	/* fp0c NOT SET */	0x0,
	/* fp0d NOT SET */	0x0,
	/* fp0e NOT SET */	0x0,
	/* fp0f */		0x00000120,
	/* fp10 */		0x2645a216,
	/* fp11 */		0x1941d898,
	/* fp12 */		0xc2f5b84c,
	/* fp13 */		0x411585dd,
	/* fp14 */		0xad1d0a85,
	/* fp15 */		0xd7928b26,
	/* fp16 */		0x4848e722,
	/* fp17 */		0x696d0932,
	/* fp18 */		0xf2d20075,
	/* fp19 */		0xd547235e,
	/* fp1a */		0x310304f6,
	/* fp1b */		0x3cef4474,
	/* fp1c */		0x22a3d351,
	/* fp1d */		0x01825700,
	/* fp1e */		0xb7d793d1,
	/* fp1f */		0x10906408,
	/* fp20 */		0x0,
	/* fp21 */		0x0,
	/* fp22 */		0x0,
	/* fp23 */		0x0,
	/* fp24 */		0x0,
	/* fp25 */		0x0,
	/* fp26 */		0x0,
	/* fp27 */		0x0,
	/* fp28 */		0x0,
	/* fp29 */		0x0,
	/* fp2a */		0x0,
	/* fp2b */		0x0,
	/* fp2c */		0x0,
	/* fp2d */		0x0,
	/* fp2e */		0x0,
	/* fp2f */		0x0,
	/* fp30 */		0x7ba9b45b,
	/* fp31 */		0xb56738c3,
	/* fp32 */		0xde47a2ba,
	/* fp33 */		0x88241cf0,
	/* fp34 */		0x35c661b2,
	/* fp35 */		0x7ae04b8d,
	/* fp36 */		0x7acb010d,
	/* fp37 */		0xa216c122,
	/* fp38 */		0xd64fb56a,
	/* fp39 */		0xe2b4dea9,
	/* fp3a */		0x4267c3f7,
	/* fp3b */		0x9b75c799,
	/* fp3c */		0x01aee179,
	/* fp3d */		0x586fd0a8,
	/* fp3e */		0x4eeb130e,
	/* fp3f */		0x42604a40,
	/* fp40 */		0x0,
	/* fp41 */		0x0,
	/* fp42 */		0x0,
	/* fp43 */		0x0,
	/* fp44 */		0x0,
	/* fp45 */		0x0,
	/* fp46 */		0x0,
	/* fp47 */		0x0,
	/* fp48 */		0x0,
	/* fp49 */		0x0,
	/* fp4a */		0x0,
	/* fp4b */		0x0,
	/* fp4c */		0x0,
	/* fp4d */		0x0,
	/* fp4e */		0x0,
	/* fp4f */		0x0,
	/* fp50 */		0x0,
	/* fp51 */		0x0,
	/* fp52 */		0x0,
	/* fp53 */		0x0,
	/* fp54 */		0x0,
	/* fp55 */		0x0,
	/* fp56 */		0x0,
	/* fp57 */		0x0,
	/* fp58 */		0x0,
	/* fp59 */		0x0,
	/* fp5a */		0x0,
	/* fp5b */		0x0,
	/* fp5c */		0x0,
	/* fp5d */		0x0,
	/* fp5e */		0x0,
	/* fp5f */		0x0,
	/* fp60 */		0x0,
	/* fp61 */		0x0,
	/* fp62 */		0x0,
	/* fp63 */		0x0,
	/* fp64 */		0x0,
	/* fp65 */		0x0,
	/* fp66 */		0x0,
	/* fp67 */		0x0,
	/* fp68 */		0x0,
	/* fp69 */		0x0,
	/* fp6a */		0x0,
	/* fp6b */		0x0,
	/* fp6c */		0x0,
	/* fp6d */		0x0,
	/* fp6e */		0x0,
	/* fp6f */		0x0,
	/* fp70 */		0x405,
	/* fp71 */		0xced6a94e,
	/* fp72 */		0x2,
	/* fp73 */		0x0,
	/* fp74 */		0x0,
	/* fp75 */		0x0,
	/* fp76 */		0x95f9c859,
	/* fp77 */		0x30388dc9,
    },
    /* GE */
    {
	/* ge00 NOT SET */	0x0,
	/* ge01 NOT SET */	0x0,
	/* ge02 NOT SET */	0x0,
	/* ge03 NOT SET */	0x0,
	/* ge04 NOT SET */	0x0,
	/* ge05 NOT SET */	0x0,
	/* ge06 NOT SET */	0x0,
	/* ge07 NOT SET */	0x0,
	/* ge08 NOT SET */	0x0,
	/* ge09 NOT SET */	0x0,
	/* ge0a */		0x40000280,
	/* ge0b */		0x00000000,
    },
};

static MqInitData  mqInitH5400_sharp = {
    /* DC */
    {
	/* dc00 */		0x00000001,
	/* dc01 */		0x00000003,
	/* dc02 */		0x00000001,
	/* dc03 NOT SET */	0x0,
	/* dc04 */		0x00000004,
	/* dc05 */		0x00000003,
    },
    /* CC */
    {
	/* cc00 */		0x00000000,
	/* cc01 */		0x00001010,
	/* cc02 */		0x000002a2,
	/* cc03 */		0x00000000,
	/* cc04 */		0x00000004,
    },
    /* MIU */
    {
	/* mm00 */		0x00000001,
	/* mm01 */		0x1b676ca8,
	/* mm02 */		0x00000000,
	/* mm03 */		0x00001479,
	/* mm04 */		0x6bfc2d76,
    },
    /* GC */
    {
	/* gc00 */		0x080100c8, /* powered down */
	/* gc01 */		0x00000000,
	/* gc02 */		0x00f0011a,
	/* gc03 */		0x013f015f,
	/* gc04 */		0x011100fa,
	/* gc05 */		0x015a0158,
	/* gc06 */		0x00000000,
	/* gc07 NOT SET */	0x0,
	/* gc08 */		0x00ef0000,
	/* gc09 */		0x013f0000,
	/* gc0a */		0x00000000,
	/* gc0b */		0x011700f2,
	/* gc0c */		0x00000000,
	/* gc0d */		0x00066373,
	/* gc0e */		0x000001e0,
	/* gc0f NOT SET */	0x0,
	/* gc10 */		0x02ff07ff,
	/* gc11 */		0x000000ff,
	/* gc12 NOT SET */	0x0,
	/* gc13 NOT SET */	0x0,
	/* gc14 */		0x00000000,
	/* gc15 */		0x00000000,
	/* gc16 */		0x00000000,
	/* gc17 */		0x00000000,
	/* gc18 */		0x00000000,
	/* gc19 */		0x00000000,
	/* gc1a */		0x00000000,
    },
    /* FP */
    {
	/* fp00 */		0x00006120,
	/* fp01 */		0x003d5008,
	/* fp02 */		0xfffcfcfd,
	/* fp03 */		0x00000002,
	/* fp04 */		0x80bd0001,
	/* fp05 */		0xc9000000,
	/* fp06 */		0x80000000,
	/* fp07 */		0x00040005,
	/* fp08 */		0x00040004,
	/* fp09 NOT SET */	0x0,
	/* fp0a */		0x00000000,
	/* fp0b */		0x00000000,
	/* fp0c NOT SET */	0x0,
	/* fp0d NOT SET */	0x0,
	/* fp0e NOT SET */	0x0,
	/* fp0f */		0x00000120,
	/* fp10 */		0x2645a216,
	/* fp11 */		0x1941d898,
	/* fp12 */		0xc2f5b84c,
	/* fp13 */		0x411585dd,
	/* fp14 */		0xad1d0a85,
	/* fp15 */		0xd7928b26,
	/* fp16 */		0x4848e722,
	/* fp17 */		0x696d0932,
	/* fp18 */		0xf2d20075,
	/* fp19 */		0xd547235e,
	/* fp1a */		0x310304f6,
	/* fp1b */		0x3cef4474,
	/* fp1c */		0x22a3d351,
	/* fp1d */		0x01825700,
	/* fp1e */		0xb7d793d1,
	/* fp1f */		0x10906408,
	/* fp20 */		0x0,
	/* fp21 */		0x0,
	/* fp22 */		0x0,
	/* fp23 */		0x0,
	/* fp24 */		0x0,
	/* fp25 */		0x0,
	/* fp26 */		0x0,
	/* fp27 */		0x0,
	/* fp28 */		0x0,
	/* fp29 */		0x0,
	/* fp2a */		0x0,
	/* fp2b */		0x0,
	/* fp2c */		0x0,
	/* fp2d */		0x0,
	/* fp2e */		0x0,
	/* fp2f */		0x0,
	/* fp30 */		0x7ba9b45b,
	/* fp31 */		0xb56738c3,
	/* fp32 */		0xde47a2ba,
	/* fp33 */		0x88241cf0,
	/* fp34 */		0x35c661b2,
	/* fp35 */		0x7ae04b8d,
	/* fp36 */		0x7acb010d,
	/* fp37 */		0xa216c122,
	/* fp38 */		0xd64fb56a,
	/* fp39 */		0xe2b4dea9,
	/* fp3a */		0x4267c3f7,
	/* fp3b */		0x9b75c799,
	/* fp3c */		0x01aee179,
	/* fp3d */		0x586fd0a8,
	/* fp3e */		0x4eeb130e,
	/* fp3f */		0x42604a40,
	/* fp40 */		0x0,
	/* fp41 */		0x0,
	/* fp42 */		0x0,
	/* fp43 */		0x0,
	/* fp44 */		0x0,
	/* fp45 */		0x0,
	/* fp46 */		0x0,
	/* fp47 */		0x0,
	/* fp48 */		0x0,
	/* fp49 */		0x0,
	/* fp4a */		0x0,
	/* fp4b */		0x0,
	/* fp4c */		0x0,
	/* fp4d */		0x0,
	/* fp4e */		0x0,
	/* fp4f */		0x0,
	/* fp50 */		0x0,
	/* fp51 */		0x0,
	/* fp52 */		0x0,
	/* fp53 */		0x0,
	/* fp54 */		0x0,
	/* fp55 */		0x0,
	/* fp56 */		0x0,
	/* fp57 */		0x0,
	/* fp58 */		0x0,
	/* fp59 */		0x0,
	/* fp5a */		0x0,
	/* fp5b */		0x0,
	/* fp5c */		0x0,
	/* fp5d */		0x0,
	/* fp5e */		0x0,
	/* fp5f */		0x0,
	/* fp60 */		0x0,
	/* fp61 */		0x0,
	/* fp62 */		0x0,
	/* fp63 */		0x0,
	/* fp64 */		0x0,
	/* fp65 */		0x0,
	/* fp66 */		0x0,
	/* fp67 */		0x0,
	/* fp68 */		0x0,
	/* fp69 */		0x0,
	/* fp6a */		0x0,
	/* fp6b */		0x0,
	/* fp6c */		0x0,
	/* fp6d */		0x0,
	/* fp6e */		0x0,
	/* fp6f */		0x0,
	/* fp70 */		0x405,
	/* fp71 */		0xced6a94e,
	/* fp72 */		0x2,
	/* fp73 */		0x0,
	/* fp74 */		0x0,
	/* fp75 */		0x0,
	/* fp76 */		0x95f9c859,
	/* fp77 */		0x30388dc9,
    },
    /* GE */
    {
	/* ge00 NOT SET */	0x0,
	/* ge01 NOT SET */	0x0,
	/* ge02 NOT SET */	0x0,
	/* ge03 NOT SET */	0x0,
	/* ge04 NOT SET */	0x0,
	/* ge05 NOT SET */	0x0,
	/* ge06 NOT SET */	0x0,
	/* ge07 NOT SET */	0x0,
	/* ge08 NOT SET */	0x0,
	/* ge09 NOT SET */	0x0,
	/* ge0a */		0x40000280,
	/* ge0b */		0x00000000,
    },
};

static MqInitData *
mq1100_h5400_detect_lcd (MqMap *mq)
{
    mq32    pin_input_data;
    
    debug ("enter\n");
    /* power up the mediaq to see what kind of LCD is connected */
    set_h3600_egpio (IPAQ_EGPIO_LCD_POWER);
    mdelay (10);	/* give the mediaq a chance to wake up */
    /*
     * Turn on the config module
     */
    mq->reg->DC.s.config_1 = MQ_CONFIG_18_OSCILLATOR_INTERNAL;
    mdelay (1);		/* wait for the oscillator to stabilize */
    mq->reg->DC.s.config_2 = MQ_CONFIG_CC_MODULE_ENABLE;
    mdelay (1);		/* probably not needed... */
    mq->reg->FP.s.input_control |= MQ_FP_ENVEE;
    pin_input_data = mq->reg->FP.s.pin_input_data;
    clr_h3600_egpio (IPAQ_EGPIO_LCD_POWER);
    debug ("pin_input_data %X\n", pin_input_data);
    if (pin_input_data & MQ_FP_ENVEE)
    {
	debug ("detected Philips LCD\n");
	return &mqInitH5400_phillips;
    }
    else
    {
	debug ("detected Sharp LCD\n");
	return &mqInitH5400_sharp;
    }
}

static void
mq1100_h5400_lcd_enable (MqBool on)
{
    if (on) 
    {
	set_h3600_egpio (IPAQ_EGPIO_LCD_ENABLE);
    } 
    else 
    {
	clr_h3600_egpio (IPAQ_EGPIO_LCD_ENABLE);
    }
}

static void
mq1100_h5400_power (MqBool on)
{
    if (on) 
    {
	set_h3600_egpio (IPAQ_EGPIO_LCD_POWER);
    } 
    else 
    {
	clr_h3600_egpio (IPAQ_EGPIO_LCD_POWER);
    }
}

static struct MqFuncs
mq1100_h5400_funcs =
{
    mq1100_h5400_detect_lcd,
    mq1100_h5400_power,
    mq1100_h5400_lcd_enable
};

/*
 *  Initialization
 */

int __init mq1100fb_h5400_init(void)
{
    int	i, rc = -ENODEV;
    debug ("enter\n");
    i = machine_is_h5400();
    debug ("machine_is_h5400 returns %d\n", i);
    if (i)
    {
	rc = mq1100_probe (MQ_BASE + 256*1024, MQ_BASE, &mq1100_h5400_funcs);
    }
    debug ("exit: %d\n", rc);
    return rc;
}

void __exit mq1100fb_h5400_exit(void)
{
    debug ("enter\n");
    mq1100_cleanup ();
    debug ("exit\n");
}

#ifdef MODULE
module_init(mq1100fb_h5400_init);
#endif
module_exit(mq1100fb_h5400_exit);

MODULE_AUTHOR("Keith Packard <keithp@keithp.com>");
MODULE_DESCRIPTION("Framebuffer driver for MediaQ 1100 chips");
MODULE_LICENSE("GPL");
