/* $Id: tx.c,v 1.1 2003/12/13 18:55:20 pb Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

		Atmel wireless lan drivers is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License as published by
		the Free Software Foundation; either version 2 of the License, or
		(at your option) any later version.

		Atmel wireless lan drivers is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with Atmel wireless lan drivers; if not, write to the Free Software
		Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA

**************************************************************************************/
#include "vnetusba.h"
#include "rx.h"
#include "frame.h"
#include "stdinclude.h"

/* == PROC AllocPacket ==
	 alloc an TX_LIST struct and fill some fields */
TX_LIST *AllocPacket(PVNet_ADAPTER Adapter, USHORT length)
{
	int kmflag = in_interrupt()? GFP_ATOMIC : GFP_KERNEL;
	TX_LIST *retval;

	if (!(retval = kmalloc(sizeof(TX_LIST), kmflag))) {
		err("cannot kmalloc %d byte", sizeof(TX_LIST));
		return NULL;
	}

	/* jal: check if we really need to alloc a complete TX_BUFFER ... */
	if (!(retval->tx_buff = kmalloc(sizeof(TX_BUFFER), kmflag))) {
		err("cannot kmalloc %d byte\n", sizeof(TX_BUFFER));
		kfree(retval);
		return NULL;
	}

	/* fill some fields */
	retval->length = length + 8 + 18;
	retval->tx_buff->WLength = length;
	retval->tx_buff->TxRate = 1;	/* fixed to 1 ??? */
	retval->Adapter = Adapter;
	retval->skb = NULL;	// skb is filled by caller, shows that this buffer contains tx data 

	if (Adapter->TxPacketsPending > THRE_STOP_NET_TX &&
	    !(Adapter->flags & TX_STOPPED))
		VNetIf_queue(Adapter->net, 0);	/* sets TX_STOPPED inside */
	return retval;
}

int SendAuthRequest(PVNet_ADAPTER Adapter, PUCHAR pChallengeText,
		    UCHAR ChallengeTextLength)
{
	USHORT FrameLen;
	s80211_MgmtFrm MgmtFrame;
	s80211_MgmtBody_Authentication *AuthFrameBody =
	    (s80211_MgmtBody_Authentication *) MgmtFrame.Body;
	TX_LIST *TxList;

	/* Format Frame Header */
	MgmtFrame.FrameControl[0] =
	    C80211_PROTOCOL_VERSION | C80211_TYPE_MGMT |
	    C80211_SUBTYPE_MGMT_Authentication;

	/* Support WEP (NO WEP for authentication frames with TrSeqNo 1) */
	if ((Adapter->PrivacyInvoked) &&
	    (Adapter->WepInfo.AuthenticationType ==
	     C80211_MGMT_AAN_SHAREDKEY)
	    && (Adapter->CurrentAuthentTransactionSeqNum > 1))
		MgmtFrame.FrameControl[1] = C80211_FRMCTRL_WEP;
	else
		MgmtFrame.FrameControl[1] = 0x00;

	MgmtFrame.DurationID = 0x8000;

	memcpy(MgmtFrame.uDA, Adapter->CurrentBSSID, 6);
	memcpy(MgmtFrame.uSA, Adapter->CurrentAddress, 6);
	memcpy(MgmtFrame.uBSSID, Adapter->CurrentBSSID, 6);

	MgmtFrame.SequenceControl = 0x0000;

	/* Frame Body */
	AuthFrameBody->AuthenticationAlgorithmNumber =
	    Adapter->WepInfo.AuthenticationType;

	/* Set AuthenticationTransactionSequenceNumber */
	AuthFrameBody->AuthenticationTransactionSequenceNumber =
	    Adapter->CurrentAuthentTransactionSeqNum;

	Adapter->ExpectedAuthentTransactionSeqNum =
	    Adapter->CurrentAuthentTransactionSeqNum + 1;
	AuthFrameBody->StatusCode = 0x0000;

	if (ChallengeTextLength != 0) {
		AuthFrameBody->ChallengeText.ElementID =
		    C80211_MGMT_ElementID_ChallengeText;
		AuthFrameBody->ChallengeText.Length = ChallengeTextLength;
		memcpy(AuthFrameBody->ChallengeText.Information,
		       pChallengeText, ChallengeTextLength);
		/* Header + Body + element Header + element length */
		FrameLen = 24 + 6 + 2 + ChallengeTextLength;
	} else
		FrameLen = 24 + 6;	/* Header + Body */

	dbgcond(DBG_AUTH,
		"AuthReq to bssid %02x:%02x:%02x:%02x:%02x:%02x, "
		"WEP %s, algorithm nr %d, seq nr %d, challenge text len %d\n",
		MgmtFrame.uDA[0], MgmtFrame.uDA[1], MgmtFrame.uDA[2],
		MgmtFrame.uDA[3], MgmtFrame.uDA[4], MgmtFrame.uDA[5],
		MgmtFrame.FrameControl[1] ? "yes" : "no",
		AuthFrameBody->AuthenticationAlgorithmNumber,
		AuthFrameBody->AuthenticationTransactionSequenceNumber,
		AuthFrameBody->ChallengeText.Length);

	//send frame & return status
	if ((TxList = AllocPacket(Adapter, FrameLen))) {
		memcpy(TxList->tx_buff->WirelessPacket, &MgmtFrame,
		       FrameLen);
		DeQueueTxPacket(Adapter, TxList);
		Adapter->CurrentAuthentTransactionSeqNum += 2;
	}			/* AllocPacket prints error if TxList is empty ... */
	VnetTimer(Adapter, 25);
	return 0;
}

int SendAssocRequest(PVNet_ADAPTER Adapter)
{
	USHORT FrameLen;
	s80211_MgmtFrm MgmtFrame;
	s80211_MgmtBody_AssRqst *AssReqFrameBody =
	    (s80211_MgmtBody_AssRqst *) MgmtFrame.Body;
	PTX_LIST TxList;
	UCHAR i;

	if (++Adapter->AssociationRequestRetries ==
	    MAX_ASSOCIATION_RETRIES) {
		dbgcond(DBG_ASSOC,
			"max assoc retries (%d) reached - giving up\n",
			MAX_ASSOCIATION_RETRIES);
		DropPendingTxPackets(Adapter);
		ChangeState(Adapter, STATION_STATE_SCANNING);
		UsbScan(Adapter);
		return 0;
	}

	/* Create Association Request Frame Header */
	MgmtFrame.FrameControl[0] =
	    C80211_PROTOCOL_VERSION | C80211_TYPE_MGMT |
	    C80211_SUBTYPE_MGMT_ASS_REQUEST;
	MgmtFrame.FrameControl[1] = 0x00;
	MgmtFrame.DurationID = 0x8000;

	memcpy(MgmtFrame.uDA, Adapter->CurrentBSSID, 6);
	memcpy(MgmtFrame.uSA, Adapter->StationAddress, 6);
	memcpy(MgmtFrame.uBSSID, Adapter->CurrentBSSID, 6);

	MgmtFrame.SequenceControl = 0x0000;

	/* Capability Information */
	AssReqFrameBody->CapabilityInformation =
	    (USHORT) (C80211_MGMT_CAPABILITY_ESS |
		      (Adapter->
		       PrivacyInvoked ? C80211_MGMT_CAPABILITY_Privacy : 0)
		      | (Adapter->PreambleType ==
			 PREAMBLE_TYPE_SHORT ?
			 C80211_MGMT_CAPABILITY_ShortPreamble : 0));

	//Listen Interval
	AssReqFrameBody->ListenInterval = 2 *(Adapter->BeaconPeriod);

	/* SSID */
	AssReqFrameBody->SSID.ElementID = C80211_MGMT_ElementID_SSID;
	assert(Adapter->SSID_size <= ESSID_SIZE);
	AssReqFrameBody->SSID.Length = MIN(Adapter->SSID_size, ESSID_SIZE);
	memcpy(AssReqFrameBody->SSID.Information, Adapter->SelectedSSID,
	       AssReqFrameBody->SSID.Length);

	/* append the supported rates (at the SSID end) */
	/* Check the operational rates we got from the fw. Remove any zeros and create
	   the association frame. */
	{
		/* jal TODO: a waste of stack space, we only need 2+4 bytes */
		sElementFormat rates =
		    { C80211_MGMT_ElementID_SupportedRates, 0 };

		for (i = 0; i < 4; i++) {
			if (Adapter->OperationalRates[i] != 0) {
				rates.Information[rates.Length++] =
				    Adapter->OperationalRates[i];
			}
		}
		FrameLen =
		    24 + 2 + 2 + 2 + Adapter->SSID_size + 2 + rates.Length;
		memcpy(AssReqFrameBody->SSID.Information +
		       AssReqFrameBody->SSID.Length, &rates,
		       offsetof(sElementFormat,
				Information) + rates.Length);
	}

	{
		char buf[2 * ESSID_SIZE + 1] __attribute__ ((unused));
		char buf2[2 * 4 + 1] __attribute__ ((unused));	/* dbg buffer */
		dbgcond(DBG_ASSOC,
			"AssocReq to bssid %02x:%02x:%02x:%02x:%02x:%02x, "
			"ssid %s, capa x%x, rates %s\n", MgmtFrame.uDA[0],
			MgmtFrame.uDA[1], MgmtFrame.uDA[2],
			MgmtFrame.uDA[3], MgmtFrame.uDA[4],
			MgmtFrame.uDA[5], ssid2str(buf,
						   AssReqFrameBody->SSID.
						   Information,
						   AssReqFrameBody->SSID.
						   Length),
			AssReqFrameBody->CapabilityInformation,
			buf2str(buf2,
				AssReqFrameBody->SSID.Information +
				AssReqFrameBody->SSID.Length + 2,
				*(AssReqFrameBody->SSID.Information +
				  AssReqFrameBody->SSID.Length + 1)));
	}

	if ((TxList = AllocPacket(Adapter, FrameLen))) {
		memcpy(TxList->tx_buff->WirelessPacket, &MgmtFrame,
		       FrameLen);
		DeQueueTxPacket(Adapter, TxList);
	}
	VnetTimer(Adapter, 25);
	return 0;
}				/* SendAssocRequest */

int SendReAssocRequest(PVNet_ADAPTER Adapter)
{
	int FrameLen;
	s80211_MgmtFrm MgmtFrame;
	s80211_MGMT_REASS_REQUEST *ReAssReqFrameBody =
	    (s80211_MGMT_REASS_REQUEST *) MgmtFrame.Body;
	int i;
	PTX_LIST TxList;


	if (++Adapter->ReAssociationRequestRetries ==
	    MAX_REASSOCIATION_RETRIES) {
		dbgcond(DBG_ASSOC,
			"max assoc retries (%d) reached - giving up\n",
			MAX_REASSOCIATION_RETRIES);
		DropPendingTxPackets(Adapter);
		ChangeState(Adapter, STATION_STATE_SCANNING);
		UsbScan(Adapter);
		return 0;
	}

	/* Create Association Request Frame Header */
	MgmtFrame.FrameControl[0] =
	    C80211_PROTOCOL_VERSION | C80211_TYPE_MGMT |
	    C80211_SUBTYPE_MGMT_REASS_REQUEST;
	MgmtFrame.FrameControl[1] = 0x00;
	MgmtFrame.DurationID = 0x8000;

	memcpy(MgmtFrame.uDA, Adapter->CurrentBSSID, 6);
	memcpy(MgmtFrame.uSA, Adapter->StationAddress, 6);
	memcpy(MgmtFrame.uBSSID, Adapter->CurrentBSSID, 6);

	MgmtFrame.SequenceControl = 0x0000;

	/* Capability Information */
	ReAssReqFrameBody->CapabilityInformation =
	    (USHORT) (C80211_MGMT_CAPABILITY_ESS |
		      (Adapter->
		       PrivacyInvoked ? C80211_MGMT_CAPABILITY_Privacy : 0)
		      | (Adapter->PreambleType ==
			 PREAMBLE_TYPE_SHORT ?
			 C80211_MGMT_CAPABILITY_ShortPreamble : 0));

	/* Listen Interval */
	ReAssReqFrameBody->ListenInterval = 2 *(Adapter->BeaconPeriod);

	/* current BSSID */
	memcpy(ReAssReqFrameBody->CurrentAPAddress, Adapter->CurrentBSSID,
	       6);

	/* current SSID */
	ReAssReqFrameBody->SSID.ElementID = C80211_MGMT_ElementID_SSID;
	ReAssReqFrameBody->SSID.Length = Adapter->SSID_size;
	memcpy(ReAssReqFrameBody->SSID.Information, Adapter->SelectedSSID,
	       Adapter->SSID_size);

	/* supported rates (copy all non-zero rates retrieved from firmware) */
	{
		/* jal TODO: a waste of stack space, we only need 2+4 bytes */
		sElementFormat rates =
		    { C80211_MGMT_ElementID_SupportedRates, 0 };

		for (i = 0; i < 4; i++) {
			if (Adapter->OperationalRates[i] != 0) {
				rates.Information[rates.Length++] =
				    Adapter->OperationalRates[i];
			}
		}

		FrameLen =
		    24 + 2 + 6 + 2 + 2 + Adapter->SSID_size + 2 + rates.Length;
		memcpy(ReAssReqFrameBody->SSID.Information +
		       ReAssReqFrameBody->SSID.Length, &rates,
		       offsetof(sElementFormat,
				Information) + rates.Length);
	}

	{
		char buf[2 * ESSID_SIZE + 1] __attribute__ ((unused));
		char buf2[2 * 4 + 1] __attribute__ ((unused));	/* dbg buffer */
		dbgcond(DBG_ASSOC,
			"ReAssocReq to bssid %02x:%02x:%02x:%02x:%02x:%02x "
			"ssid %s, capa x%x, rates %s\n", MgmtFrame.uDA[0],
			MgmtFrame.uDA[1], MgmtFrame.uDA[2],
			MgmtFrame.uDA[3], MgmtFrame.uDA[4],
			MgmtFrame.uDA[5], ssid2str(buf,
						   ReAssReqFrameBody->SSID.
						   Information,
						   ReAssReqFrameBody->SSID.
						   Length),
			ReAssReqFrameBody->CapabilityInformation,
			buf2str(buf2,
				ReAssReqFrameBody->SSID.Information +
				ReAssReqFrameBody->SSID.Length + 2,
				*(ReAssReqFrameBody->SSID.Information +
				  ReAssReqFrameBody->SSID.Length + 1)));
	}

	if ((TxList = AllocPacket(Adapter, FrameLen))) {
		memcpy(TxList->tx_buff->WirelessPacket, &MgmtFrame,
		       FrameLen);
		DeQueueTxPacket(Adapter, TxList);
	}
	VnetTimer(Adapter, 25);
	return 0;
}				/* SendReAssocRequest */

/***************************************************************************
	In Ethernet2(to)Wireless the ethernet packet we got from above is
	mutated to a wireless one. the ethernet's first 12 bytes (source
	and destination address) will be overwritten by the wireless
	header.
***************************************************************************/
void Ethernet2Wireless(PVNet_ADAPTER Adapter, PTX_LIST NewTxL)
{
	// Byte 0. Packet Type (DATA)
	NewTxL->tx_buff->WirelessPacket[0] = C80211_TYPE_DATA;
	// byte 2-3 : DurationID
	*(PUSHORT) ((PUCHAR) NewTxL->tx_buff->WirelessPacket + 2) =
	    (USHORT) 0x00;
        
		NewTxL->tx_buff->WirelessPacket[1] = 0x00;
		if (Adapter->PrivacyInvoked != 0){
      if(!(( NewTxL->tx_buff->WirelessPacket[30] == 0x88) && ( NewTxL->tx_buff->WirelessPacket[31] == 0x8E))){
			       NewTxL->tx_buff->WirelessPacket[1] |= C80211_FRMCTRL_WEP;
      }
    }

	if (Adapter->OperatingMode == AD_HOC_MODE) {

		memcpy(&NewTxL->tx_buff->WirelessPacket[4], &NewTxL->tx_buff->WirelessPacket[18], 6);	//Destination
		memcpy(&NewTxL->tx_buff->WirelessPacket[10], Adapter->StationAddress, 6);	//MACADDRESS
		memcpy(&NewTxL->tx_buff->WirelessPacket[16], Adapter->CurrentBSSID, 6);	//BSSID Created

	} else {

		/* infrastructure mode */
			NewTxL->tx_buff->WirelessPacket[1] |= C80211_FRMCTRL_TO_DS;

		memcpy(&NewTxL->tx_buff->WirelessPacket[16], &NewTxL->tx_buff->WirelessPacket[18], 6);	//Destination
		memcpy(&NewTxL->tx_buff->WirelessPacket[4], Adapter->CurrentBSSID, 6);	//Associated BSSID
		memcpy(&NewTxL->tx_buff->WirelessPacket[10], Adapter->StationAddress, 6);	//MAC
		// Sequence Control.....
		*(PUSHORT) ((PUCHAR) NewTxL->tx_buff->WirelessPacket +
			    22) = (USHORT) 0;
	}

	NewTxL->tx_buff->WLength = NewTxL->length - 8;
	NewTxL->tx_buff->TxRate = Adapter->TxRate;

	{
		char buf[2 * 32 + 1] __attribute__ ((unused));	/* dump the first 32 byte of the WirelessPacket */
		dbgcond(DBG_TXDATA, "TxData: %s\n",
			buf2str(buf, NewTxL->tx_buff->WirelessPacket,
				(sizeof(buf) - 1) / 2));
	}

}				/* Ethernet2Wireless */

/***************************************************************************

***************************************************************************/
/* == PROC DeQueueTxPacket ==
	 check if the TxList contains another pending Tx packet and, if yes, 
	 send it. If new_tx is != NULL, it points to a new tx packet which is queued
	 at the end of TxList.
   Must be called inside the spin_lock Adapter->lock !*/
void DeQueueTxPacket(PVNet_ADAPTER Adapter, TX_LIST * new_tx)
{
	UCHAR LastPacket = 0;	//Adapter->TxList.length%64;
	USHORT txLen;
	PTX_LIST TxOut;

	if (new_tx) {
		list_add_tail(&new_tx->tx_list, Adapter->TxList);
		Adapter->TxPacketsPending++;
	}
	// the device isn't running.
	if (!(Adapter->flags & VNET_RUNNING)) {
		err("device not running");
		return;
	}

	/* We have already sent a tx packet and will 
	   dequeue next packet in the completion handler. */
	if (Adapter->flags & TX_SLEEP) {
		dbgcond(DBG_TXDATA, "tx on\n");
		return;
	}

	if ((Adapter->TxPacketsPending < THRE_START_NET_TX) &&
	    (Adapter->flags & TX_STOPPED)) {
		VNetIf_queue(Adapter->net, 1);	/* resets TX_STOPPED inside */
	}

	/* nothing to be sent */
	if (list_empty(Adapter->TxList))
		return;

	TxOut = list_entry(Adapter->TxList->next, TX_LIST, tx_list);

	LastPacket = TxOut->length % 64;
	Adapter->flags |= TX_SLEEP;
	txLen = TxOut->length;
	// the 4th byte of the data_buff is the padding_bytes entry in the TX_BUFFER structure
	if (LastPacket < 50)
		TxOut->tx_buff->PaddingBytes = 50 - LastPacket;
	else if (LastPacket == 63)
		TxOut->tx_buff->PaddingBytes = 51;
	else if (LastPacket == 62)
		TxOut->tx_buff->PaddingBytes = 52;
	else if (LastPacket == 61)
		TxOut->tx_buff->PaddingBytes = 53;

	txLen += TxOut->tx_buff->PaddingBytes;

	TxOut->status |= UNDER_SUBMIT;

	FILL_BULK_URB(Adapter->tx_urb,
		      Adapter->usb,
		      usb_sndbulkpipe(Adapter->usb, 2),
		      TxOut->tx_buff, txLen, TxOkCB, TxOut);

	if (usb_submit_urb(Adapter->tx_urb) != 0) {
		err("tx not submitted (%d)", Adapter->tx_urb->status);
		Adapter->flags &= ~TX_SLEEP;
	}

	mod_use(1, Adapter);
	return;
}
