/*
 *
 * Definitions for HP iPAQ H5400 Handheld Computer
 * Driver interface to the H5400 ASIC
 *
 * Copyright © 2002 Hewlett-Packard Company.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Keith Packard
 *
 */

#ifndef _INCLUDE_H5400_ASIC_IO_H_ 
#define _INCLUDE_H5400_ASIC_IO_H_
 
#include <asm/arch-pxa/h5400-asic.h>
 
/* common initialization/cleanup functions */

int  h5400_asic_adc_init(void);
void h5400_asic_adc_cleanup(void);
int  h5400_asic_adc_suspend(void);
void h5400_asic_adc_resume(void);

/* touchscreen init/cleanup functions */

int  h5400_asic_touchscreen_init(void);
void h5400_asic_touchscreen_cleanup(void);
int  h5400_asic_touchscreen_suspend(void);
void h5400_asic_touchscreen_resume(void);

void h5400_asic_key_cleanup (void);
int h5400_asic_key_init (void);

/* backlight */
int h5400_asic_backlight_control (enum flite_pwr power, unsigned char level);
int h5400_asic_backlight_init (void);
void h5400_asic_backlight_cleanup (void);

#endif
