/*
 *	$Id: io_dc.c,v 1.2 2002/05/01 19:00:10 mrbrown Exp $
 *	I/O routines for SEGA Dreamcast
 */

#include <asm/io.h>
#include <asm/machvec.h>

#define EXTERNAL_IDE_BASE	0xb4000020
#define EXTERNAL_IDE_ALTSTAT	0xb4000058

unsigned long dreamcast_isa_port2addr(unsigned long offset)
{
	if ((offset >= 0x1f0) && (offset <= 0x1f7)) {
		return EXTERNAL_IDE_BASE + (offset - 0x1f0);
	}
	if (offset == 0x3f6) {
		return EXTERNAL_IDE_ALTSTAT;
	}
			
	return offset + 0xa0000000;
}
