/* $Id: linux_logo.h,v 1.1.1.1 2003/04/02 22:24:55 LOGIC+miket Exp $
 * include/linux/linux_logo.h: This is a linux logo
 *                             to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1996,1998 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 * Copyright (c) 2001 Greg Banks <gnb@alphalink.com.au>
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *           linux_logo_green[0],
 *           linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */

#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/SuperH version " UTS_RELEASE

#define __HAVE_ARCH_LINUX_LOGO 1
#define __HAVE_ARCH_LINUX_LOGO16 1
#define __HAVE_ARCH_LINUX_LOGOBW 1

#define LINUX_LOGO_COLORS       160

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0x02, 0x06, 0x0A, 0x0E, 0x16, 0x1A, 0x1E, 0x22,
  0x12, 0x2A, 0x36, 0x42, 0x4E, 0x4A, 0x56, 0x26,
  0x46, 0x2E, 0x32, 0x52, 0x3A, 0x02, 0x66, 0x5E,
  0x3E, 0x76, 0x8A, 0xA3, 0x9A, 0x86, 0xC6, 0xC2,
  0x66, 0xBA, 0xD2, 0xDA, 0xD6, 0xE2, 0xF6, 0xFE,
  0xAE, 0x7A, 0xDF, 0xEA, 0x6A, 0xAA, 0xE6, 0xBE,
  0x59, 0xEE, 0x9E, 0x96, 0x82, 0x7A, 0x7A, 0x68,
  0x3C, 0x9A, 0xE2, 0xF1, 0xE5, 0xBA, 0xD6, 0xB2,
  0x26, 0xBE, 0xC3, 0xEE, 0xEA, 0xEA, 0xEE, 0xF6,
  0xF4, 0xDA, 0xCE, 0x7A, 0xDC, 0xF6, 0xF6, 0xE0,
  0xB5, 0xCC, 0xF6, 0x69, 0xDB, 0xEE, 0xF1, 0xC5,
  0x9E, 0x8A, 0xD2, 0xEE, 0xCA, 0xBA, 0xD3, 0x5C,
  0x8A, 0xBE, 0xAA, 0xD6, 0xCA, 0xB6, 0xAD, 0x9E,
  0xC5, 0xBC, 0xBF, 0xC9, 0x92, 0xB2, 0x9A, 0xAA,
  0xB6, 0xF2, 0xCE, 0xFA, 0x6E, 0xA6, 0x12, 0x4A,
  0x8E, 0xF6, 0xF6, 0xEE, 0xE9, 0xF0, 0x26, 0x9A,
  0xEA, 0xF6, 0xDE, 0x31, 0x72, 0xCE, 0x46, 0x7E,
  0xB6, 0x62, 0xCF, 0xA3, 0x76, 0xA4, 0xA2, 0xE2,
  0xAE, 0xC0, 0xCE, 0xE2, 0xE7, 0xFC, 0xCD, 0x03,
  0xEF, 0xF9, 0xD4, 0xFE, 0xFE, 0xFE, 0x83, 0x5E
};

unsigned char linux_logo_green[] __initdata = {
  0x02, 0x06, 0x0A, 0x0E, 0x16, 0x1A, 0x1E, 0x22,
  0x12, 0x2A, 0x36, 0x42, 0x4E, 0x4A, 0x56, 0x26,
  0x46, 0x2E, 0x32, 0x52, 0x3A, 0x02, 0x66, 0x5E,
  0x3E, 0x76, 0x8A, 0xA3, 0x9A, 0x86, 0xC6, 0xC2,
  0x62, 0xBA, 0xD2, 0xDA, 0xD6, 0xE2, 0xF6, 0xFE,
  0xAE, 0x7A, 0xDE, 0xEA, 0x6A, 0xAA, 0xE6, 0xBE,
  0x5A, 0xEE, 0x9E, 0x96, 0x82, 0x64, 0x5E, 0x4E,
  0x28, 0x72, 0xAA, 0xBA, 0xAE, 0x92, 0xAE, 0x93,
  0x1A, 0xA6, 0x86, 0xB6, 0xBE, 0xC4, 0xCA, 0xCE,
  0xD4, 0xC2, 0xCE, 0x56, 0xA2, 0xD9, 0xD9, 0xBC,
  0x7A, 0x92, 0xDA, 0x46, 0x9E, 0xB2, 0xD6, 0x97,
  0x76, 0x5E, 0xA2, 0xBE, 0xA4, 0x86, 0x96, 0x45,
  0x66, 0x92, 0x7A, 0x9A, 0x93, 0x9E, 0x9A, 0x6A,
  0x8B, 0x8C, 0xB2, 0xCA, 0x92, 0xA6, 0x7A, 0x7E,
  0xB6, 0xF2, 0xCE, 0xFA, 0x6E, 0xA6, 0x0E, 0x33,
  0x86, 0xBE, 0xE6, 0xCE, 0xBC, 0xC6, 0x1E, 0x8E,
  0xAE, 0xBA, 0xAF, 0x23, 0x66, 0xAA, 0x2E, 0x72,
  0x86, 0x46, 0xA5, 0x6E, 0x52, 0x72, 0x92, 0xA6,
  0x86, 0x94, 0xA0, 0xD2, 0xDC, 0xFB, 0xC3, 0x03,
  0x9F, 0x64, 0x84, 0x03, 0x15, 0x38, 0x7E, 0x56
};

unsigned char linux_logo_blue[] __initdata = {
  0x02, 0x06, 0x0A, 0x0D, 0x16, 0x1A, 0x1E, 0x22,
  0x12, 0x2B, 0x36, 0x42, 0x4E, 0x4A, 0x56, 0x26,
  0x46, 0x2E, 0x32, 0x52, 0x3A, 0x06, 0x66, 0x5D,
  0x3E, 0x76, 0x8E, 0xA3, 0x9A, 0x86, 0xC4, 0xC2,
  0x5A, 0xBA, 0xD2, 0xDA, 0xD6, 0xE2, 0xF6, 0xFE,
  0xAE, 0x7A, 0xDE, 0xEA, 0x69, 0xAA, 0xE4, 0xBB,
  0x5A, 0xEE, 0x9E, 0x96, 0x82, 0x42, 0x0A, 0x0A,
  0x09, 0x0A, 0x0A, 0x0D, 0x0B, 0x11, 0x0E, 0x46,
  0x0A, 0x72, 0x0A, 0x0E, 0x0A, 0x12, 0x15, 0x2E,
  0x14, 0x86, 0xC2, 0x1A, 0x0A, 0x35, 0x27, 0x0E,
  0x09, 0x0B, 0x4A, 0x07, 0x0B, 0x0E, 0x22, 0x0D,
  0x0A, 0x06, 0x0C, 0x0A, 0x14, 0x0A, 0x0B, 0x1A,
  0x0E, 0x0E, 0x0C, 0x0A, 0x1F, 0x6A, 0x73, 0x09,
  0x0C, 0x22, 0x91, 0xCB, 0x92, 0x92, 0x36, 0x26,
  0xB6, 0xF2, 0xCE, 0xFA, 0x6E, 0xA6, 0x06, 0x0B,
  0x6A, 0x0E, 0xBE, 0x5A, 0x40, 0x0E, 0x0A, 0x5A,
  0x0C, 0x0E, 0x3B, 0x06, 0x4E, 0x4A, 0x06, 0x5A,
  0x26, 0x06, 0x44, 0x0A, 0x0A, 0x08, 0x5E, 0x0D,
  0x32, 0x2C, 0x24, 0xCF, 0xDA, 0xFB, 0xBE, 0x03,
  0x99, 0x5D, 0x35, 0x03, 0x15, 0x38, 0x74, 0x4B
};

unsigned char linux_logo[] __initdata = {
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22, 0x22,
  0x22, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
  0x26, 0x26, 0x25, 0x28, 0x23, 0x22, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x23, 0x25, 0x29, 0x2A, 0x2B, 0x2C, 0x2C,
  0x2C, 0x2D, 0x2B, 0x2A, 0x29, 0x25, 0x28, 0x22,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x24, 0x29, 0x2B, 0x2E, 0x2B, 0x2F, 0x2F, 0x24,
  0x25, 0x27, 0x2A, 0x2B, 0x2E, 0x30, 0x31, 0x25,
  0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x25,
  0x32, 0x33, 0x34, 0x21, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x21, 0x2A, 0x2E, 0x2B,
  0x2F, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24, 0x32,
  0x2C, 0x27, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x21, 0x30,
  0x2C, 0x31, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x21, 0x28, 0x29, 0x33,
  0x25, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x23, 0x31, 0x27, 0x21, 0x35,
  0x29, 0x2C, 0x29, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x26, 0x2B, 0x34,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x25, 0x2E, 0x36, 0x31, 0x22,
  0x35, 0x34, 0x30, 0x27, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x29, 0x2E, 0x22,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x26, 0x37, 0x37, 0x34, 0x25,
  0x35, 0x21, 0x2C, 0x2A, 0x24, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x24, 0x38, 0x38, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x25, 0x2A, 0x2F, 0x28, 0x22,
  0x35, 0x35, 0x27, 0x33, 0x2F, 0x23, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x26, 0x2C, 0x26, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x22, 0x22, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x2C, 0x32, 0x28, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x2F, 0x2E, 0x23, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x2A, 0x2B, 0x25, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x29, 0x33, 0x35, 0x35,
  0x35, 0x21, 0x22, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x21, 0x23, 0x22, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x28, 0x33, 0x27, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x31, 0x2E, 0x35, 0x35,
  0x21, 0x21, 0x24, 0x27, 0x21, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x28, 0x27, 0x22, 0x32, 0x24, 0x35,
  0x35, 0x35, 0x35, 0x22, 0x2E, 0x29, 0x23, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x31, 0x2E, 0x35, 0x35,
  0x2F, 0x39, 0x37, 0x24, 0x24, 0x35, 0x35, 0x35,
  0x23, 0x2E, 0x3A, 0x3B, 0x3C, 0x2F, 0x25, 0x21,
  0x35, 0x35, 0x35, 0x35, 0x2E, 0x31, 0x23, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x31, 0x2E, 0x35, 0x23,
  0x3D, 0x3E, 0x3F, 0x39, 0x22, 0x35, 0x35, 0x21,
  0x40, 0x41, 0x42, 0x43, 0x44, 0x3D, 0x23, 0x21,
  0x35, 0x35, 0x35, 0x35, 0x2E, 0x32, 0x28, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x31, 0x2E, 0x35, 0x2A,
  0x43, 0x3F, 0x45, 0x46, 0x34, 0x35, 0x35, 0x26,
  0x42, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x2D, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x30, 0x34, 0x24, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x31, 0x33, 0x35, 0x4C,
  0x4D, 0x25, 0x2E, 0x45, 0x49, 0x22, 0x23, 0x31,
  0x4E, 0x4F, 0x21, 0x30, 0x50, 0x51, 0x52, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x30, 0x34, 0x24, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x29, 0x2E, 0x21, 0x39,
  0x4C, 0x21, 0x30, 0x53, 0x54, 0x28, 0x2F, 0x2A,
  0x4A, 0x4C, 0x35, 0x23, 0x31, 0x4F, 0x3E, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x2D, 0x38, 0x24, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x29, 0x37, 0x23, 0x36,
  0x54, 0x35, 0x28, 0x39, 0x55, 0x56, 0x56, 0x57,
  0x3B, 0x4C, 0x35, 0x35, 0x35, 0x3F, 0x3F, 0x21,
  0x35, 0x35, 0x35, 0x35, 0x2D, 0x38, 0x24, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x2F, 0x50, 0x23, 0x34,
  0x42, 0x25, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
  0x5E, 0x5F, 0x60, 0x35, 0x30, 0x46, 0x3A, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x30, 0x2B, 0x25, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x2F, 0x2E, 0x23, 0x22,
  0x3F, 0x61, 0x62, 0x5C, 0x63, 0x64, 0x65, 0x66,
  0x67, 0x68, 0x65, 0x5D, 0x69, 0x6A, 0x29, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x32, 0x2D, 0x26, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x27, 0x2E, 0x23, 0x35,
  0x6B, 0x62, 0x6C, 0x63, 0x5B, 0x65, 0x68, 0x6D,
  0x6D, 0x6E, 0x68, 0x68, 0x68, 0x6F, 0x6B, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x32, 0x33, 0x27, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x27, 0x33, 0x26, 0x58,
  0x70, 0x71, 0x5C, 0x63, 0x64, 0x66, 0x68, 0x72,
  0x6E, 0x68, 0x68, 0x68, 0x6F, 0x5E, 0x5D, 0x21,
  0x35, 0x35, 0x35, 0x35, 0x25, 0x37, 0x29, 0x23,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x26, 0x2C, 0x32, 0x73,
  0x62, 0x74, 0x75, 0x5B, 0x65, 0x68, 0x6D, 0x76,
  0x68, 0x68, 0x68, 0x77, 0x71, 0x74, 0x78, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x21, 0x50, 0x2A, 0x28,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x26, 0x2C, 0x31, 0x24,
  0x79, 0x7A, 0x63, 0x7B, 0x66, 0x68, 0x68, 0x68,
  0x68, 0x7C, 0x7D, 0x7E, 0x74, 0x7E, 0x57, 0x35,
  0x21, 0x2A, 0x23, 0x35, 0x35, 0x38, 0x2D, 0x26,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x27, 0x2C, 0x32, 0x21,
  0x7F, 0x80, 0x81, 0x6F, 0x66, 0x65, 0x5E, 0x81,
  0x82, 0x62, 0x7E, 0x83, 0x84, 0x85, 0x40, 0x35,
  0x35, 0x2C, 0x39, 0x34, 0x35, 0x24, 0x50, 0x31,
  0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x2F, 0x2E, 0x32, 0x21,
  0x54, 0x86, 0x87, 0x82, 0x77, 0x5D, 0x88, 0x71,
  0x71, 0x71, 0x88, 0x61, 0x3F, 0x3E, 0x48, 0x23,
  0x35, 0x24, 0x39, 0x39, 0x24, 0x35, 0x2D, 0x30,
  0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x28, 0x32, 0x36, 0x25, 0x22,
  0x3A, 0x4F, 0x86, 0x87, 0x88, 0x71, 0x88, 0x62,
  0x70, 0x89, 0x8A, 0x41, 0x8B, 0x4A, 0x44, 0x2B,
  0x35, 0x35, 0x32, 0x38, 0x21, 0x35, 0x22, 0x50,
  0x32, 0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x27, 0x2D, 0x2D, 0x35, 0x21,
  0x8C, 0x3E, 0x4F, 0x8D, 0x8E, 0x87, 0x87, 0x8F,
  0x86, 0x41, 0x4F, 0x42, 0x46, 0x47, 0x47, 0x90,
  0x21, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x38,
  0x2D, 0x27, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x24, 0x2A, 0x37, 0x28, 0x35, 0x31,
  0x4B, 0x4A, 0x4F, 0x4F, 0x4F, 0x41, 0x41, 0x4F,
  0x4F, 0x3F, 0x44, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x33, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x23,
  0x2E, 0x2A, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x28, 0x31, 0x50, 0x31, 0x28, 0x21, 0x90,
  0x47, 0x46, 0x92, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F,
  0x92, 0x4E, 0x93, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x8B, 0x23, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x29, 0x2E, 0x29, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x23, 0x2F, 0x2D, 0x2B, 0x35, 0x21, 0x50, 0x93,
  0x47, 0x47, 0x51, 0x3E, 0x4F, 0x4F, 0x3F, 0x4A,
  0x46, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x33, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x2C, 0x30, 0x27, 0x23, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
  0x27, 0x2B, 0x2C, 0x21, 0x35, 0x28, 0x43, 0x47,
  0x47, 0x47, 0x47, 0x46, 0x45, 0x4E, 0x46, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x48, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x28, 0x50, 0x38, 0x26, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x25,
  0x34, 0x50, 0x28, 0x35, 0x35, 0x94, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x93, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x4E, 0x28, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x28, 0x37, 0x2A, 0x25, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24, 0x32,
  0x50, 0x25, 0x35, 0x35, 0x23, 0x3F, 0x93, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x93, 0x91, 0x2A, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x2F, 0x2E, 0x32, 0x24, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x21, 0x23, 0x2F, 0x33,
  0x27, 0x35, 0x35, 0x35, 0x29, 0x3F, 0x46, 0x47,
  0x47, 0x47, 0x47, 0x93, 0x91, 0x91, 0x93, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x93, 0x46, 0x51,
  0x45, 0x4E, 0x36, 0x21, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x2F, 0x33, 0x29, 0x23,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x25, 0x38, 0x2B,
  0x35, 0x35, 0x35, 0x21, 0x30, 0x4D, 0x92, 0x4B,
  0x46, 0x93, 0x93, 0x51, 0x45, 0x4E, 0x51, 0x93,
  0x93, 0x93, 0x46, 0x4E, 0x44, 0x92, 0x8B, 0x8B,
  0x3E, 0x8B, 0x90, 0x28, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x38, 0x2B, 0x26,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x29, 0x33, 0x28,
  0x35, 0x35, 0x35, 0x22, 0x37, 0x90, 0x43, 0x91,
  0x93, 0x47, 0x47, 0x93, 0x4B, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x46, 0x51, 0x45, 0x42, 0x8B,
  0x3F, 0x3F, 0x42, 0x52, 0x21, 0x23, 0x32, 0x23,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x21, 0x2E, 0x31,
  0x28, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x24, 0x2A, 0x30, 0x35,
  0x35, 0x22, 0x35, 0x24, 0x95, 0x4E, 0x93, 0x47,
  0x47, 0x47, 0x47, 0x93, 0x91, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x46,
  0x4E, 0x92, 0x3E, 0x45, 0x37, 0x35, 0x21, 0x2F,
  0x26, 0x35, 0x35, 0x35, 0x35, 0x35, 0x38, 0x2B,
  0x25, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x26, 0x2D, 0x32, 0x35,
  0x25, 0x25, 0x35, 0x4C, 0x51, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x46, 0x43, 0x8B, 0x42, 0x23, 0x35, 0x35,
  0x26, 0x24, 0x35, 0x35, 0x35, 0x35, 0x28, 0x2E,
  0x29, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x29, 0x50, 0x24, 0x35,
  0x29, 0x35, 0x28, 0x43, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x93, 0x4A, 0x43, 0x36, 0x35, 0x23,
  0x28, 0x2F, 0x22, 0x35, 0x35, 0x35, 0x35, 0x2C,
  0x34, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x28, 0x2A, 0x33, 0x35, 0x25,
  0x24, 0x35, 0x49, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x93, 0x51, 0x3E, 0x21, 0x2F,
  0x34, 0x25, 0x2F, 0x35, 0x35, 0x35, 0x35, 0x31,
  0x2C, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x26, 0x2D, 0x34, 0x35, 0x29,
  0x35, 0x24, 0x4E, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x93, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x46, 0x31, 0x2F,
  0x29, 0x23, 0x2F, 0x23, 0x35, 0x35, 0x35, 0x21,
  0x2E, 0x31, 0x23, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x23, 0x29, 0x50, 0x28, 0x28, 0x25,
  0x35, 0x39, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x93, 0x51, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x37, 0x21,
  0x35, 0x35, 0x22, 0x27, 0x35, 0x35, 0x35, 0x35,
  0x2D, 0x34, 0x24, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x25, 0x2B, 0x33, 0x35, 0x2F, 0x21,
  0x23, 0x42, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x46, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x8C, 0x35,
  0x35, 0x35, 0x35, 0x31, 0x35, 0x35, 0x35, 0x35,
  0x29, 0x2D, 0x26, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x23, 0x29, 0x50, 0x25, 0x21, 0x29, 0x35,
  0x2D, 0x93, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x91, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x90, 0x35,
  0x35, 0x35, 0x35, 0x31, 0x35, 0x35, 0x35, 0x35,
  0x22, 0x2E, 0x2F, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x25, 0x2B, 0x33, 0x35, 0x24, 0x28, 0x35,
  0x53, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4B, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x92, 0x35,
  0x35, 0x35, 0x35, 0x2F, 0x35, 0x35, 0x35, 0x35,
  0x21, 0x2E, 0x31, 0x23, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x28, 0x31, 0x2E, 0x28, 0x35, 0x27, 0x22, 0x21,
  0x42, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4B, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4A, 0x21,
  0x35, 0x35, 0x21, 0x26, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x33, 0x2A, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x25, 0x2B, 0x38, 0x35, 0x35, 0x2F, 0x22, 0x25,
  0x51, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x51, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4E, 0x21,
  0x35, 0x35, 0x22, 0x26, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x2B, 0x34, 0x24, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x2F, 0x2C, 0x21, 0x35, 0x35, 0x31, 0x23, 0x29,
  0x46, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4B, 0x22,
  0x35, 0x35, 0x24, 0x23, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x2B, 0x38, 0x24, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
  0x32, 0x2D, 0x35, 0x35, 0x23, 0x30, 0x27, 0x38,
  0x93, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x46, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4B, 0x23,
  0x35, 0x35, 0x26, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x2B, 0x38, 0x24, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x28,
  0x2A, 0x38, 0x35, 0x35, 0x35, 0x26, 0x31, 0x30,
  0x93, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x46, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x45, 0x22,
  0x35, 0x21, 0x26, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x35, 0x2B, 0x34, 0x24, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x24,
  0x34, 0x38, 0x35, 0x35, 0x35, 0x35, 0x26, 0x2C,
  0x93, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x46, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x92, 0x35,
  0x24, 0x27, 0x96, 0x24, 0x25, 0x28, 0x21, 0x35,
  0x35, 0x33, 0x2A, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x25,
  0x38, 0x4C, 0x97, 0x7D, 0x7A, 0x56, 0x21, 0x38,
  0x51, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x46, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x52, 0x28,
  0x23, 0x35, 0x35, 0x35, 0x21, 0x28, 0x2B, 0x2F,
  0x21, 0x37, 0x32, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x22, 0x22, 0x28, 0x2F,
  0x2C, 0x98, 0x74, 0x5B, 0x99, 0x99, 0x78, 0x22,
  0x50, 0x51, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x93, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x9A, 0x9B, 0x9B, 0x89, 0x60,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x2F, 0x31,
  0x25, 0x4C, 0x2A, 0x28, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x23, 0x24, 0x26, 0x2F, 0x32, 0x30,
  0x4C, 0x89, 0x5A, 0x5B, 0x99, 0x99, 0x99, 0x59,
  0x21, 0x2D, 0x45, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4E, 0x93, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x9C, 0x9D, 0x68, 0x65, 0x9E,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x21, 0x26, 0x25,
  0x7C, 0x9F, 0x2B, 0x25, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x28, 0x2F, 0x34, 0x2C, 0x2E, 0x36, 0x49,
  0x5F, 0x7E, 0xA0, 0xA1, 0x99, 0x99, 0x99, 0x7B,
  0x57, 0x35, 0x31, 0x3E, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x4B, 0x91, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0xA2, 0x5B, 0x9D, 0x7A, 0x28,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x21, 0x56,
  0x66, 0x65, 0x33, 0x27, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x23, 0x2F, 0x30, 0x8E, 0x89, 0x71, 0x88, 0x88,
  0x83, 0x5A, 0x5B, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x5C, 0xA3, 0x35, 0x24, 0x52, 0x93, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x93, 0x91, 0xA2, 0x63, 0x5B, 0x83, 0xA3,
  0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x58, 0x5C,
  0x7B, 0x5B, 0xA4, 0x29, 0x23, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x24, 0x2A, 0x8E, 0x83, 0x5A, 0x5C, 0x5A, 0x5A,
  0x75, 0x5B, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x9D, 0x5D, 0x22, 0x35, 0x21, 0x39, 0x91, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x4E, 0x3E, 0xA5, 0x75, 0x75, 0x7E, 0x79,
  0x96, 0x35, 0x35, 0x35, 0x21, 0xA6, 0x71, 0x75,
  0x63, 0x63, 0xA7, 0x34, 0x24, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x26, 0x30, 0xA8, 0x5A, 0x63, 0x5B, 0x5B, 0xA1,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x65, 0xA9, 0x35, 0x35, 0x35, 0x2B, 0x4A,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x92, 0x3E, 0xAA, 0x5C, 0x5C, 0x74, 0x62,
  0xAB, 0xAC, 0x57, 0xAC, 0xAD, 0x88, 0x5A, 0x63,
  0x5B, 0x5B, 0xAE, 0x2C, 0x27, 0x23, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x26, 0x2C, 0x89, 0x5A, 0x63, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x9D, 0x7C, 0x28, 0x35, 0x35, 0x35, 0x2F,
  0x43, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x93, 0x92, 0x3E, 0xAA, 0x5A, 0x75, 0xAF, 0x7E,
  0x71, 0x88, 0x62, 0x88, 0x7E, 0x5A, 0x5B, 0x99,
  0x99, 0xA1, 0x5C, 0xA7, 0x38, 0x26, 0x23, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x26, 0x2C, 0xB0, 0xAF, 0x63, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x9D, 0x80, 0x35, 0x35, 0x35, 0x35,
  0x2C, 0x93, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x93, 0x44, 0x3E, 0xB1, 0x6C, 0x75, 0xA0, 0xAF,
  0x74, 0x83, 0x83, 0x74, 0x5A, 0x63, 0x99, 0x99,
  0x99, 0x99, 0x5B, 0xB2, 0x36, 0x34, 0x26, 0x23,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x2E, 0x53,
  0x4D, 0x41, 0xB3, 0xB4, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9B, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x9D, 0x6F, 0x58, 0x35, 0x21, 0x35,
  0x24, 0x51, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x45, 0x41, 0xA8, 0x74, 0x75, 0x63, 0x75,
  0x5C, 0x5A, 0x5A, 0x5C, 0x75, 0x5B, 0x99, 0x99,
  0x99, 0x9D, 0x9A, 0x9A, 0xB3, 0x41, 0x94, 0x2F,
  0x25, 0x49, 0x3A, 0x3A, 0x3A, 0x40, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x23, 0x3C, 0x46, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x9A, 0x9B, 0x9D, 0x9D, 0x9D, 0x9D, 0x99, 0x99,
  0x99, 0x9D, 0x9D, 0x66, 0xB2, 0x28, 0x24, 0x26,
  0x30, 0x46, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x47, 0x4E, 0x39, 0x8F, 0x6C, 0x75, 0x5B, 0x99,
  0x65, 0x99, 0x99, 0x65, 0x99, 0x67, 0x9B, 0x67,
  0x9D, 0x9A, 0x47, 0x47, 0x47, 0xB5, 0xB6, 0x94,
  0x3D, 0x91, 0x93, 0x47, 0x93, 0x3A, 0x40, 0x20,
  0x20, 0x20, 0xB7, 0x96, 0x53, 0x91, 0xB8, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9,
  0xB8, 0x72, 0x46, 0x46, 0x46, 0x46, 0x9B, 0x99,
  0x9A, 0x46, 0x46, 0x46, 0x9A, 0x80, 0x90, 0x91,
  0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0x47, 0xB5,
  0xB5, 0xB5, 0x46, 0xB5, 0x47, 0xB5, 0xB5, 0x47,
  0x47, 0xB5, 0x91, 0x51, 0x9B, 0x75, 0x5B, 0x9A,
  0x46, 0x46, 0x46, 0x9A, 0x9A, 0x46, 0xB5, 0x9A,
  0x9A, 0x9A, 0xB9, 0xB9, 0xB9, 0xB9, 0x69, 0x69,
  0x4B, 0xBA, 0xB9, 0xB9, 0xB9, 0xB8, 0x3A, 0x40,
  0x20, 0x20, 0x22, 0x53, 0x91, 0xB9, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xB8, 0x46, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A,
  0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x51, 0x9A,
  0x9A, 0x9A, 0x9A, 0x46, 0xB4, 0x69, 0x69, 0xB3,
  0x46, 0x46, 0x46, 0xB5, 0x46, 0xB3, 0x69, 0x69,
  0xB8, 0x69, 0xB3, 0x9A, 0x46, 0x9B, 0x9A, 0x9A,
  0x9A, 0x9A, 0x9A, 0x9A, 0x46, 0xB3, 0xB8, 0xB3,
  0x46, 0xB8, 0xBB, 0xBB, 0xBB, 0xBB, 0x69, 0x46,
  0xB4, 0xBC, 0xBB, 0xBB, 0xBB, 0xBA, 0x93, 0x49,
  0x20, 0x20, 0x50, 0x46, 0xB8, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC,
  0xB3, 0xB3, 0xBC, 0xBC, 0xBC, 0xBC, 0xB8, 0xB5,
  0xB9, 0xBC, 0xBC, 0xBC, 0xB9, 0x46, 0xB9, 0xBC,
  0xBC, 0xBC, 0xB9, 0xB9, 0xBC, 0xBB, 0xBB, 0xBC,
  0xBA, 0x46, 0xB5, 0xB3, 0xBD, 0xBC, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBC, 0xB9, 0x91, 0x46, 0xB9,
  0xBC, 0xBC, 0xBC, 0xB9, 0xB9, 0xBB, 0xBB, 0xBD,
  0x46, 0xB9, 0xBB, 0xBB, 0xBB, 0xBC, 0x9A, 0xB5,
  0xB8, 0xBB, 0xBB, 0xBB, 0xBB, 0x69, 0x46, 0x34,
  0x20, 0x21, 0x90, 0xB5, 0xBD, 0xBB, 0xBB, 0xBB,
  0xBB, 0xB9, 0xB8, 0xB8, 0xB8, 0xBA, 0xB9, 0xB9,
  0x46, 0xBA, 0xBB, 0xBB, 0xBB, 0xBC, 0x51, 0x9A,
  0xBC, 0xBB, 0xBB, 0xBB, 0xB8, 0x9A, 0xBC, 0xBB,
  0xBB, 0xBB, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBC, 0x46, 0xB4, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBC, 0xBC, 0xBB, 0xBB, 0xBB, 0xB8, 0x9A, 0xBC,
  0xBB, 0xBB, 0xBB, 0xBD, 0xBB, 0xBB, 0xBB, 0xBA,
  0x46, 0xBC, 0xBB, 0xBB, 0xBB, 0xB9, 0x46, 0x46,
  0xB9, 0xBB, 0xBB, 0xBB, 0xBC, 0x91, 0x44, 0x23,
  0x20, 0x21, 0x42, 0xB5, 0xBD, 0xBB, 0xBB, 0xBB,
  0xBB, 0xB9, 0xB8, 0xB8, 0xB8, 0xB8, 0x51, 0x46,
  0x46, 0xBD, 0xBB, 0xBB, 0xBB, 0xB9, 0x46, 0xB8,
  0xBB, 0xBB, 0xBB, 0xBB, 0x9A, 0xB8, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBC, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0x46, 0xB9, 0xBB, 0xBB, 0xBB, 0xBC, 0x69,
  0x91, 0xB8, 0xBB, 0xBB, 0xBB, 0xB9, 0xB8, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x69,
  0xB3, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xBC, 0xBC,
  0xBB, 0xBB, 0xBB, 0xBB, 0xB9, 0x47, 0x52, 0x20,
  0x20, 0x22, 0x41, 0x46, 0xBD, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBD, 0xB5,
  0x9A, 0xBC, 0xBB, 0xBB, 0xBB, 0xB8, 0xB5, 0xB9,
  0xBB, 0xBB, 0xBB, 0xBD, 0xB5, 0xB9, 0xBB, 0xBB,
  0xBB, 0xBC, 0x69, 0xB3, 0xBD, 0xBB, 0xBB, 0xBB,
  0xBD, 0xB4, 0xBC, 0xBB, 0xBB, 0xBB, 0xBC, 0xBD,
  0xBD, 0xBD, 0xBB, 0xBB, 0xBB, 0xB8, 0xB9, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0x46,
  0xBA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xB8, 0xB5, 0x50, 0x20,
  0x20, 0x21, 0x32, 0x92, 0xB3, 0xB9, 0xBD, 0xBC,
  0xBC, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x51,
  0xB8, 0xBB, 0xBB, 0xBB, 0xBC, 0xB3, 0x51, 0xBC,
  0xBB, 0xBB, 0xBB, 0xBA, 0x51, 0xBD, 0xBB, 0xBB,
  0xBB, 0xB8, 0x46, 0x46, 0xBD, 0xBB, 0xBB, 0xBB,
  0xB9, 0xB8, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xB3, 0xBD, 0xBB,
  0xBB, 0xBB, 0xBC, 0xB9, 0xB8, 0xB8, 0xB8, 0x46,
  0xBD, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xBC, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0x9A, 0x91, 0x25, 0x20,
  0x21, 0x32, 0x92, 0xB3, 0xB4, 0xB4, 0xB4, 0x9A,
  0x9A, 0xB8, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0x46,
  0xB9, 0xBB, 0xBB, 0xBB, 0xBC, 0xB4, 0xB8, 0xBB,
  0xBB, 0xBB, 0xBB, 0x69, 0x69, 0xBB, 0xBB, 0xBB,
  0xBB, 0xB8, 0x9A, 0xB8, 0xBB, 0xBB, 0xBB, 0xBB,
  0xB8, 0xBA, 0xBB, 0xBB, 0xBB, 0xBC, 0x69, 0xB4,
  0xB4, 0xB4, 0xB3, 0x69, 0xB3, 0xB4, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBA, 0x46, 0xB5, 0xB5, 0x91, 0xB4,
  0xBC, 0xBB, 0xBB, 0xBB, 0xB9, 0x91, 0x51, 0xBD,
  0xBB, 0xBB, 0xBB, 0xBD, 0x46, 0x3F, 0x21, 0x20,
  0x24, 0x42, 0x9A, 0xBD, 0xBC, 0xBC, 0xBC, 0xBC,
  0xBC, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xB9, 0x46,
  0xBD, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xBC, 0xBB,
  0xBB, 0xBB, 0xBD, 0x91, 0xBA, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBC, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBD,
  0x51, 0xBA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBD, 0xB9,
  0xB9, 0xB9, 0xBD, 0xBD, 0x46, 0xB8, 0xBB, 0xBB,
  0xBB, 0xBC, 0xB4, 0x46, 0xA5, 0x85, 0x46, 0xB8,
  0xBB, 0xBB, 0xBB, 0xBB, 0x69, 0x91, 0x9A, 0xBC,
  0xBB, 0xBB, 0xBB, 0xBA, 0xB5, 0xBE, 0x21, 0x20,
  0x50, 0x46, 0xB8, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0xB3, 0x46,
  0xB9, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBD, 0xB3, 0xB5, 0xBD, 0xBB, 0xBB, 0xBB,
  0xBD, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBC, 0x69,
  0x51, 0xB3, 0xBC, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
  0xBB, 0xBB, 0xBB, 0xB8, 0xB5, 0xB9, 0xBB, 0xBB,
  0xBB, 0xBD, 0x46, 0xB4, 0x80, 0x3E, 0xB5, 0xB9,
  0xBB, 0xBB, 0xBB, 0xBC, 0x9A, 0xB5, 0xB8, 0xBB,
  0xBB, 0xBB, 0xBB, 0x69, 0x91, 0x38, 0x21, 0x20,
  0x34, 0x49, 0x69, 0xBA, 0xB9, 0xB9, 0xBD, 0xBD,
  0xBD, 0xBD, 0xBD, 0xB9, 0xBA, 0x9A, 0x44, 0x8C,
  0x91, 0xB8, 0xB9, 0xBD, 0xBD, 0xBD, 0xBD, 0xB9,
  0xB8, 0x9A, 0x46, 0x9A, 0xBC, 0xBB, 0xBB, 0xBB,
  0xB8, 0x69, 0xB9, 0xBD, 0xBD, 0xB9, 0xB3, 0x4E,
  0x50, 0xB4, 0xB3, 0xB9, 0xB9, 0xBD, 0xBD, 0xBD,
  0xB9, 0xB9, 0xB8, 0x51, 0x69, 0xB8, 0xBA, 0xB9,
  0xB9, 0xB8, 0xB4, 0x9F, 0x36, 0x8C, 0x4D, 0xB8,
  0xB9, 0xB9, 0xB9, 0xB8, 0x43, 0x54, 0xB8, 0xB9,
  0xB9, 0xB9, 0xBA, 0x9A, 0x39, 0x96, 0x21, 0x20,
  0x20, 0x34, 0x39, 0x91, 0x47, 0x93, 0x46, 0x46,
  0x46, 0x46, 0x46, 0xB5, 0xB5, 0x44, 0x32, 0x28,
  0x3A, 0x46, 0xB5, 0x46, 0x46, 0x46, 0x46, 0xB5,
  0xB5, 0xB4, 0xB5, 0xB8, 0xBB, 0xBB, 0xBB, 0xBC,
  0xB4, 0x51, 0xB5, 0x91, 0xB5, 0xB5, 0x4E, 0x2D,
  0x28, 0x38, 0x45, 0x47, 0xB5, 0x46, 0x46, 0xB5,
  0xB5, 0xB5, 0x93, 0x53, 0xAE, 0xB6, 0xB5, 0xB5,
  0xB5, 0xB3, 0x98, 0x2E, 0x34, 0x27, 0x49, 0x3B,
  0xB5, 0x47, 0x93, 0x4A, 0x40, 0x2C, 0x54, 0x47,
  0x47, 0x47, 0x46, 0x39, 0x96, 0xB7, 0x20, 0x20,
  0x20, 0x20, 0x34, 0x49, 0x53, 0x4D, 0x90, 0x4F,
  0x8B, 0x8B, 0x4F, 0x4D, 0x39, 0x26, 0x21, 0x21,
  0x22, 0x2E, 0x53, 0x90, 0x8B, 0x8B, 0x4F, 0x48,
  0x3D, 0x8C, 0x4F, 0xB8, 0xB9, 0xB9, 0xB9, 0xB9,
  0x4B, 0x3A, 0x95, 0x3E, 0x4F, 0x3A, 0x29, 0x21,
  0xB7, 0x21, 0x32, 0x3A, 0x48, 0x3E, 0x3E, 0x90,
  0x3B, 0x3A, 0x40, 0x30, 0xBF, 0x52, 0x8D, 0x4D,
  0x48, 0x3A, 0x2D, 0x32, 0x25, 0x23, 0x22, 0x39,
  0x54, 0x54, 0x54, 0x40, 0x21, 0xB7, 0x2C, 0x54,
  0x54, 0x54, 0x39, 0x96, 0xB7, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x22, 0x22, 0x21, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x23, 0x23, 0x24, 0x24,
  0x27, 0x29, 0x49, 0x48, 0x47, 0x47, 0x47, 0x51,
  0x3A, 0x21, 0x21, 0x22, 0x21, 0x20, 0x20, 0x21,
  0x21, 0x21, 0x21, 0x20, 0x21, 0x22, 0x22, 0x21,
  0x20, 0x21, 0x23, 0x26, 0x29, 0x2A, 0x38, 0x38,
  0x2A, 0x29, 0x26, 0x28, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x23, 0x4C, 0x3B, 0x4D, 0x95, 0x3A,
  0x21, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x28, 0x24, 0x24, 0x24,
  0x28, 0x23, 0x22, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
};


unsigned char linux_logo_bw[] __initdata = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xCF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFC, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFD, 0xFF, 0xF3, 0xDF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xF7, 0xEF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFB, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xF7, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF,
  0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x9F, 0x87, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFB, 0x0F, 0x03, 0xFB, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFB, 0x67, 0x33, 0xFB, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xE7, 0x79,
  0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0xF7, 0x79, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFB, 0xFF, 0xF9, 0xF7, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFB, 0x60, 0x3B, 0xF7, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x89, 0x07,
  0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x00, 0x03, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFB, 0x00, 0x0D, 0xFB, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFB, 0x80, 0x33, 0xFD, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xC0, 0xC3,
  0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0xFF, 0x0D, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFB, 0x40, 0x31, 0xEE, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF7, 0x20, 0xC1, 0xEE, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x1F, 0x00,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF,
  0x00, 0x00, 0x7F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xEE, 0x00, 0x00, 0x7F, 0xBF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x00, 0x7F, 0xDF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0x00, 0x00,
  0x3F, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C,
  0x00, 0x00, 0x3F, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7C, 0x00, 0x00, 0x1F, 0xF7, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0xFF, 0x1C, 0x07, 0xDF, 0xFB,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFC, 0x08, 0x0F,
  0xEF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xF8,
  0x00, 0x01, 0xEF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFB, 0xF0, 0x00, 0x00, 0x7F, 0xFE, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFB, 0xE0, 0x00, 0x00, 0x1F, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xE0, 0x00, 0x00,
  0x07, 0xBF, 0x7F, 0xFF, 0xFF, 0xFF, 0xF7, 0xC0,
  0x00, 0x00, 0x03, 0xBF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xEF, 0xC0, 0x00, 0x00, 0x03, 0xDF, 0xBF, 0xFF,
  0xFF, 0xFF, 0xEF, 0x80, 0x00, 0x00, 0x03, 0xDF,
  0xBF, 0xFF, 0xFF, 0xFF, 0xDF, 0x80, 0x00, 0x00,
  0x03, 0xDF, 0xBF, 0xFF, 0xFF, 0xFF, 0xDF, 0x80,
  0x00, 0x00, 0x01, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF,
  0xDF, 0x80, 0x00, 0x00, 0x01, 0xEF, 0xDF, 0xFF,
  0xFF, 0xFF, 0xBF, 0x00, 0x20, 0x00, 0x01, 0xEF,
  0xDF, 0xFF, 0xFF, 0xFF, 0xBF, 0x00, 0x20, 0x00,
  0x01, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF, 0xBF, 0x00,
  0x20, 0x00, 0x01, 0xEF, 0xDF, 0xFF, 0xFF, 0xFF,
  0xBF, 0x00, 0x20, 0x00, 0x01, 0xEF, 0xDF, 0xFF,
  0xFF, 0xFF, 0xBF, 0x00, 0x20, 0x00, 0x03, 0x03,
  0xDF, 0xFF, 0xFF, 0xFF, 0xBF, 0x00, 0x20, 0x00,
  0x02, 0xFD, 0xDF, 0xFF, 0xFF, 0xFF, 0xA3, 0x80,
  0x00, 0x00, 0x1F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF,
  0xC1, 0xC0, 0x00, 0x00, 0x11, 0xFF, 0x3F, 0xFF,
  0xFF, 0xFF, 0x80, 0xE0, 0x00, 0x00, 0x21, 0xFE,
  0x3F, 0xFF, 0xFF, 0xFF, 0x00, 0x70, 0x00, 0x00,
  0x21, 0xFC, 0x3F, 0xFF, 0xFF, 0xFE, 0x00, 0x3C,
  0x00, 0x00, 0x20, 0xF8, 0x3F, 0xFF, 0xFF, 0xF0,
  0x00, 0x3E, 0x00, 0x00, 0x20, 0x00, 0x3F, 0xFF,
  0xFF, 0xC0, 0x00, 0x1F, 0x00, 0x00, 0x20, 0x00,
  0x3F, 0xFF, 0xFF, 0xC0, 0x00, 0x1F, 0x80, 0x00,
  0x20, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, 0x00, 0x0F,
  0x80, 0x00, 0x20, 0x00, 0x07, 0xFF, 0xFE, 0x00,
  0x00, 0x07, 0x80, 0x00, 0x20, 0x00, 0x03, 0x87,
  0xF8, 0x00, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00,
  0x01, 0x01, 0xF1, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3C, 0x7D, 0xE7, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3C, 0x7C, 0xE7, 0xFF,
  0x3E, 0x7B, 0xBE, 0x0F, 0xE1, 0xCF, 0x7C, 0x79,
  0xCF, 0x80, 0x3E, 0x7B, 0xFF, 0x9F, 0xF9, 0xFF,
  0x78, 0xF9, 0xCF, 0xF8, 0x7C, 0x73, 0xFF, 0xBE,
  0x79, 0xFE, 0x7F, 0xF9, 0xCF, 0xFC, 0x7C, 0xF7,
  0xC7, 0xBF, 0xFB, 0xFE, 0xFF, 0xF3, 0xE7, 0xFE,
  0x78, 0xF7, 0x87, 0xBF, 0xFB, 0xF0, 0xFF, 0xF3,
  0xC0, 0x3E, 0xF9, 0xE7, 0x8F, 0x7C, 0x03, 0xC0,
  0xF8, 0xF3, 0x9F, 0xFE, 0xFF, 0xEF, 0xFF, 0x7F,
  0xF3, 0xC4, 0xF1, 0xF3, 0x9F, 0xFC, 0x7F, 0xCF,
  0xFE, 0x3F, 0xF7, 0xC9, 0xF1, 0xE7, 0x9F, 0xF8,
  0x3F, 0x0F, 0x3C, 0x9F, 0xC7, 0x99, 0xF1, 0xE7,
  0xC0, 0x03, 0x00, 0x1E, 0x01, 0xC0, 0x00, 0x3C,
  0x04, 0x0F, 0xE0, 0x07, 0xC0, 0xDE, 0x03, 0xE0,
  0x38, 0x7E, 0x1E, 0x1F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};


unsigned char linux_logo16[] __initdata = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x88, 0x88, 0x88, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x88, 0x80, 0x00, 0x00, 0x08, 0x88, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x80,
  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x08, 0x70, 0x00, 0x00, 0x00, 0x77, 0x70, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x87, 0x77, 0x00, 0x00, 0x07, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x77, 0xFF, 0x00, 0x00, 0x7F, 0x77, 0xF7, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x70, 0x0F, 0x80, 0x00, 0xF7, 0x08, 0x7F, 0x70,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x80, 0x07, 0x80, 0x00, 0xF8, 0x00, 0x8F, 0x70,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x70, 0x07, 0x88, 0x88, 0xF8, 0x00, 0x8F, 0x70,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0xF0, 0x06, 0xE6, 0xE6, 0xE6, 0x00, 0x8F, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x77, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x77, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x06, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x60,
  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80,
  0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x60,
  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80,
  0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x66, 0x66, 0x80,
  0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80,
  0x86, 0xE6, 0xE6, 0xE6, 0x66, 0x66, 0x66, 0x80,
  0x08, 0x78, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80,
  0x86, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x70,
  0x00, 0x77, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x87, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x78,
  0x00, 0x88, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x87, 0x76, 0x66, 0x66, 0x77, 0x77, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08,
  0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07,
  0xFF, 0x77, 0x77, 0x77, 0x7F, 0xFF, 0xFF, 0xFF,
  0x70, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x8F,
  0xFF, 0xF7, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0x7F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x87, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x87, 0x77,
  0xFF, 0xF7, 0x77, 0xFF, 0xFF, 0xFF, 0x77, 0x77,
  0x77, 0x78, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x77, 0x7F,
  0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x77,
  0x77, 0x78, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x77, 0x00, 0x08, 0x80, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0x80, 0x08, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x77, 0x80, 0x00, 0x08, 0x00, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x00, 0x80, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x78, 0x00, 0x08, 0x80, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x08, 0x00, 0x8F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF7, 0x08, 0x80, 0x80, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x08, 0x08, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF7, 0x08, 0x80, 0x80, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x08, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x08, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x80, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x08, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x80, 0x8F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x08, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x08, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x80, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x08, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x08, 0x08, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x08, 0x08, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x88, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x08, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x88, 0x88, 0x80, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x06, 0xE6, 0x00, 0x8F, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x08, 0x80,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x6E, 0x6E, 0x60, 0x08, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE6, 0xE0, 0x00, 0x00, 0x00, 0x88,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xE6, 0xE6, 0xE6, 0x00, 0x8F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFE, 0x6E, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6E, 0x6E, 0x6E, 0x6E, 0x60, 0x08, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF6, 0xE6, 0xE0, 0x00, 0x00, 0x00, 0x06,
  0xE6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xE6, 0xE6,
  0xE6, 0xE6, 0xE6, 0xE6, 0xE0, 0x00, 0x8F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFE, 0x6E, 0x60, 0x00, 0x00, 0x00, 0x0E,
  0x6E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x6E, 0x6E,
  0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x00, 0x08, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x76, 0xE6, 0xE6, 0x00, 0x00, 0x00, 0xE6,
  0xE6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0xE6, 0xE6,
  0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE0, 0x00, 0x8F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x7E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E,
  0x6E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x6E, 0x6E,
  0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x60, 0x00, 0x08,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x76, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
  0xE6, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0xE6, 0xE6,
  0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x7E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E,
  0x6E, 0x6E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x87, 0x77, 0x7F, 0x7F, 0x7E,
  0x7E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x60, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x76, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
  0xE6, 0xF7, 0xE7, 0x80, 0x08, 0x78, 0x78, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xE7, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE0, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF7, 0x7E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x7E,
  0x6F, 0xFF, 0xFF, 0x88, 0x8F, 0xFF, 0xF7, 0x80,
  0x00, 0x00, 0x7F, 0x7C, 0xCC, 0xCC, 0xCC, 0xCC,
  0x7E, 0xFF, 0xFF, 0x7E, 0x7F, 0xFF, 0x7E, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF6, 0xE7, 0xFF, 0xF7, 0xEF, 0xFF,
  0xEF, 0xCC, 0xCC, 0x77, 0xF7, 0xCC, 0xC7, 0x78,
  0x00, 0x07, 0xFC, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x7F, 0x7F, 0xF7, 0xF7, 0xFF, 0xFF, 0xF7, 0xFF,
  0xF7, 0xFF, 0xF7, 0x7F, 0xFF, 0xFF, 0xF7, 0x77,
  0x77, 0x7F, 0xFE, 0x7F, 0xFF, 0xFF, 0xF7, 0x77,
  0xF7, 0x4C, 0x4C, 0x7F, 0x74, 0x44, 0x4C, 0xF8,
  0x00, 0x8F, 0x74, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x7F, 0x44, 0x44, 0x7F, 0xC4, 0x44, 0xCF, 0xC4,
  0x44, 0xCC, 0x44, 0x44, 0xCF, 0xF7, 0xC4, 0x44,
  0x44, 0x44, 0xCF, 0xFC, 0x44, 0x4C, 0xC4, 0x4C,
  0xFC, 0x44, 0x4C, 0xFF, 0x74, 0x44, 0xC7, 0xF8,
  0x00, 0x7F, 0xC4, 0x44, 0x4C, 0x77, 0x7C, 0xC7,
  0xFC, 0x44, 0x4C, 0xF7, 0x44, 0x44, 0x7F, 0x44,
  0x44, 0xC4, 0x44, 0x44, 0x4F, 0xF4, 0x44, 0x44,
  0xC4, 0x44, 0x47, 0xF4, 0x44, 0x4C, 0x44, 0x4C,
  0xF4, 0x44, 0x4C, 0xFF, 0xC4, 0x44, 0x4F, 0xF0,
  0x00, 0x7F, 0xC4, 0x44, 0x4C, 0xC7, 0x77, 0xFF,
  0xFC, 0x44, 0x4C, 0xF7, 0x44, 0x44, 0xF7, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x4F, 0xC4, 0x44, 0x47,
  0xF7, 0x44, 0x4C, 0x74, 0x44, 0x44, 0x44, 0x47,
  0xF4, 0x44, 0x44, 0x44, 0x44, 0x44, 0xCF, 0x70,
  0x00, 0x7F, 0xC4, 0x44, 0x44, 0x44, 0x44, 0xCF,
  0xF4, 0x44, 0x4C, 0xFC, 0x44, 0x4C, 0xFC, 0x44,
  0x4C, 0x7F, 0x44, 0x44, 0xC7, 0xC4, 0x44, 0xCC,
  0xCC, 0x44, 0x47, 0xC4, 0x44, 0x44, 0x44, 0xCF,
  0xC4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7F, 0x80,
  0x00, 0x0F, 0x7C, 0xC4, 0xC4, 0x44, 0x44, 0x4F,
  0x74, 0x44, 0xC7, 0xFC, 0x44, 0x4C, 0xFC, 0x44,
  0x4C, 0xFF, 0xC4, 0x44, 0xC7, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x4F, 0xC4, 0x44, 0x4C, 0x7C, 0x7F,
  0xC4, 0x44, 0x44, 0xC4, 0x44, 0x44, 0xFF, 0x00,
  0x08, 0x77, 0xFF, 0x7F, 0xF7, 0x44, 0x44, 0x4F,
  0xC4, 0x44, 0x4F, 0x74, 0x44, 0x47, 0x74, 0x44,
  0x47, 0xFC, 0x44, 0x44, 0x7C, 0x44, 0x44, 0xF7,
  0xFF, 0x7F, 0x7F, 0x44, 0x44, 0x7F, 0xFF, 0xF7,
  0x44, 0x44, 0x7F, 0xFC, 0x44, 0x4C, 0xF7, 0x00,
  0x0F, 0xFC, 0x44, 0x44, 0x44, 0x44, 0x44, 0xCF,
  0xC4, 0x44, 0x44, 0x44, 0x44, 0xCF, 0xC4, 0x44,
  0x44, 0xC4, 0x44, 0x4C, 0xF7, 0x44, 0x44, 0xCC,
  0xCC, 0x4C, 0xF7, 0x44, 0x44, 0xFF, 0xC7, 0xF7,
  0x44, 0x44, 0x77, 0xF4, 0x44, 0x4C, 0xF7, 0x00,
  0x8F, 0xC4, 0x44, 0x44, 0x44, 0x44, 0x4C, 0x7F,
  0xC4, 0x44, 0x44, 0x44, 0x4C, 0x7F, 0xC4, 0x44,
  0xC4, 0x44, 0x44, 0x47, 0xF7, 0xC4, 0x44, 0x44,
  0x44, 0x47, 0xFC, 0x44, 0x4C, 0xF7, 0x67, 0xFC,
  0x44, 0x4C, 0xFF, 0x74, 0x44, 0x47, 0xF8, 0x00,
  0x87, 0x77, 0xCC, 0xCC, 0xCC, 0xCC, 0xCF, 0x77,
  0xF7, 0xCC, 0xCC, 0xCC, 0xCF, 0xFF, 0x44, 0x44,
  0x77, 0xCC, 0xCC, 0x7F, 0x87, 0xFC, 0xCC, 0xCC,
  0xCC, 0x7F, 0x7C, 0x7C, 0xC7, 0xE7, 0x08, 0x7C,
  0x7C, 0xCC, 0xFC, 0x7C, 0x7C, 0x7F, 0x80, 0x00,
  0x08, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x44, 0x44,
  0xFF, 0xFF, 0xFF, 0xF8, 0x08, 0x7F, 0xFF, 0xFF,
  0xFF, 0xF8, 0x7E, 0xFF, 0xFF, 0xC0, 0x00, 0x77,
  0xFF, 0xFF, 0x88, 0x7F, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x88, 0x77, 0x77, 0x77, 0x77, 0x80, 0x00,
  0x08, 0x77, 0x77, 0x77, 0x88, 0x77, 0xCC, 0xCC,
  0xF6, 0x77, 0x77, 0x00, 0x00, 0x07, 0x77, 0x77,
  0x78, 0x60, 0x08, 0x87, 0x88, 0x00, 0x00, 0x08,
  0x78, 0x78, 0x00, 0x88, 0x78, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0xFF, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x77, 0x77,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif /* INCLUDE_LINUX_LOGO_DATA */

#include <linux/linux_logo.h>
