/*
 * arch/arm/mach-lh79520/dma.h
 * Copyright (C) 2002 Embedix, Inc.
 *
 * Based on arch/arm/mach-sa1100/dma.h which is
 * (C) 2000 Nicolas Pitre <nico@cam.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/config.h>

/*
 * DMA buffer structure
 */

typedef struct dma_buf_s {
	int size;		/* buffer size */
	dma_addr_t dma_start;	/* starting DMA address */
	dma_addr_t dma_ptr;	/* next DMA pointer to use */
	int ref;		/* number of DMA references */
	void *id;		/* to identify buffer from outside */
	struct dma_buf_s *next;	/* next buffer to process */
} dma_buf_t;

typedef enum {
    DMA_OUT,
    DMA_IN
} dma_direction_t;

/*
 * DMA channel structure.
 */
typedef struct {
	unsigned int	in_use;		/* Device is allocated */
	const char 	*device_id;	/* Device name */
	dma_device_t	device;		/* ... to which this channel is attached */
	dma_buf_t	*head;		/* where to insert buffers */
	dma_buf_t	*tail;		/* where to remove buffers */
	dma_buf_t	*curr;		/* buffer currently DMA'ed */
	int 		stopped;	/* 1 if DMA is stalled */
	channelRegs_t	*regs;		/* points to appropriate DMA registers */
	int		irq;		/* IRQ used by the channel */
	dma_callback_t	callback;	/* ... to call when buffers are done */
	int		spin_size;	/* > 0 when DMA should spin when no more buffer */
	dma_addr_t	spin_addr;	/* DMA address to spin onto */
	int		spin_ref;	/* number of spinning references */
	int		channel;	/* channel number */
	dma_direction_t	direction;	/* DMA direction: 0=Out / 1=In	*/
} lh79520_dma_t;

extern lh79520_dma_t dma_chan[LH79520_DMA_CHANNELS];


void lh79520_dma_done( lh79520_dma_t *dma);




