/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kcmdlineargs_h__
#define __kcmdlineargs_h__

// really dummy wrapper, to make cookieserver compile ;-)

#include <kdeversion.h>

#include <qstring.h>

#if KDE_IS_VERSION(3,2,0)
#include <kdemacros.h>
#endif

struct KCmdLineOptions
{
    const char *name;
    const char *description;
    const char *def;
};

#define KCmdLineLastOption { 0, 0, 0 }

class KCmdLineArgs
{
public:
    KCmdLineArgs() {};
    ~KCmdLineArgs() {};

    // Needed for kdelibs 3.2
    static void init( int, char **, const char *, 
		    const char *, const char *, const char *, bool ) {}
    static void init( int, char **, 
		    const char *, const char *, const char *, bool ) {}

    static void addCmdLineOptions( const KCmdLineOptions * ) {}

    static KCmdLineArgs *parsedArgs()
        {
            if ( !s_self )
                s_self = new KCmdLineArgs;
            return s_self;
        }

    bool isSet( const QString & ) { return false; }

    QString getOption( const QString & ) { return QString::null; }

private:
    static KCmdLineArgs *s_self;
};

#endif
