/*
    This file is part of libkabc.
    Copyright (c) 2004 Ulf Schenk

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: tmpaddressbook.cpp,v 1.2 2004/08/03 20:49:15 ulf69 Exp $
*/
#include <qptrlist.h>

#include "tmpaddressbook.h"

using namespace KABC;

#include "resource.h"

TmpAddressBook::TmpAddressBook()
	: AddressBook(0, "tmpcontact")
{
}

TmpAddressBook::TmpAddressBook( const QString &config )
	: AddressBook( config, "tmpcontract" )
{
}

TmpAddressBook::~TmpAddressBook()
{
  //remove all possible resources. This should cleanup the configfile.
  QPtrList<KABC::Resource> mResources = resources();

  QPtrListIterator<KABC::Resource> it(mResources);
  for ( ; it.current(); ++it ) {
    KABC::Resource *res = it.current();
    removeResource(res);
  }
}

