/*
    This file is part of KSysGuard.
    Copyright ( C ) 2002 Nadeem Hasan ( nhasan@kde.org )

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or ( at your option ) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KSG_APPLETSETTINGS_H
#define KSG_APPLETSETTINGS_H

#include <kdialogbase.h>

class KIntNumInput;

class KSGAppletSettings : public KDialogBase
{
  public:
    KSGAppletSettings( QWidget *parent = 0, const char *name = 0 );
    ~KSGAppletSettings();

    void setNumDisplay( int );
    int numDisplay() const;

    void setSizeRatio( int );
    int sizeRatio() const;

    void setUpdateInterval( int );
    int updateInterval() const;

  private:
    KIntNumInput *mInterval;
    KIntNumInput *mNumDisplay;
    KIntNumInput *mSizeRatio;
};

#endif
