/*****************************************************************

Copyright (c) 1996-2004 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __containerarea_h__
#define __containerarea_h__

#include <qpixmap.h>
#include <qptrlist.h>
#include <qtimer.h>

#include "global.h"
#include "panner.h"
#include "container_base.h"

class KConfig;
class DragIndicator;
class PanelContainer;
class KRootPixmap;

typedef QPtrList<BaseContainer> ContainerList;
typedef QPtrListIterator<BaseContainer> ContainerIterator;
typedef QPtrListIterator<BaseContainer> ContainerIterator;

class AppletContainer;
class ContainerAreaLayout;

class ContainerArea : public Panner
{
    Q_OBJECT

public:
    ContainerArea( KConfig* config, QWidget* parent, QPopupMenu* opMenu, const char* name = 0 );
    ~ContainerArea();

    void initialize(bool useDefaultConfig);
    int position() const;
    KPanelApplet::Direction popupDirection() const;

    void addKMenuButton();
    void addDesktopButton();
    void addWindowListButton();
    void addBookmarksButton();
    void addServiceButton(const QString& desktopFile);
    void addURLButton(const QString &url);
    void addBrowserButton(const QString &startDir, const QString& icon = QString("kdisknav"));
    void addServiceMenuButton(const QString& relPath);
    void addNonKDEAppButton(const QString& name,
                            const QString &filePath, const QString &icon,
                            const QString &cmdLine, bool inTerm);
    void addExtensionButton(const QString& desktopFile);
    AppletContainer* addApplet(const QString& desktopFile, bool isImmutable = false);

    void configure();

    bool inMoveOperation() const { return (_moveAC != 0); }
    int widthForHeight(int height) const;
    int heightForWidth(int width) const;

    const QPixmap* completeBackgroundPixmap() const;

    ContainerList containers(const QString& type) const;
    int containerCount(const QString& type) const;
    bool canAddContainers() const;

signals:
    void maintainFocus(bool);

public slots:
    void resizeContents(int w, int h);
    void removeContainer(BaseContainer* a);
    void takeContainer(BaseContainer* a);
    void setPosition(KPanelExtension::Position p);
    void setAlignment(KPanelExtension::Alignment a);
    void slotSaveContainerConfig();
    void repaint();

protected:
    QString createUniqueId(const QString& appletType) const;

    bool eventFilter(QObject*, QEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent *);
    void dragEnterEvent(QDragEnterEvent*);
    void dragMoveEvent(QDragMoveEvent*);
    void dragLeaveEvent(QDragLeaveEvent*);
    void dropEvent(QDropEvent*);
    void resizeEvent(QResizeEvent*);
    void viewportResizeEvent(QResizeEvent*);

    void defaultContainerConfig();
    void loadContainers(const QStringList& containers);
    void saveContainerConfig(bool layoutOnly = false);

    QRect availableSpaceFollowing(BaseContainer*);
    void moveDragIndicator(int pos);

    void scrollTo(BaseContainer*);

    void addContainer(BaseContainer* a, bool arrange = false);
    void removeAllContainers();
    void resizeContents();

protected slots:
    void autoScroll();
    void updateBackground(const QPixmap&);
    void setBackgroundTheme();
    void updateContainersBackground();
    void startContainerMove(BaseContainer*);

private:
    ContainerList   m_containers;
    BaseContainer*  _moveAC;
    KPanelExtension::Position	    _pos;
    KConfig*	    _config;
    DragIndicator*  _dragIndicator;
    BaseContainer*  _dragMoveAC;
    QPoint	    _dragMoveOffset;
    QPopupMenu*     _opMenu;
    KRootPixmap*    _rootPixmap;
    bool            _transparent;
    bool            _useBgTheme;
    bool            _bgSet;
    QPixmap         _completeBg;
    QTimer          _autoScrollTimer;
    bool            m_canAddContainers;
    bool            m_immutable;

    QWidget*             m_contents;
    ContainerAreaLayout* m_layout;
};


class DragIndicator : public QWidget
{
    Q_OBJECT

public:
    DragIndicator(QWidget* parent = 0, const char* name = 0)
    : QWidget(parent, name) {;}
    ~DragIndicator() {;}

    QSize preferredSize() const { return _preferredSize; }
    void setPreferredSize(const QSize& size) { _preferredSize = size; }

protected:
    void paintEvent(QPaintEvent*);
    void mousePressEvent(QMouseEvent*);

private:
    QSize _preferredSize;
};

#endif

