/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: schroeder.h $
//		$Revision: 1 $
//		$Date: 03-09-10 13:22 $
//
//  Description:
//		IPP reverb example
******************************************************************************/

/* Standard IPP definitions */
#include <ippdefs.h>
#include <ippSP.h>

/* Reverb interface */
/************************************************************************
 *
 * External interface for demonstration purposes 
 * 
 * 1. ApplyReverb	 - automatically initializes state on first call
 * 2. SetReverbTime	 - change Rt on the fly
 * 3. ShutdownReverb - free internal Schroeder buffers
 *
 ************************************************************************/
void ApplyReverb(Ipp16s *, Ipp16s *, int, int);
void SetReverbTime(float ReverbTime);
void ShutdownReverb(void);

/* Performance timer interface */
void InitTimer(void);
int GetPerformanceTimer(int n, int N, int SampleRate, char *Desc);
void ShutdownTimer(void);
void ResetPerformanceTimers(void);

