/* the map window as a GObject
 *
 * we derive from <vbox> to build our own map widget with our own signals which
 * g2bind will emit on calls from the nethack engine
 *
 * $Id: g2map.h,v 1.1.1.1 2004/06/23 02:01:44 miq Exp $
 *
 */

#ifndef G2_MAP_WINDOW_H
#define G2_MAP_WINDOW_H

#include <gtk/gtk.h>

#define TYPE_G2_MAP (g2_map_get_type())
#define G2_MAP(obj)          GTK_CHECK_CAST(obj, g2_map_get_type(), G2Map)
#define G2_MAP_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, g2_map_get_type(), G2MapClass)
#define IS_G2_MAP(obj)       GTK_CHECK_TYPE(obj, g2_map_get_type())

typedef struct {
    GtkVBox mapContainer;

    GtkWidget *mapWin;
    GtkWidget *canvas;
    GdkPixmap *backBuffer;
    GdkPixbuf *bg;
    GdkPixbuf *tileSet;
    GdkGC *gc;
    gint mapWidth;
    gint mapHeight;
    gint cursorX;
    gint cursorY;
} G2Map;

typedef struct {
    GtkVBoxClass parent_class;

    void (*g2_map_print_glyph) (G2Map * g2Map);
    void (*g2_map_clear) (G2Map * g2Map);
    void (*g2_map_cliparound) (G2Map * g2Map);
    void (*g2_map_curs) (G2Map * g2Map);
    void (*g2_map_display) (G2Map * g2Map);
    void (*g2map) (G2Map * g2Map);
} G2MapClass;

gint tileSize;
gint tileCount;

guint g2_map_get_type(void);
GtkWidget *g2_map_new(void);
GdkPixbuf *g2_get_tile(gint glyph);

#endif                          /* G2_MAP_WINDOW_H */
