/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2004 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef UI_MISC_H
#define UI_MISC_H


#include <sys/time.h>
#include <sys/types.h>
#include <time.h>


GtkWidget *date_selection_new(void);

void date_selection_set(GtkWidget *widget, gint day, gint month, gint year);
void date_selection_get(GtkWidget *widget, gint *day, gint *month, gint *year);

void date_selection_time_set(GtkWidget *widget, time_t t);
time_t date_selection_time_get(GtkWidget *widget);

typedef enum {
	SIZER_POS_LEFT   = 1 << 0,
	SIZER_POS_RIGHT  = 1 << 1,
	SIZER_POS_TOP    = 1 << 2,
	SIZER_POS_BOTTOM = 1 << 3
} SizerPositionType;

GtkWidget *sizer_new(GtkWidget *parent, GtkWidget *bounding_widget,
		     SizerPositionType position);

void sizer_set_limits(GtkWidget *sizer,
                      gint hsize_min, gint hsize_max,
                      gint vsize_min, gint vsize_max);


#endif

