/*  DUMB-XMMS - Plug-in to enable XMMS to use DUMB for IT/XM/S3M/MOD files
 *  Copyright (C) 2002-2003  Ben Davis
 *  Incorporates code from the wav plug-in,
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "dumb-xmms.h"

#if 0
typedef struct
{
        void *handle;           /* Filled in by xmms */
        char *filename;         /* Filled in by xmms */
        char *description;      /* The description that is shown in the preferences box */
        void (*init) (void);    /* Called when the plugin is loaded */
        void (*about) (void);   /* Show the about box */
        void (*configure) (void);
        int (*is_our_file) (char *filename);    /* Return 1 if the plugin can handle the file */
        GList *(*scan_dir) (char *dirname);     /* Look in Input/cdaudio/cdaudio.c to see how to use this */
        void (*play_file) (char *filename);     /* Guess what... */
        void (*stop) (void);    /* Tricky one */
        void (*pause) (short paused);   /* Pause or unpause */
        void (*seek) (int time);        /* Seek to the specified time */
        void (*set_eq) (int on, float preamp, float *bands);    /* Set the equalizer, most plugins won't be able to do this */
        int (*get_time) (void); /* Get the time, usually returns the output plugins output time */
        void (*get_volume) (int *l, int *r);    /* Input-plugin specific volume functions, just provide a NULL if */
        void (*set_volume) (int l, int r);      /*  you want the output plugin to handle it */
        void (*cleanup) (void);                 /* Called when xmms exit */
        InputVisType (*get_vis_type) (void); /* OBSOLETE, DO NOT USE! */
        void (*add_vis_pcm) (int time, AFormat fmt, int nch, int length, void *ptr); /* Send data to the visualization plugins
                                                                                        Preferably 512 samples/block */
        void (*set_info) (char *title, int length, int rate, int freq, int nch);        /* Fill in the stuff that is shown in the player window
                                                                                           set length to -1 if it's unknown. Filled in by xmms */
        void (*set_info_text) (char *text);     /* Show some text in the song title box in the main window,
                                                   call it with NULL as argument to reset it to the song title.
                                                   Filled in by xmms */
        void (*get_song_info) (char *filename, char **title, int *length);      /* Function to grab the title string */
        void (*file_info_box) (char *filename);         /* Bring up an info window for the filename passed in */
        OutputPlugin *output;   /* Handle to the current output plugin. Filled in by xmms */
}
InputPlugin;
#endif

InputPlugin duh_ip =
{
	NULL,
	NULL,
	NULL, /* Description */
	duh_init,
	NULL,
	NULL,
	is_our_file,
	NULL,
	play_file,
	stop,
	duh_pause,
	seek,
	NULL,
	get_time,
	NULL,
	NULL,
	dumb_exit,
	NULL,
	NULL,
	NULL,
	NULL,
	get_song_info,
	NULL, /* file_info_box */
	NULL
};

DuhFile *duh_file = NULL;
static pthread_t decode_thread;
static gboolean audio_error = FALSE;

InputPlugin *get_iplugin_info(void)
{
	duh_ip.description = VERSIONSTRING;
	return &duh_ip;
}

static void duh_init(void)
{
	dumb_register_stdfiles();
}

static int is_our_file(char *filename)
{
	gchar *ext;

	ext = strrchr(filename, '.');
	if (ext) {
		if (!strcasecmp(ext, ".duh")) return TRUE;
		if (!strcasecmp(ext, ".it")) return TRUE;
		if (!strcasecmp(ext, ".xm")) return TRUE;
		if (!strcasecmp(ext, ".s3m")) return TRUE;
		if (!strcasecmp(ext, ".mod")) return TRUE;
	}
	return FALSE;
}

static gchar *get_title(gchar *filename)
{
	TitleInput *input;
	gchar *temp, *ext, *title, *path, *temp2;

	XMMS_NEW_TITLEINPUT(input);

	path = g_strdup(filename);
	temp = g_strdup(filename);
	ext = strrchr(temp, '.');
	if (ext)
		*ext = '\0';
	temp2 = strrchr(path, '/');
	if (temp2)
		*temp2 = '\0';

	input->file_name = g_basename(filename);
	input->file_ext = ext ? ext+1 : NULL;
	input->file_path = g_strdup_printf("%s/", path);

	title = xmms_get_titlestring(xmms_get_gentitle_format(), input);
	if ( title == NULL )
		title = g_strdup(input->file_name);

	g_free(temp);
	g_free(path);
	g_free(input);

	return title;
}

static void install_callbacks(DUH_SIGRENDERER *sr)
{
	DUMB_IT_SIGRENDERER *itsr = duh_get_it_sigrenderer(sr);
	dumb_it_set_loop_callback(itsr, &dumb_it_callback_terminate, NULL);
	dumb_it_set_xm_speed_zero_callback(itsr, &dumb_it_callback_terminate, NULL);
}

static void *play_loop(void *arg)
{
	char data[2048 * 2];
	int bytes, blk_size, rate;
	int actual_read;

	blk_size = 512 * (duh_file->bits_per_sample / 8) * duh_file->channels;
	rate = duh_file->samples_per_sec * duh_file->channels * (duh_file->bits_per_sample / 8);
	while (duh_file->going)
	{
		if (!duh_file->eof)
		{
			bytes = blk_size;
			if (duh_file->length - duh_file->position < bytes)
				bytes = duh_file->length - duh_file->position;
			if (bytes > 0)
			{
				actual_read = duh_render(duh_file->file, 16, 0, 1.0f, 65536.0f / duh_file->samples_per_sec, bytes / ((duh_file->bits_per_sample / 8) * duh_file->channels), data);
				actual_read *= (duh_file->bits_per_sample / 8) * duh_file->channels;
				//actual_read = fread(data, 1, bytes, duh_file->file);

				if (actual_read == 0)
				{
					// Should we do this or should we pad with silence?
					duh_file->eof = 1;
					duh_ip.output->buffer_free();
					duh_ip.output->buffer_free();
				}
				else
				{
					duh_ip.add_vis_pcm(duh_ip.output->written_time(), (duh_file->bits_per_sample == 16) ? FMT_S16_LE : FMT_U8,
					   duh_file->channels, bytes, data);
					while(duh_ip.output->buffer_free() < bytes && duh_file->going && duh_file->seek_to == -1)
						xmms_usleep(10000);
					if(duh_file->going && duh_file->seek_to == -1)
						duh_ip.output->write_audio(data, bytes);
					duh_file->position += actual_read;
				}
			}
			else
			{
				duh_file->eof = TRUE;
				duh_ip.output->buffer_free();
				duh_ip.output->buffer_free();
				xmms_usleep(10000);
			}
		}
		else
			xmms_usleep(10000);
		if (duh_file->seek_to != -1)
		{
			duh_file->position = duh_file->seek_to * rate;
			duh_end_sigrenderer(duh_file->file);
			duh_file->file = duh_start_sigrenderer(duh_file->duh, 0, duh_file->channels, duh_file->seek_to << 16);
			install_callbacks(duh_file->file);
			//fseek(duh_file->file, duh_file->position + duh_file->data_offset, SEEK_SET);
			duh_ip.output->flush(duh_file->seek_to * 1000);
			duh_file->seek_to = -1;
		}

	}
	duh_end_sigrenderer(duh_file->file);
	unload_duh(duh_file->duh);
	//fclose(duh_file->file);
	pthread_exit(NULL);
}

static void play_file(char *filename)
{
	char *name;
	int rate;

	audio_error = FALSE;

	duh_file = g_malloc(sizeof (DuhFile));
	memset(duh_file, 0, sizeof (DuhFile));

	duh_file->duh = load_duh(filename);
	if (!duh_file->duh) {
		duh_file->duh = dumb_load_it(filename);
		if (!duh_file->duh) {
			duh_file->duh = dumb_load_xm(filename);
			if (!duh_file->duh) {
				duh_file->duh = dumb_load_s3m(filename);
				if (!duh_file->duh) {
					duh_file->duh = dumb_load_mod(filename);
					if (!duh_file->duh) {
						g_free(duh_file);
						duh_file = NULL;
						return;
					}
				}
			}
		}
	}

	if ((duh_file->file = duh_start_sigrenderer(duh_file->duh, 0, 2, 0)))
	{
		install_callbacks(duh_file->file);
		duh_file->channels = 2;
		duh_file->samples_per_sec = 44100;
		duh_file->bits_per_sample = 16;
		duh_file->length = (long long)duh_get_length(duh_file->duh) * (44100 * 2 * 2) >> 16;
		duh_file->position = 0;
		duh_file->going = 1;

		if (duh_ip.output->open_audio((duh_file->bits_per_sample == 16) ? FMT_S16_LE : FMT_U8, duh_file->samples_per_sec, duh_file->channels) == 0)
		{
			audio_error = TRUE;
			duh_end_sigrenderer(duh_file->file);
			unload_duh(duh_file->duh);
			g_free(duh_file);
			duh_file = NULL;
			return;
		}
		name = get_title(filename);
		rate = duh_file->samples_per_sec * duh_file->channels * (duh_file->bits_per_sample / 8);
		duh_ip.set_info(name, 1000LL * duh_file->length / rate, 8 * rate, duh_file->samples_per_sec, duh_file->channels);
		g_free(name);
		duh_file->seek_to = -1;
		pthread_create(&decode_thread, NULL, play_loop, NULL);
	}
}

static void stop(void)
{
	if (duh_file && duh_file->going)
	{
		duh_file->going = 0;
		pthread_join(decode_thread, NULL);
		duh_ip.output->close_audio();
		g_free(duh_file);
		duh_file = NULL;
	}
}

static void duh_pause(short p)
{
	duh_ip.output->pause(p);
}

static void seek(int time)
{
	duh_file->seek_to = time;

	duh_file->eof = FALSE;

	while (duh_file->seek_to != -1)
		xmms_usleep(10000);
}

static int get_time(void)
{
	if (audio_error)
		return -2;
	if (!duh_file)
		return -1;
	if (!duh_file->going || (duh_file->eof && !duh_ip.output->buffer_playing()))
		return -1;
	else
	{
		return duh_ip.output->output_time();
	}
}

static void get_song_info(char *filename, char **title, int *length)
{
	DUH *duh = load_duh(filename);
	if (!duh) {
		duh = dumb_load_it(filename);
		if (!duh) {
			duh = dumb_load_xm(filename);
			if (!duh) {
				duh = dumb_load_s3m(filename);
				if (!duh) {
					duh = dumb_load_mod(filename);
					if (!duh) return;
				}
			}
		}
	}
	*length = (int)(duh_get_length(duh) * 1000LL >> 16);
	unload_duh(duh);

	(*title) = get_title(filename);
}
