/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <gtk/gtktreemodel.h>
#include <presentation-view.h>

#ifndef SLIDE_LIST_PROXY_H
#define SLIDE_LIST_PROXY_H

G_BEGIN_DECLS

typedef struct _CriaSlideListProxy CriaSlideListProxy;
typedef struct _CriaSlideListProxyClass CriaSlideListProxyClass;
typedef struct _CriaSlideListProxyPrivate CriaSlideListProxyPrivate;

CriaSlideListProxy* cria_slide_list_proxy_for_presentation(CriaPresentation	* self);
CriaSlide*          cria_slide_list_proxy_get_slide       (CriaSlideListProxy 	* self,
							   GtkTreeIter		* iter);
gint		    cria_slide_list_proxy_get_title_column(void);
GType		    cria_slide_list_proxy_get_type        (void);
CriaPresentation*   cria_slide_list_proxy_get_presentation(CriaSlideListProxy	* self);

#define CRIA_TYPE_SLIDE_LIST_PROXY			(cria_slide_list_proxy_get_type ())
#define CRIA_SLIDE_LIST_PROXY(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE_LIST_PROXY, CriaSlideListProxy))
#define CRIA_SLIDE_LIST_PROXY_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE_LIST_PROXY, CriaSlideListProxyClass))
#define CRIA_IS_SLIDE_LIST_PROXY(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE_LIST_PROXY))
#define CRIA_IS_SLIDE_LIST_PROXY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE_LIST_PROXY))
#define CRIA_SLIDE_LIST_PROXY_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE_LIST_PROXY, CriaSlideListProxyClass))

struct _CriaSlideListProxy {
	GObject			   base_instance;
	CriaSlideListProxyPrivate* priv;
};

struct _CriaSlideListProxyClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CriaSlideListProxy	* self,
				const	gchar	* string);
};

G_END_DECLS

#endif /* !SLIDE_LIST_PROXY_H */

