/**********************************************************************
*
*  nvspdif.h
*
*  Descripion  - Header file to support the spdif channel for nvaudio
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NVSPDIF_H_
#define _NVSPDIF_H_

#include "chaninfo.h"

enum {
    SP_BDBAR =   0x70,     /* Buffer Descriptor list Base Address */
    SP_CIV   =   0x74,     /* Current Index Value */
    SP_LVI   =   0x75,     /* Last Valid Index */
    SP_SR    =   0x76,     /* Status Register */
    SP_PICB  =   0x78,     /* Position In Current Buffer */
    SP_PIV   =   0x7a,     /* Prefetched Index Value */
    SP_CR    =   0x7b      /* Control Register */
};

unsigned int Nvaudio_set_spdif_rate(struct Nvaudio_state * state, unsigned int rate);
unsigned Nvaudio_get_spdma_addr(struct Nvaudio_state *state);
void __stop_spdif(struct Nvaudio_state *state);
void stop_spdif(struct Nvaudio_state *state);
void __start_spdif(struct Nvaudio_state *state);
void start_spdif(struct Nvaudio_state *state);
void __Nvaudio_update_splvi(struct Nvaudio_state *state);
void Nvaudio_update_splvi(struct Nvaudio_state *state);
void Nvaudio_update_spptr(struct Nvaudio_state *state);
int  Nvaudio_get_free_spwrite_space(struct Nvaudio_state *state);
int  drain_spdif(struct Nvaudio_state *state, int signals_allowed);
int  Nvaudio_spdifopen(struct Nvaudio_card  *card);
ssize_t Nvaudio_spdifwrite(struct Nvaudio_card *card, const char *buffer, size_t count);
void Nvaudio_channel_spdifinterrupt(struct Nvaudio_card *card);
#endif /* _NVSPIF_H_ */

