/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003-2004 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: kbd_win.h,v 1.15 2004/05/17 10:18:02 menno Exp $
**/

#ifndef __KBD_WIN_H__
#define __KBD_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

ALIGN static const real_t kbd_long_1024[] =
{
    FRAC_CONST(0.00029256153896361),
    FRAC_CONST(0.00042998567353047),
    FRAC_CONST(0.00054674074589540),
    FRAC_CONST(0.00065482304299792),
    FRAC_CONST(0.00075870195068747),
    FRAC_CONST(0.00086059331713336),
    FRAC_CONST(0.00096177541439010),
    FRAC_CONST(0.0010630609410878),
    FRAC_CONST(0.0011650036308132),
    FRAC_CONST(0.0012680012194148),
    FRAC_CONST(0.0013723517232956),
    FRAC_CONST(0.0014782864109136),
    FRAC_CONST(0.0015859901976719),
    FRAC_CONST(0.0016956148252373),
    FRAC_CONST(0.0018072876903517),
    FRAC_CONST(0.0019211179405514),
    FRAC_CONST(0.0020372007924215),
    FRAC_CONST(0.0021556206591754),
    FRAC_CONST(0.0022764534599614),
    FRAC_CONST(0.0023997683540995),
    FRAC_CONST(0.0025256290631156),
    FRAC_CONST(0.0026540948920831),
    FRAC_CONST(0.0027852215281403),
    FRAC_CONST(0.0029190616715331),
    FRAC_CONST(0.0030556655443223),
    FRAC_CONST(0.0031950812943391),
    FRAC_CONST(0.0033373553240392),
    FRAC_CONST(0.0034825325586930),
    FRAC_CONST(0.0036306566699199),
    FRAC_CONST(0.0037817702604646),
    FRAC_CONST(0.0039359150179719),
    FRAC_CONST(0.0040931318437260),
    FRAC_CONST(0.0042534609610026),
    FRAC_CONST(0.0044169420066964),
    FRAC_CONST(0.0045836141091341),
    FRAC_CONST(0.0047535159544086),
    FRAC_CONST(0.0049266858431214),
    FRAC_CONST(0.0051031617390698),
    FRAC_CONST(0.0052829813111335),
    FRAC_CONST(0.0054661819693975),
    FRAC_CONST(0.0056528008963682),
    FRAC_CONST(0.0058428750739943),
    FRAC_CONST(0.0060364413070882),
    FRAC_CONST(0.0062335362436492),
    FRAC_CONST(0.0064341963925079),
    FRAC_CONST(0.0066384581386503),
    FRAC_CONST(0.0068463577565218),
    FRAC_CONST(0.0070579314215715),
    FRAC_CONST(0.0072732152202559),
    FRAC_CONST(0.0074922451586909),
    FRAC_CONST(0.0077150571701162),
    FRAC_CONST(0.0079416871213115),
    FRAC_CONST(0.0081721708180857),
    FRAC_CONST(0.0084065440099458),
    FRAC_CONST(0.0086448423940363),
    FRAC_CONST(0.0088871016184291),
    FRAC_CONST(0.0091333572848345),
    FRAC_CONST(0.0093836449507939),
    FRAC_CONST(0.0096380001314086),
    FRAC_CONST(0.0098964583006517),
    FRAC_CONST(0.010159054892306),
    FRAC_CONST(0.010425825300561),
    FRAC_CONST(0.010696804880310),
    FRAC_CONST(0.010972028947167),
    FRAC_CONST(0.011251532777236),
    FRAC_CONST(0.011535351606646),
    FRAC_CONST(0.011823520630897),
    FRAC_CONST(0.012116075003993),
    FRAC_CONST(0.012413049837429),
    FRAC_CONST(0.012714480198999),
    FRAC_CONST(0.013020401111478),
    FRAC_CONST(0.013330847551161),
    FRAC_CONST(0.013645854446288),
    FRAC_CONST(0.013965456675352),
    FRAC_CONST(0.014289689065314),
    FRAC_CONST(0.014618586389712),
    FRAC_CONST(0.014952183366697),
    FRAC_CONST(0.015290514656976),
    FRAC_CONST(0.015633614861688),
    FRAC_CONST(0.015981518520214),
    FRAC_CONST(0.016334260107915),
    FRAC_CONST(0.016691874033817),
    FRAC_CONST(0.017054394638241),
    FRAC_CONST(0.017421856190380),
    FRAC_CONST(0.017794292885832),
    FRAC_CONST(0.018171738844085),
    FRAC_CONST(0.018554228105962),
    FRAC_CONST(0.018941794631032),
    FRAC_CONST(0.019334472294980),
    FRAC_CONST(0.019732294886947),
    FRAC_CONST(0.020135296106839),
    FRAC_CONST(0.020543509562604),
    FRAC_CONST(0.020956968767488),
    FRAC_CONST(0.021375707137257),
    FRAC_CONST(0.021799757987407),
    FRAC_CONST(0.022229154530343),
    FRAC_CONST(0.022663929872540),
    FRAC_CONST(0.023104117011689),
    FRAC_CONST(0.023549748833816),
    FRAC_CONST(0.024000858110398),
    FRAC_CONST(0.024457477495451),
    FRAC_CONST(0.024919639522613),
    FRAC_CONST(0.025387376602207),
    FRAC_CONST(0.025860721018295),
    FRAC_CONST(0.026339704925726),
    FRAC_CONST(0.026824360347160),
    FRAC_CONST(0.027314719170100),
    FRAC_CONST(0.027810813143900),
    FRAC_CONST(0.028312673876775),
    FRAC_CONST(0.028820332832801),
    FRAC_CONST(0.029333821328905),
    FRAC_CONST(0.029853170531859),
    FRAC_CONST(0.030378411455255),
    FRAC_CONST(0.030909574956490),
    FRAC_CONST(0.031446691733739),
    FRAC_CONST(0.031989792322926),
    FRAC_CONST(0.032538907094693),
    FRAC_CONST(0.033094066251369),
    FRAC_CONST(0.033655299823935),
    FRAC_CONST(0.034222637668991),
    FRAC_CONST(0.034796109465717),
    FRAC_CONST(0.035375744712844),
    FRAC_CONST(0.035961572725616),
    FRAC_CONST(0.036553622632758),
    FRAC_CONST(0.037151923373446),
    FRAC_CONST(0.037756503694277),
    FRAC_CONST(0.038367392146243),
    FRAC_CONST(0.038984617081711),
    FRAC_CONST(0.039608206651398),
    FRAC_CONST(0.040238188801359),
    FRAC_CONST(0.040874591269976),
    FRAC_CONST(0.041517441584950),
    FRAC_CONST(0.042166767060301),
    FRAC_CONST(0.042822594793376),
    FRAC_CONST(0.043484951661852),
    FRAC_CONST(0.044153864320760),
    FRAC_CONST(0.044829359199509),
    FRAC_CONST(0.045511462498913),
    FRAC_CONST(0.046200200188234),
    FRAC_CONST(0.046895598002228),
    FRAC_CONST(0.047597681438201),
    FRAC_CONST(0.048306475753074),
    FRAC_CONST(0.049022005960455),
    FRAC_CONST(0.049744296827725),
    FRAC_CONST(0.050473372873129),
    FRAC_CONST(0.051209258362879),
    FRAC_CONST(0.051951977308273),
    FRAC_CONST(0.052701553462813),
    FRAC_CONST(0.053458010319350),
    FRAC_CONST(0.054221371107223),
    FRAC_CONST(0.054991658789428),
    FRAC_CONST(0.055768896059787),
    FRAC_CONST(0.056553105340134),
    FRAC_CONST(0.057344308777513),
    FRAC_CONST(0.058142528241393),
    FRAC_CONST(0.058947785320893),
    FRAC_CONST(0.059760101322019),
    FRAC_CONST(0.060579497264926),
    FRAC_CONST(0.061405993881180),
    FRAC_CONST(0.062239611611049),
    FRAC_CONST(0.063080370600799),
    FRAC_CONST(0.063928290700012),
    FRAC_CONST(0.064783391458919),
    FRAC_CONST(0.065645692125747),
    FRAC_CONST(0.066515211644086),
    FRAC_CONST(0.067391968650269),
    FRAC_CONST(0.068275981470777),
    FRAC_CONST(0.069167268119652),
    FRAC_CONST(0.070065846295935),
    FRAC_CONST(0.070971733381121),
    FRAC_CONST(0.071884946436630),
    FRAC_CONST(0.072805502201299),
    FRAC_CONST(0.073733417088896),
    FRAC_CONST(0.074668707185649),
    FRAC_CONST(0.075611388247794),
    FRAC_CONST(0.076561475699152),
    FRAC_CONST(0.077518984628715),
    FRAC_CONST(0.078483929788261),
    FRAC_CONST(0.079456325589986),
    FRAC_CONST(0.080436186104162),
    FRAC_CONST(0.081423525056808),
    FRAC_CONST(0.082418355827392),
    FRAC_CONST(0.083420691446553),
    FRAC_CONST(0.084430544593841),
    FRAC_CONST(0.085447927595483),
    FRAC_CONST(0.086472852422178),
    FRAC_CONST(0.087505330686900),
    FRAC_CONST(0.088545373642744),
    FRAC_CONST(0.089592992180780),
    FRAC_CONST(0.090648196827937),
    FRAC_CONST(0.091710997744919),
    FRAC_CONST(0.092781404724131),
    FRAC_CONST(0.093859427187640),
    FRAC_CONST(0.094945074185163),
    FRAC_CONST(0.096038354392069),
    FRAC_CONST(0.097139276107423),
    FRAC_CONST(0.098247847252041),
    FRAC_CONST(0.099364075366580),
    FRAC_CONST(0.10048796760965),
    FRAC_CONST(0.10161953075597),
    FRAC_CONST(0.10275877119451),
    FRAC_CONST(0.10390569492671),
    FRAC_CONST(0.10506030756469),
    FRAC_CONST(0.10622261432949),
    FRAC_CONST(0.10739262004941),
    FRAC_CONST(0.10857032915821),
    FRAC_CONST(0.10975574569357),
    FRAC_CONST(0.11094887329534),
    FRAC_CONST(0.11214971520402),
    FRAC_CONST(0.11335827425914),
    FRAC_CONST(0.11457455289772),
    FRAC_CONST(0.11579855315274),
    FRAC_CONST(0.11703027665170),
    FRAC_CONST(0.11826972461510),
    FRAC_CONST(0.11951689785504),
    FRAC_CONST(0.12077179677383),
    FRAC_CONST(0.12203442136263),
    FRAC_CONST(0.12330477120008),
    FRAC_CONST(0.12458284545102),
    FRAC_CONST(0.12586864286523),
    FRAC_CONST(0.12716216177615),
    FRAC_CONST(0.12846340009971),
    FRAC_CONST(0.12977235533312),
    FRAC_CONST(0.13108902455375),
    FRAC_CONST(0.13241340441801),
    FRAC_CONST(0.13374549116025),
    FRAC_CONST(0.13508528059173),
    FRAC_CONST(0.13643276809961),
    FRAC_CONST(0.13778794864595),
    FRAC_CONST(0.13915081676677),
    FRAC_CONST(0.14052136657114),
    FRAC_CONST(0.14189959174027),
    FRAC_CONST(0.14328548552671),
    FRAC_CONST(0.14467904075349),
    FRAC_CONST(0.14608024981336),
    FRAC_CONST(0.14748910466804),
    FRAC_CONST(0.14890559684750),
    FRAC_CONST(0.15032971744929),
    FRAC_CONST(0.15176145713790),
    FRAC_CONST(0.15320080614414),
    FRAC_CONST(0.15464775426459),
    FRAC_CONST(0.15610229086100),
    FRAC_CONST(0.15756440485987),
    FRAC_CONST(0.15903408475193),
    FRAC_CONST(0.16051131859170),
    FRAC_CONST(0.16199609399712),
    FRAC_CONST(0.16348839814917),
    FRAC_CONST(0.16498821779156),
    FRAC_CONST(0.16649553923042),
    FRAC_CONST(0.16801034833404),
    FRAC_CONST(0.16953263053270),
    FRAC_CONST(0.17106237081842),
    FRAC_CONST(0.17259955374484),
    FRAC_CONST(0.17414416342714),
    FRAC_CONST(0.17569618354193),
    FRAC_CONST(0.17725559732720),
    FRAC_CONST(0.17882238758238),
    FRAC_CONST(0.18039653666830),
    FRAC_CONST(0.18197802650733),
    FRAC_CONST(0.18356683858343),
    FRAC_CONST(0.18516295394233),
    FRAC_CONST(0.18676635319174),
    FRAC_CONST(0.18837701650148),
    FRAC_CONST(0.18999492360384),
    FRAC_CONST(0.19162005379380),
    FRAC_CONST(0.19325238592940),
    FRAC_CONST(0.19489189843209),
    FRAC_CONST(0.19653856928714),
    FRAC_CONST(0.19819237604409),
    FRAC_CONST(0.19985329581721),
    FRAC_CONST(0.20152130528605),
    FRAC_CONST(0.20319638069594),
    FRAC_CONST(0.20487849785865),
    FRAC_CONST(0.20656763215298),
    FRAC_CONST(0.20826375852540),
    FRAC_CONST(0.20996685149083),
    FRAC_CONST(0.21167688513330),
    FRAC_CONST(0.21339383310678),
    FRAC_CONST(0.21511766863598),
    FRAC_CONST(0.21684836451719),
    FRAC_CONST(0.21858589311922),
    FRAC_CONST(0.22033022638425),
    FRAC_CONST(0.22208133582887),
    FRAC_CONST(0.22383919254503),
    FRAC_CONST(0.22560376720111),
    FRAC_CONST(0.22737503004300),
    FRAC_CONST(0.22915295089517),
    FRAC_CONST(0.23093749916189),
    FRAC_CONST(0.23272864382838),
    FRAC_CONST(0.23452635346201),
    FRAC_CONST(0.23633059621364),
    FRAC_CONST(0.23814133981883),
    FRAC_CONST(0.23995855159925),
    FRAC_CONST(0.24178219846403),
    FRAC_CONST(0.24361224691114),
    FRAC_CONST(0.24544866302890),
    FRAC_CONST(0.24729141249740),
    FRAC_CONST(0.24914046059007),
    FRAC_CONST(0.25099577217522),
    FRAC_CONST(0.25285731171763),
    FRAC_CONST(0.25472504328019),
    FRAC_CONST(0.25659893052556),
    FRAC_CONST(0.25847893671788),
    FRAC_CONST(0.26036502472451),
    FRAC_CONST(0.26225715701781),
    FRAC_CONST(0.26415529567692),
    FRAC_CONST(0.26605940238966),
    FRAC_CONST(0.26796943845439),
    FRAC_CONST(0.26988536478190),
    FRAC_CONST(0.27180714189742),
    FRAC_CONST(0.27373472994256),
    FRAC_CONST(0.27566808867736),
    FRAC_CONST(0.27760717748238),
    FRAC_CONST(0.27955195536071),
    FRAC_CONST(0.28150238094021),
    FRAC_CONST(0.28345841247557),
    FRAC_CONST(0.28542000785059),
    FRAC_CONST(0.28738712458038),
    FRAC_CONST(0.28935971981364),
    FRAC_CONST(0.29133775033492),
    FRAC_CONST(0.29332117256704),
    FRAC_CONST(0.29530994257338),
    FRAC_CONST(0.29730401606034),
    FRAC_CONST(0.29930334837974),
    FRAC_CONST(0.30130789453132),
    FRAC_CONST(0.30331760916521),
    FRAC_CONST(0.30533244658452),
    FRAC_CONST(0.30735236074785),
    FRAC_CONST(0.30937730527195),
    FRAC_CONST(0.31140723343430),
    FRAC_CONST(0.31344209817583),
    FRAC_CONST(0.31548185210356),
    FRAC_CONST(0.31752644749341),
    FRAC_CONST(0.31957583629288),
    FRAC_CONST(0.32162997012390),
    FRAC_CONST(0.32368880028565),
    FRAC_CONST(0.32575227775738),
    FRAC_CONST(0.32782035320134),
    FRAC_CONST(0.32989297696566),
    FRAC_CONST(0.33197009908736),
    FRAC_CONST(0.33405166929523),
    FRAC_CONST(0.33613763701295),
    FRAC_CONST(0.33822795136203),
    FRAC_CONST(0.34032256116495),
    FRAC_CONST(0.34242141494820),
    FRAC_CONST(0.34452446094547),
    FRAC_CONST(0.34663164710072),
    FRAC_CONST(0.34874292107143),
    FRAC_CONST(0.35085823023181),
    FRAC_CONST(0.35297752167598),
    FRAC_CONST(0.35510074222129),
    FRAC_CONST(0.35722783841160),
    FRAC_CONST(0.35935875652060),
    FRAC_CONST(0.36149344255514),
    FRAC_CONST(0.36363184225864),
    FRAC_CONST(0.36577390111444),
    FRAC_CONST(0.36791956434930),
    FRAC_CONST(0.37006877693676),
    FRAC_CONST(0.37222148360070),
    FRAC_CONST(0.37437762881878),
    FRAC_CONST(0.37653715682603),
    FRAC_CONST(0.37870001161834),
    FRAC_CONST(0.38086613695607),
    FRAC_CONST(0.38303547636766),
    FRAC_CONST(0.38520797315322),
    FRAC_CONST(0.38738357038821),
    FRAC_CONST(0.38956221092708),
    FRAC_CONST(0.39174383740701),
    FRAC_CONST(0.39392839225157),
    FRAC_CONST(0.39611581767449),
    FRAC_CONST(0.39830605568342),
    FRAC_CONST(0.40049904808370),
    FRAC_CONST(0.40269473648218),
    FRAC_CONST(0.40489306229101),
    FRAC_CONST(0.40709396673153),
    FRAC_CONST(0.40929739083810),
    FRAC_CONST(0.41150327546197),
    FRAC_CONST(0.41371156127524),
    FRAC_CONST(0.41592218877472),
    FRAC_CONST(0.41813509828594),
    FRAC_CONST(0.42035022996702),
    FRAC_CONST(0.42256752381274),
    FRAC_CONST(0.42478691965848),
    FRAC_CONST(0.42700835718423),
    FRAC_CONST(0.42923177591866),
    FRAC_CONST(0.43145711524314),
    FRAC_CONST(0.43368431439580),
    FRAC_CONST(0.43591331247564),
    FRAC_CONST(0.43814404844658),
    FRAC_CONST(0.44037646114161),
    FRAC_CONST(0.44261048926688),
    FRAC_CONST(0.44484607140589),
    FRAC_CONST(0.44708314602359),
    FRAC_CONST(0.44932165147057),
    FRAC_CONST(0.45156152598727),
    FRAC_CONST(0.45380270770813),
    FRAC_CONST(0.45604513466581),
    FRAC_CONST(0.45828874479543),
    FRAC_CONST(0.46053347593880),
    FRAC_CONST(0.46277926584861),
    FRAC_CONST(0.46502605219277),
    FRAC_CONST(0.46727377255861),
    FRAC_CONST(0.46952236445718),
    FRAC_CONST(0.47177176532752),
    FRAC_CONST(0.47402191254100),
    FRAC_CONST(0.47627274340557),
    FRAC_CONST(0.47852419517009),
    FRAC_CONST(0.48077620502869),
    FRAC_CONST(0.48302871012505),
    FRAC_CONST(0.48528164755674),
    FRAC_CONST(0.48753495437962),
    FRAC_CONST(0.48978856761212),
    FRAC_CONST(0.49204242423966),
    FRAC_CONST(0.49429646121898),
    FRAC_CONST(0.49655061548250),
    FRAC_CONST(0.49880482394273),
    FRAC_CONST(0.50105902349665),
    FRAC_CONST(0.50331315103004),
    FRAC_CONST(0.50556714342194),
    FRAC_CONST(0.50782093754901),
    FRAC_CONST(0.51007447028990),
    FRAC_CONST(0.51232767852971),
    FRAC_CONST(0.51458049916433),
    FRAC_CONST(0.51683286910489),
    FRAC_CONST(0.51908472528213),
    FRAC_CONST(0.52133600465083),
    FRAC_CONST(0.52358664419420),
    FRAC_CONST(0.52583658092832),
    FRAC_CONST(0.52808575190648),
    FRAC_CONST(0.53033409422367),
    FRAC_CONST(0.53258154502092),
    FRAC_CONST(0.53482804148974),
    FRAC_CONST(0.53707352087652),
    FRAC_CONST(0.53931792048690),
    FRAC_CONST(0.54156117769021),
    FRAC_CONST(0.54380322992385),
    FRAC_CONST(0.54604401469766),
    FRAC_CONST(0.54828346959835),
    FRAC_CONST(0.55052153229384),
    FRAC_CONST(0.55275814053768),
    FRAC_CONST(0.55499323217338),
    FRAC_CONST(0.55722674513883),
    FRAC_CONST(0.55945861747062),
    FRAC_CONST(0.56168878730842),
    FRAC_CONST(0.56391719289930),
    FRAC_CONST(0.56614377260214),
    FRAC_CONST(0.56836846489188),
    FRAC_CONST(0.57059120836390),
    FRAC_CONST(0.57281194173835),
    FRAC_CONST(0.57503060386439),
    FRAC_CONST(0.57724713372458),
    FRAC_CONST(0.57946147043912),
    FRAC_CONST(0.58167355327012),
    FRAC_CONST(0.58388332162591),
    FRAC_CONST(0.58609071506528),
    FRAC_CONST(0.58829567330173),
    FRAC_CONST(0.59049813620770),
    FRAC_CONST(0.59269804381879),
    FRAC_CONST(0.59489533633802),
    FRAC_CONST(0.59708995413996),
    FRAC_CONST(0.59928183777495),
    FRAC_CONST(0.60147092797329),
    FRAC_CONST(0.60365716564937),
    FRAC_CONST(0.60584049190582),
    FRAC_CONST(0.60802084803764),
    FRAC_CONST(0.61019817553632),
    FRAC_CONST(0.61237241609393),
    FRAC_CONST(0.61454351160718),
    FRAC_CONST(0.61671140418155),
    FRAC_CONST(0.61887603613527),
    FRAC_CONST(0.62103735000336),
    FRAC_CONST(0.62319528854167),
    FRAC_CONST(0.62534979473088),
    FRAC_CONST(0.62750081178042),
    FRAC_CONST(0.62964828313250),
    FRAC_CONST(0.63179215246597),
    FRAC_CONST(0.63393236370030),
    FRAC_CONST(0.63606886099946),
    FRAC_CONST(0.63820158877577),
    FRAC_CONST(0.64033049169379),
    FRAC_CONST(0.64245551467413),
    FRAC_CONST(0.64457660289729),
    FRAC_CONST(0.64669370180740),
    FRAC_CONST(0.64880675711607),
    FRAC_CONST(0.65091571480603),
    FRAC_CONST(0.65302052113494),
    FRAC_CONST(0.65512112263906),
    FRAC_CONST(0.65721746613689),
    FRAC_CONST(0.65930949873289),
    FRAC_CONST(0.66139716782102),
    FRAC_CONST(0.66348042108842),
    FRAC_CONST(0.66555920651892),
    FRAC_CONST(0.66763347239664),
    FRAC_CONST(0.66970316730947),
    FRAC_CONST(0.67176824015260),
    FRAC_CONST(0.67382864013196),
    FRAC_CONST(0.67588431676768),
    FRAC_CONST(0.67793521989751),
    FRAC_CONST(0.67998129968017),
    FRAC_CONST(0.68202250659876),
    FRAC_CONST(0.68405879146403),
    FRAC_CONST(0.68609010541774),
    FRAC_CONST(0.68811639993588),
    FRAC_CONST(0.69013762683195),
    FRAC_CONST(0.69215373826012),
    FRAC_CONST(0.69416468671849),
    FRAC_CONST(0.69617042505214),
    FRAC_CONST(0.69817090645634),
    FRAC_CONST(0.70016608447958),
    FRAC_CONST(0.70215591302664),
    FRAC_CONST(0.70414034636163),
    FRAC_CONST(0.70611933911096),
    FRAC_CONST(0.70809284626630),
    FRAC_CONST(0.71006082318751),
    FRAC_CONST(0.71202322560554),
    FRAC_CONST(0.71398000962530),
    FRAC_CONST(0.71593113172842),
    FRAC_CONST(0.71787654877613),
    FRAC_CONST(0.71981621801195),
    FRAC_CONST(0.72175009706445),
    FRAC_CONST(0.72367814394990),
    FRAC_CONST(0.72560031707496),
    FRAC_CONST(0.72751657523927),
    FRAC_CONST(0.72942687763803),
    FRAC_CONST(0.73133118386457),
    FRAC_CONST(0.73322945391280),
    FRAC_CONST(0.73512164817975),
    FRAC_CONST(0.73700772746796),
    FRAC_CONST(0.73888765298787),
    FRAC_CONST(0.74076138636020),
    FRAC_CONST(0.74262888961827),
    FRAC_CONST(0.74449012521027),
    FRAC_CONST(0.74634505600152),
    FRAC_CONST(0.74819364527663),
    FRAC_CONST(0.75003585674175),
    FRAC_CONST(0.75187165452661),
    FRAC_CONST(0.75370100318668),
    FRAC_CONST(0.75552386770515),
    FRAC_CONST(0.75734021349500),
    FRAC_CONST(0.75915000640095),
    FRAC_CONST(0.76095321270137),
    FRAC_CONST(0.76274979911019),
    FRAC_CONST(0.76453973277875),
    FRAC_CONST(0.76632298129757),
    FRAC_CONST(0.76809951269819),
    FRAC_CONST(0.76986929545481),
    FRAC_CONST(0.77163229848604),
    FRAC_CONST(0.77338849115651),
    FRAC_CONST(0.77513784327849),
    FRAC_CONST(0.77688032511340),
    FRAC_CONST(0.77861590737340),
    FRAC_CONST(0.78034456122283),
    FRAC_CONST(0.78206625827961),
    FRAC_CONST(0.78378097061667),
    FRAC_CONST(0.78548867076330),
    FRAC_CONST(0.78718933170643),
    FRAC_CONST(0.78888292689189),
    FRAC_CONST(0.79056943022564),
    FRAC_CONST(0.79224881607494),
    FRAC_CONST(0.79392105926949),
    FRAC_CONST(0.79558613510249),
    FRAC_CONST(0.79724401933170),
    FRAC_CONST(0.79889468818046),
    FRAC_CONST(0.80053811833858),
    FRAC_CONST(0.80217428696334),
    FRAC_CONST(0.80380317168028),
    FRAC_CONST(0.80542475058405),
    FRAC_CONST(0.80703900223920),
    FRAC_CONST(0.80864590568089),
    FRAC_CONST(0.81024544041560),
    FRAC_CONST(0.81183758642175),
    FRAC_CONST(0.81342232415032),
    FRAC_CONST(0.81499963452540),
    FRAC_CONST(0.81656949894467),
    FRAC_CONST(0.81813189927991),
    FRAC_CONST(0.81968681787738),
    FRAC_CONST(0.82123423755821),
    FRAC_CONST(0.82277414161874),
    FRAC_CONST(0.82430651383076),
    FRAC_CONST(0.82583133844180),
    FRAC_CONST(0.82734860017528),
    FRAC_CONST(0.82885828423070),
    FRAC_CONST(0.83036037628369),
    FRAC_CONST(0.83185486248609),
    FRAC_CONST(0.83334172946597),
    FRAC_CONST(0.83482096432759),
    FRAC_CONST(0.83629255465130),
    FRAC_CONST(0.83775648849344),
    FRAC_CONST(0.83921275438615),
    FRAC_CONST(0.84066134133716),
    FRAC_CONST(0.84210223882952),
    FRAC_CONST(0.84353543682130),
    FRAC_CONST(0.84496092574524),
    FRAC_CONST(0.84637869650833),
    FRAC_CONST(0.84778874049138),
    FRAC_CONST(0.84919104954855),
    FRAC_CONST(0.85058561600677),
    FRAC_CONST(0.85197243266520),
    FRAC_CONST(0.85335149279457),
    FRAC_CONST(0.85472279013653),
    FRAC_CONST(0.85608631890295),
    FRAC_CONST(0.85744207377513),
    FRAC_CONST(0.85879004990298),
    FRAC_CONST(0.86013024290422),
    FRAC_CONST(0.86146264886346),
    FRAC_CONST(0.86278726433124),
    FRAC_CONST(0.86410408632306),
    FRAC_CONST(0.86541311231838),
    FRAC_CONST(0.86671434025950),
    FRAC_CONST(0.86800776855046),
    FRAC_CONST(0.86929339605590),
    FRAC_CONST(0.87057122209981),
    FRAC_CONST(0.87184124646433),
    FRAC_CONST(0.87310346938840),
    FRAC_CONST(0.87435789156650),
    FRAC_CONST(0.87560451414719),
    FRAC_CONST(0.87684333873173),
    FRAC_CONST(0.87807436737261),
    FRAC_CONST(0.87929760257204),
    FRAC_CONST(0.88051304728038),
    FRAC_CONST(0.88172070489456),
    FRAC_CONST(0.88292057925645),
    FRAC_CONST(0.88411267465117),
    FRAC_CONST(0.88529699580537),
    FRAC_CONST(0.88647354788545),
    FRAC_CONST(0.88764233649580),
    FRAC_CONST(0.88880336767692),
    FRAC_CONST(0.88995664790351),
    FRAC_CONST(0.89110218408260),
    FRAC_CONST(0.89223998355154),
    FRAC_CONST(0.89337005407600),
    FRAC_CONST(0.89449240384793),
    FRAC_CONST(0.89560704148345),
    FRAC_CONST(0.89671397602074),
    FRAC_CONST(0.89781321691786),
    FRAC_CONST(0.89890477405053),
    FRAC_CONST(0.89998865770993),
    FRAC_CONST(0.90106487860034),
    FRAC_CONST(0.90213344783689),
    FRAC_CONST(0.90319437694315),
    FRAC_CONST(0.90424767784873),
    FRAC_CONST(0.90529336288690),
    FRAC_CONST(0.90633144479201),
    FRAC_CONST(0.90736193669708),
    FRAC_CONST(0.90838485213119),
    FRAC_CONST(0.90940020501694),
    FRAC_CONST(0.91040800966776),
    FRAC_CONST(0.91140828078533),
    FRAC_CONST(0.91240103345685),
    FRAC_CONST(0.91338628315231),
    FRAC_CONST(0.91436404572173),
    FRAC_CONST(0.91533433739238),
    FRAC_CONST(0.91629717476594),
    FRAC_CONST(0.91725257481564),
    FRAC_CONST(0.91820055488334),
    FRAC_CONST(0.91914113267664),
    FRAC_CONST(0.92007432626589),
    FRAC_CONST(0.92100015408120),
    FRAC_CONST(0.92191863490944),
    FRAC_CONST(0.92282978789113),
    FRAC_CONST(0.92373363251740),
    FRAC_CONST(0.92463018862687),
    FRAC_CONST(0.92551947640245),
    FRAC_CONST(0.92640151636824),
    FRAC_CONST(0.92727632938624),
    FRAC_CONST(0.92814393665320),
    FRAC_CONST(0.92900435969727),
    FRAC_CONST(0.92985762037477),
    FRAC_CONST(0.93070374086684),
    FRAC_CONST(0.93154274367610),
    FRAC_CONST(0.93237465162328),
    FRAC_CONST(0.93319948784382),
    FRAC_CONST(0.93401727578443),
    FRAC_CONST(0.93482803919967),
    FRAC_CONST(0.93563180214841),
    FRAC_CONST(0.93642858899043),
    FRAC_CONST(0.93721842438279),
    FRAC_CONST(0.93800133327637),
    FRAC_CONST(0.93877734091223),
    FRAC_CONST(0.93954647281807),
    FRAC_CONST(0.94030875480458),
    FRAC_CONST(0.94106421296182),
    FRAC_CONST(0.94181287365556),
    FRAC_CONST(0.94255476352362),
    FRAC_CONST(0.94328990947213),
    FRAC_CONST(0.94401833867184),
    FRAC_CONST(0.94474007855439),
    FRAC_CONST(0.94545515680855),
    FRAC_CONST(0.94616360137644),
    FRAC_CONST(0.94686544044975),
    FRAC_CONST(0.94756070246592),
    FRAC_CONST(0.94824941610434),
    FRAC_CONST(0.94893161028248),
    FRAC_CONST(0.94960731415209),
    FRAC_CONST(0.95027655709525),
    FRAC_CONST(0.95093936872056),
    FRAC_CONST(0.95159577885924),
    FRAC_CONST(0.95224581756115),
    FRAC_CONST(0.95288951509097),
    FRAC_CONST(0.95352690192417),
    FRAC_CONST(0.95415800874314),
    FRAC_CONST(0.95478286643320),
    FRAC_CONST(0.95540150607863),
    FRAC_CONST(0.95601395895871),
    FRAC_CONST(0.95662025654373),
    FRAC_CONST(0.95722043049100),
    FRAC_CONST(0.95781451264084),
    FRAC_CONST(0.95840253501260),
    FRAC_CONST(0.95898452980058),
    FRAC_CONST(0.95956052937008),
    FRAC_CONST(0.96013056625336),
    FRAC_CONST(0.96069467314557),
    FRAC_CONST(0.96125288290073),
    FRAC_CONST(0.96180522852773),
    FRAC_CONST(0.96235174318622),
    FRAC_CONST(0.96289246018262),
    FRAC_CONST(0.96342741296604),
    FRAC_CONST(0.96395663512424),
    FRAC_CONST(0.96448016037959),
    FRAC_CONST(0.96499802258499),
    FRAC_CONST(0.96551025571985),
    FRAC_CONST(0.96601689388602),
    FRAC_CONST(0.96651797130376),
    FRAC_CONST(0.96701352230768),
    FRAC_CONST(0.96750358134269),
    FRAC_CONST(0.96798818295998),
    FRAC_CONST(0.96846736181297),
    FRAC_CONST(0.96894115265327),
    FRAC_CONST(0.96940959032667),
    FRAC_CONST(0.96987270976912),
    FRAC_CONST(0.97033054600270),
    FRAC_CONST(0.97078313413161),
    FRAC_CONST(0.97123050933818),
    FRAC_CONST(0.97167270687887),
    FRAC_CONST(0.97210976208030),
    FRAC_CONST(0.97254171033525),
    FRAC_CONST(0.97296858709871),
    FRAC_CONST(0.97339042788392),
    FRAC_CONST(0.97380726825843),
    FRAC_CONST(0.97421914384017),
    FRAC_CONST(0.97462609029350),
    FRAC_CONST(0.97502814332534),
    FRAC_CONST(0.97542533868127),
    FRAC_CONST(0.97581771214160),
    FRAC_CONST(0.97620529951759),
    FRAC_CONST(0.97658813664749),
    FRAC_CONST(0.97696625939282),
    FRAC_CONST(0.97733970363445),
    FRAC_CONST(0.97770850526884),
    FRAC_CONST(0.97807270020427),
    FRAC_CONST(0.97843232435704),
    FRAC_CONST(0.97878741364771),
    FRAC_CONST(0.97913800399743),
    FRAC_CONST(0.97948413132414),
    FRAC_CONST(0.97982583153895),
    FRAC_CONST(0.98016314054243),
    FRAC_CONST(0.98049609422096),
    FRAC_CONST(0.98082472844313),
    FRAC_CONST(0.98114907905608),
    FRAC_CONST(0.98146918188197),
    FRAC_CONST(0.98178507271438),
    FRAC_CONST(0.98209678731477),
    FRAC_CONST(0.98240436140902),
    FRAC_CONST(0.98270783068385),
    FRAC_CONST(0.98300723078342),
    FRAC_CONST(0.98330259730589),
    FRAC_CONST(0.98359396579995),
    FRAC_CONST(0.98388137176152),
    FRAC_CONST(0.98416485063031),
    FRAC_CONST(0.98444443778651),
    FRAC_CONST(0.98472016854752),
    FRAC_CONST(0.98499207816463),
    FRAC_CONST(0.98526020181980),
    FRAC_CONST(0.98552457462240),
    FRAC_CONST(0.98578523160609),
    FRAC_CONST(0.98604220772560),
    FRAC_CONST(0.98629553785362),
    FRAC_CONST(0.98654525677772),
    FRAC_CONST(0.98679139919726),
    FRAC_CONST(0.98703399972035),
    FRAC_CONST(0.98727309286089),
    FRAC_CONST(0.98750871303556),
    FRAC_CONST(0.98774089456089),
    FRAC_CONST(0.98796967165036),
    FRAC_CONST(0.98819507841154),
    FRAC_CONST(0.98841714884323),
    FRAC_CONST(0.98863591683269),
    FRAC_CONST(0.98885141615285),
    FRAC_CONST(0.98906368045957),
    FRAC_CONST(0.98927274328896),
    FRAC_CONST(0.98947863805473),
    FRAC_CONST(0.98968139804554),
    FRAC_CONST(0.98988105642241),
    FRAC_CONST(0.99007764621618),
    FRAC_CONST(0.99027120032501),
    FRAC_CONST(0.99046175151186),
    FRAC_CONST(0.99064933240208),
    FRAC_CONST(0.99083397548099),
    FRAC_CONST(0.99101571309153),
    FRAC_CONST(0.99119457743191),
    FRAC_CONST(0.99137060055337),
    FRAC_CONST(0.99154381435784),
    FRAC_CONST(0.99171425059582),
    FRAC_CONST(0.99188194086414),
    FRAC_CONST(0.99204691660388),
    FRAC_CONST(0.99220920909823),
    FRAC_CONST(0.99236884947045),
    FRAC_CONST(0.99252586868186),
    FRAC_CONST(0.99268029752989),
    FRAC_CONST(0.99283216664606),
    FRAC_CONST(0.99298150649419),
    FRAC_CONST(0.99312834736847),
    FRAC_CONST(0.99327271939167),
    FRAC_CONST(0.99341465251338),
    FRAC_CONST(0.99355417650825),
    FRAC_CONST(0.99369132097430),
    FRAC_CONST(0.99382611533130),
    FRAC_CONST(0.99395858881910),
    FRAC_CONST(0.99408877049612),
    FRAC_CONST(0.99421668923778),
    FRAC_CONST(0.99434237373503),
    FRAC_CONST(0.99446585249289),
    FRAC_CONST(0.99458715382906),
    FRAC_CONST(0.99470630587254),
    FRAC_CONST(0.99482333656229),
    FRAC_CONST(0.99493827364600),
    FRAC_CONST(0.99505114467878),
    FRAC_CONST(0.99516197702200),
    FRAC_CONST(0.99527079784214),
    FRAC_CONST(0.99537763410962),
    FRAC_CONST(0.99548251259777),
    FRAC_CONST(0.99558545988178),
    FRAC_CONST(0.99568650233767),
    FRAC_CONST(0.99578566614138),
    FRAC_CONST(0.99588297726783),
    FRAC_CONST(0.99597846149005),
    FRAC_CONST(0.99607214437834),
    FRAC_CONST(0.99616405129947),
    FRAC_CONST(0.99625420741595),
    FRAC_CONST(0.99634263768527),
    FRAC_CONST(0.99642936685928),
    FRAC_CONST(0.99651441948352),
    FRAC_CONST(0.99659781989663),
    FRAC_CONST(0.99667959222978),
    FRAC_CONST(0.99675976040620),
    FRAC_CONST(0.99683834814063),
    FRAC_CONST(0.99691537893895),
    FRAC_CONST(0.99699087609774),
    FRAC_CONST(0.99706486270391),
    FRAC_CONST(0.99713736163442),
    FRAC_CONST(0.99720839555593),
    FRAC_CONST(0.99727798692461),
    FRAC_CONST(0.99734615798589),
    FRAC_CONST(0.99741293077431),
    FRAC_CONST(0.99747832711337),
    FRAC_CONST(0.99754236861541),
    FRAC_CONST(0.99760507668158),
    FRAC_CONST(0.99766647250181),
    FRAC_CONST(0.99772657705478),
    FRAC_CONST(0.99778541110799),
    FRAC_CONST(0.99784299521785),
    FRAC_CONST(0.99789934972976),
    FRAC_CONST(0.99795449477828),
    FRAC_CONST(0.99800845028730),
    FRAC_CONST(0.99806123597027),
    FRAC_CONST(0.99811287133042),
    FRAC_CONST(0.99816337566108),
    FRAC_CONST(0.99821276804596),
    FRAC_CONST(0.99826106735952),
    FRAC_CONST(0.99830829226732),
    FRAC_CONST(0.99835446122649),
    FRAC_CONST(0.99839959248609),
    FRAC_CONST(0.99844370408765),
    FRAC_CONST(0.99848681386566),
    FRAC_CONST(0.99852893944805),
    FRAC_CONST(0.99857009825685),
    FRAC_CONST(0.99861030750869),
    FRAC_CONST(0.99864958421549),
    FRAC_CONST(0.99868794518504),
    FRAC_CONST(0.99872540702178),
    FRAC_CONST(0.99876198612738),
    FRAC_CONST(0.99879769870160),
    FRAC_CONST(0.99883256074295),
    FRAC_CONST(0.99886658804953),
    FRAC_CONST(0.99889979621983),
    FRAC_CONST(0.99893220065356),
    FRAC_CONST(0.99896381655254),
    FRAC_CONST(0.99899465892154),
    FRAC_CONST(0.99902474256924),
    FRAC_CONST(0.99905408210916),
    FRAC_CONST(0.99908269196056),
    FRAC_CONST(0.99911058634952),
    FRAC_CONST(0.99913777930986),
    FRAC_CONST(0.99916428468421),
    FRAC_CONST(0.99919011612505),
    FRAC_CONST(0.99921528709576),
    FRAC_CONST(0.99923981087174),
    FRAC_CONST(0.99926370054150),
    FRAC_CONST(0.99928696900779),
    FRAC_CONST(0.99930962898876),
    FRAC_CONST(0.99933169301910),
    FRAC_CONST(0.99935317345126),
    FRAC_CONST(0.99937408245662),
    FRAC_CONST(0.99939443202674),
    FRAC_CONST(0.99941423397457),
    FRAC_CONST(0.99943349993572),
    FRAC_CONST(0.99945224136972),
    FRAC_CONST(0.99947046956130),
    FRAC_CONST(0.99948819562171),
    FRAC_CONST(0.99950543049000),
    FRAC_CONST(0.99952218493439),
    FRAC_CONST(0.99953846955355),
    FRAC_CONST(0.99955429477803),
    FRAC_CONST(0.99956967087154),
    FRAC_CONST(0.99958460793242),
    FRAC_CONST(0.99959911589494),
    FRAC_CONST(0.99961320453077),
    FRAC_CONST(0.99962688345035),
    FRAC_CONST(0.99964016210433),
    FRAC_CONST(0.99965304978499),
    FRAC_CONST(0.99966555562769),
    FRAC_CONST(0.99967768861231),
    FRAC_CONST(0.99968945756473),
    FRAC_CONST(0.99970087115825),
    FRAC_CONST(0.99971193791510),
    FRAC_CONST(0.99972266620792),
    FRAC_CONST(0.99973306426121),
    FRAC_CONST(0.99974314015288),
    FRAC_CONST(0.99975290181568),
    FRAC_CONST(0.99976235703876),
    FRAC_CONST(0.99977151346914),
    FRAC_CONST(0.99978037861326),
    FRAC_CONST(0.99978895983845),
    FRAC_CONST(0.99979726437448),
    FRAC_CONST(0.99980529931507),
    FRAC_CONST(0.99981307161943),
    FRAC_CONST(0.99982058811377),
    FRAC_CONST(0.99982785549283),
    FRAC_CONST(0.99983488032144),
    FRAC_CONST(0.99984166903600),
    FRAC_CONST(0.99984822794606),
    FRAC_CONST(0.99985456323584),
    FRAC_CONST(0.99986068096572),
    FRAC_CONST(0.99986658707386),
    FRAC_CONST(0.99987228737764),
    FRAC_CONST(0.99987778757524),
    FRAC_CONST(0.99988309324717),
    FRAC_CONST(0.99988820985777),
    FRAC_CONST(0.99989314275675),
    FRAC_CONST(0.99989789718072),
    FRAC_CONST(0.99990247825468),
    FRAC_CONST(0.99990689099357),
    FRAC_CONST(0.99991114030376),
    FRAC_CONST(0.99991523098456),
    FRAC_CONST(0.99991916772971),
    FRAC_CONST(0.99992295512891),
    FRAC_CONST(0.99992659766930),
    FRAC_CONST(0.99993009973692),
    FRAC_CONST(0.99993346561824),
    FRAC_CONST(0.99993669950161),
    FRAC_CONST(0.99993980547870),
    FRAC_CONST(0.99994278754604),
    FRAC_CONST(0.99994564960642),
    FRAC_CONST(0.99994839547033),
    FRAC_CONST(0.99995102885747),
    FRAC_CONST(0.99995355339809),
    FRAC_CONST(0.99995597263451),
    FRAC_CONST(0.99995829002249),
    FRAC_CONST(0.99996050893264),
    FRAC_CONST(0.99996263265183),
    FRAC_CONST(0.99996466438460),
    FRAC_CONST(0.99996660725452),
    FRAC_CONST(0.99996846430558),
    FRAC_CONST(0.99997023850356),
    FRAC_CONST(0.99997193273736),
    FRAC_CONST(0.99997354982037),
    FRAC_CONST(0.99997509249183),
    FRAC_CONST(0.99997656341810),
    FRAC_CONST(0.99997796519400),
    FRAC_CONST(0.99997930034415),
    FRAC_CONST(0.99998057132421),
    FRAC_CONST(0.99998178052220),
    FRAC_CONST(0.99998293025975),
    FRAC_CONST(0.99998402279338),
    FRAC_CONST(0.99998506031574),
    FRAC_CONST(0.99998604495686),
    FRAC_CONST(0.99998697878536),
    FRAC_CONST(0.99998786380966),
    FRAC_CONST(0.99998870197921),
    FRAC_CONST(0.99998949518567),
    FRAC_CONST(0.99999024526408),
    FRAC_CONST(0.99999095399401),
    FRAC_CONST(0.99999162310077),
    FRAC_CONST(0.99999225425649),
    FRAC_CONST(0.99999284908128),
    FRAC_CONST(0.99999340914435),
    FRAC_CONST(0.99999393596510),
    FRAC_CONST(0.99999443101421),
    FRAC_CONST(0.99999489571473),
    FRAC_CONST(0.99999533144314),
    FRAC_CONST(0.99999573953040),
    FRAC_CONST(0.99999612126300),
    FRAC_CONST(0.99999647788395),
    FRAC_CONST(0.99999681059383),
    FRAC_CONST(0.99999712055178),
    FRAC_CONST(0.99999740887647),
    FRAC_CONST(0.99999767664709),
    FRAC_CONST(0.99999792490431),
    FRAC_CONST(0.99999815465123),
    FRAC_CONST(0.99999836685427),
    FRAC_CONST(0.99999856244415),
    FRAC_CONST(0.99999874231676),
    FRAC_CONST(0.99999890733405),
    FRAC_CONST(0.99999905832493),
    FRAC_CONST(0.99999919608613),
    FRAC_CONST(0.99999932138304),
    FRAC_CONST(0.99999943495056),
    FRAC_CONST(0.99999953749392),
    FRAC_CONST(0.99999962968950),
    FRAC_CONST(0.99999971218563),
    FRAC_CONST(0.99999978560337),
    FRAC_CONST(0.99999985053727),
    FRAC_CONST(0.99999990755616),
    FRAC_CONST(0.99999995720387)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t kbd_long_960[] = {
    FRAC_CONST(0.0003021562530949),
    FRAC_CONST(0.0004452267024786),
    FRAC_CONST(0.0005674947527496),
    FRAC_CONST(0.0006812465553466),
    FRAC_CONST(0.0007910496776387),
    FRAC_CONST(0.0008991655033895),
    FRAC_CONST(0.0010068978259384),
    FRAC_CONST(0.0011150758515751),
    FRAC_CONST(0.0012242653193642),
    FRAC_CONST(0.0013348735658205),
    FRAC_CONST(0.0014472068670273),
    FRAC_CONST(0.0015615039850448),
    FRAC_CONST(0.0016779568885263),
    FRAC_CONST(0.0017967241232412),
    FRAC_CONST(0.0019179397560955),
    FRAC_CONST(0.0020417195415393),
    FRAC_CONST(0.0021681652836642),
    FRAC_CONST(0.0022973679910599),
    FRAC_CONST(0.0024294102029937),
    FRAC_CONST(0.0025643677339078),
    FRAC_CONST(0.0027023110014772),
    FRAC_CONST(0.0028433060512612),
    FRAC_CONST(0.0029874153568025),
    FRAC_CONST(0.0031346984511728),
    FRAC_CONST(0.0032852124303662),
    FRAC_CONST(0.0034390123581190),
    FRAC_CONST(0.0035961515940931),
    FRAC_CONST(0.0037566820618961),
    FRAC_CONST(0.0039206544694386),
    FRAC_CONST(0.0040881184912194),
    FRAC_CONST(0.0042591229199617),
    FRAC_CONST(0.0044337157933972),
    FRAC_CONST(0.0046119445007641),
    FRAC_CONST(0.0047938558726415),
    FRAC_CONST(0.0049794962570131),
    FRAC_CONST(0.0051689115838900),
    FRAC_CONST(0.0053621474203763),
    FRAC_CONST(0.0055592490177131),
    FRAC_CONST(0.0057602613515573),
    FRAC_CONST(0.0059652291565289),
    FRAC_CONST(0.0061741969558843),
    FRAC_CONST(0.0063872090870253),
    FRAC_CONST(0.0066043097234387),
    FRAC_CONST(0.0068255428935640),
    FRAC_CONST(0.0070509524970088),
    FRAC_CONST(0.0072805823184660),
    FRAC_CONST(0.0075144760396340),
    FRAC_CONST(0.0077526772493942),
    FRAC_CONST(0.0079952294524673),
    FRAC_CONST(0.0082421760767325),
    FRAC_CONST(0.0084935604793733),
    FRAC_CONST(0.0087494259519870),
    FRAC_CONST(0.0090098157247792),
    FRAC_CONST(0.0092747729699467),
    FRAC_CONST(0.0095443408043399),
    FRAC_CONST(0.0098185622914832),
    FRAC_CONST(0.0100974804430226),
    FRAC_CONST(0.0103811382196612),
    FRAC_CONST(0.0106695785316351),
    FRAC_CONST(0.0109628442387771),
    FRAC_CONST(0.0112609781502091),
    FRAC_CONST(0.0115640230236993),
    FRAC_CONST(0.0118720215647169),
    FRAC_CONST(0.0121850164252137),
    FRAC_CONST(0.0125030502021561),
    FRAC_CONST(0.0128261654358321),
    FRAC_CONST(0.0131544046079532),
    FRAC_CONST(0.0134878101395681),
    FRAC_CONST(0.0138264243888068),
    FRAC_CONST(0.0141702896484671),
    FRAC_CONST(0.0145194481434592),
    FRAC_CONST(0.0148739420281182),
    FRAC_CONST(0.0152338133833959),
    FRAC_CONST(0.0155991042139432),
    FRAC_CONST(0.0159698564450882),
    FRAC_CONST(0.0163461119197227),
    FRAC_CONST(0.0167279123950996),
    FRAC_CONST(0.0171152995395520),
    FRAC_CONST(0.0175083149291368),
    FRAC_CONST(0.0179070000442104),
    FRAC_CONST(0.0183113962659409),
    FRAC_CONST(0.0187215448727609),
    FRAC_CONST(0.0191374870367659),
    FRAC_CONST(0.0195592638200623),
    FRAC_CONST(0.0199869161710679),
    FRAC_CONST(0.0204204849207691),
    FRAC_CONST(0.0208600107789370),
    FRAC_CONST(0.0213055343303066),
    FRAC_CONST(0.0217570960307201),
    FRAC_CONST(0.0222147362032386),
    FRAC_CONST(0.0226784950342228),
    FRAC_CONST(0.0231484125693867),
    FRAC_CONST(0.0236245287098244),
    FRAC_CONST(0.0241068832080138),
    FRAC_CONST(0.0245955156637973),
    FRAC_CONST(0.0250904655203431),
    FRAC_CONST(0.0255917720600868),
    FRAC_CONST(0.0260994744006559),
    FRAC_CONST(0.0266136114907790),
    FRAC_CONST(0.0271342221061795),
    FRAC_CONST(0.0276613448454576),
    FRAC_CONST(0.0281950181259587),
    FRAC_CONST(0.0287352801796329),
    FRAC_CONST(0.0292821690488833),
    FRAC_CONST(0.0298357225824074),
    FRAC_CONST(0.0303959784310299),
    FRAC_CONST(0.0309629740435296),
    FRAC_CONST(0.0315367466624615),
    FRAC_CONST(0.0321173333199732),
    FRAC_CONST(0.0327047708336193),
    FRAC_CONST(0.0332990958021720),
    FRAC_CONST(0.0339003446014307),
    FRAC_CONST(0.0345085533800302),
    FRAC_CONST(0.0351237580552491),
    FRAC_CONST(0.0357459943088193),
    FRAC_CONST(0.0363752975827358),
    FRAC_CONST(0.0370117030750704),
    FRAC_CONST(0.0376552457357870),
    FRAC_CONST(0.0383059602625614),
    FRAC_CONST(0.0389638810966056),
    FRAC_CONST(0.0396290424184964),
    FRAC_CONST(0.0403014781440112),
    FRAC_CONST(0.0409812219199691),
    FRAC_CONST(0.0416683071200799),
    FRAC_CONST(0.0423627668408009),
    FRAC_CONST(0.0430646338972016),
    FRAC_CONST(0.0437739408188385),
    FRAC_CONST(0.0444907198456388),
    FRAC_CONST(0.0452150029237951),
    FRAC_CONST(0.0459468217016708),
    FRAC_CONST(0.0466862075257170),
    FRAC_CONST(0.0474331914364021),
    FRAC_CONST(0.0481878041641539),
    FRAC_CONST(0.0489500761253148),
    FRAC_CONST(0.0497200374181119),
    FRAC_CONST(0.0504977178186404),
    FRAC_CONST(0.0512831467768636),
    FRAC_CONST(0.0520763534126273),
    FRAC_CONST(0.0528773665116913),
    FRAC_CONST(0.0536862145217772),
    FRAC_CONST(0.0545029255486345),
    FRAC_CONST(0.0553275273521232),
    FRAC_CONST(0.0561600473423164),
    FRAC_CONST(0.0570005125756209),
    FRAC_CONST(0.0578489497509179),
    FRAC_CONST(0.0587053852057233),
    FRAC_CONST(0.0595698449123695),
    FRAC_CONST(0.0604423544742077),
    FRAC_CONST(0.0613229391218317),
    FRAC_CONST(0.0622116237093247),
    FRAC_CONST(0.0631084327105284),
    FRAC_CONST(0.0640133902153352),
    FRAC_CONST(0.0649265199260043),
    FRAC_CONST(0.0658478451535027),
    FRAC_CONST(0.0667773888138695),
    FRAC_CONST(0.0677151734246072),
    FRAC_CONST(0.0686612211010977),
    FRAC_CONST(0.0696155535530446),
    FRAC_CONST(0.0705781920809429),
    FRAC_CONST(0.0715491575725758),
    FRAC_CONST(0.0725284704995383),
    FRAC_CONST(0.0735161509137906),
    FRAC_CONST(0.0745122184442388),
    FRAC_CONST(0.0755166922933461),
    FRAC_CONST(0.0765295912337720),
    FRAC_CONST(0.0775509336050437),
    FRAC_CONST(0.0785807373102561),
    FRAC_CONST(0.0796190198128044),
    FRAC_CONST(0.0806657981331473),
    FRAC_CONST(0.0817210888456026),
    FRAC_CONST(0.0827849080751753),
    FRAC_CONST(0.0838572714944183),
    FRAC_CONST(0.0849381943203265),
    FRAC_CONST(0.0860276913112652),
    FRAC_CONST(0.0871257767639319),
    FRAC_CONST(0.0882324645103534),
    FRAC_CONST(0.0893477679149177),
    FRAC_CONST(0.0904716998714418),
    FRAC_CONST(0.0916042728002747),
    FRAC_CONST(0.0927454986454381),
    FRAC_CONST(0.0938953888718020),
    FRAC_CONST(0.0950539544622996),
    FRAC_CONST(0.0962212059151784),
    FRAC_CONST(0.0973971532412897),
    FRAC_CONST(0.0985818059614169),
    FRAC_CONST(0.0997751731036425),
    FRAC_CONST(0.1009772632007537),
    FRAC_CONST(0.1021880842876888),
    FRAC_CONST(0.1034076438990227),
    FRAC_CONST(0.1046359490664932),
    FRAC_CONST(0.1058730063165681),
    FRAC_CONST(0.1071188216680533),
    FRAC_CONST(0.1083734006297428),
    FRAC_CONST(0.1096367481981100),
    FRAC_CONST(0.1109088688550422),
    FRAC_CONST(0.1121897665656167),
    FRAC_CONST(0.1134794447759207),
    FRAC_CONST(0.1147779064109143),
    FRAC_CONST(0.1160851538723372),
    FRAC_CONST(0.1174011890366591),
    FRAC_CONST(0.1187260132530751),
    FRAC_CONST(0.1200596273415457),
    FRAC_CONST(0.1214020315908810),
    FRAC_CONST(0.1227532257568719),
    FRAC_CONST(0.1241132090604651),
    FRAC_CONST(0.1254819801859856),
    FRAC_CONST(0.1268595372794049),
    FRAC_CONST(0.1282458779466558),
    FRAC_CONST(0.1296409992519942),
    FRAC_CONST(0.1310448977164081),
    FRAC_CONST(0.1324575693160745),
    FRAC_CONST(0.1338790094808633),
    FRAC_CONST(0.1353092130928902),
    FRAC_CONST(0.1367481744851168),
    FRAC_CONST(0.1381958874400010),
    FRAC_CONST(0.1396523451881945),
    FRAC_CONST(0.1411175404072910),
    FRAC_CONST(0.1425914652206223),
    FRAC_CONST(0.1440741111961058),
    FRAC_CONST(0.1455654693451402),
    FRAC_CONST(0.1470655301215526),
    FRAC_CONST(0.1485742834205956),
    FRAC_CONST(0.1500917185779945),
    FRAC_CONST(0.1516178243690463),
    FRAC_CONST(0.1531525890077689),
    FRAC_CONST(0.1546960001461024),
    FRAC_CONST(0.1562480448731608),
    FRAC_CONST(0.1578087097145364),
    FRAC_CONST(0.1593779806316558),
    FRAC_CONST(0.1609558430211876),
    FRAC_CONST(0.1625422817145027),
    FRAC_CONST(0.1641372809771871),
    FRAC_CONST(0.1657408245086070),
    FRAC_CONST(0.1673528954415270),
    FRAC_CONST(0.1689734763417811),
    FRAC_CONST(0.1706025492079969),
    FRAC_CONST(0.1722400954713725),
    FRAC_CONST(0.1738860959955082),
    FRAC_CONST(0.1755405310762898),
    FRAC_CONST(0.1772033804418275),
    FRAC_CONST(0.1788746232524467),
    FRAC_CONST(0.1805542381007349),
    FRAC_CONST(0.1822422030116404),
    FRAC_CONST(0.1839384954426268),
    FRAC_CONST(0.1856430922838810),
    FRAC_CONST(0.1873559698585756),
    FRAC_CONST(0.1890771039231862),
    FRAC_CONST(0.1908064696678625),
    FRAC_CONST(0.1925440417168546),
    FRAC_CONST(0.1942897941289937),
    FRAC_CONST(0.1960437003982277),
    FRAC_CONST(0.1978057334542116),
    FRAC_CONST(0.1995758656629525),
    FRAC_CONST(0.2013540688275098),
    FRAC_CONST(0.2031403141887507),
    FRAC_CONST(0.2049345724261595),
    FRAC_CONST(0.2067368136587033),
    FRAC_CONST(0.2085470074457521),
    FRAC_CONST(0.2103651227880538),
    FRAC_CONST(0.2121911281287646),
    FRAC_CONST(0.2140249913545346),
    FRAC_CONST(0.2158666797966480),
    FRAC_CONST(0.2177161602322188),
    FRAC_CONST(0.2195733988854414),
    FRAC_CONST(0.2214383614288963),
    FRAC_CONST(0.2233110129849106),
    FRAC_CONST(0.2251913181269740),
    FRAC_CONST(0.2270792408812093),
    FRAC_CONST(0.2289747447278976),
    FRAC_CONST(0.2308777926030592),
    FRAC_CONST(0.2327883469000885),
    FRAC_CONST(0.2347063694714437),
    FRAC_CONST(0.2366318216303919),
    FRAC_CONST(0.2385646641528076),
    FRAC_CONST(0.2405048572790267),
    FRAC_CONST(0.2424523607157545),
    FRAC_CONST(0.2444071336380283),
    FRAC_CONST(0.2463691346912334),
    FRAC_CONST(0.2483383219931741),
    FRAC_CONST(0.2503146531361985),
    FRAC_CONST(0.2522980851893767),
    FRAC_CONST(0.2542885747007335),
    FRAC_CONST(0.2562860776995335),
    FRAC_CONST(0.2582905496986215),
    FRAC_CONST(0.2603019456968142),
    FRAC_CONST(0.2623202201813464),
    FRAC_CONST(0.2643453271303700),
    FRAC_CONST(0.2663772200155053),
    FRAC_CONST(0.2684158518044454),
    FRAC_CONST(0.2704611749636135),
    FRAC_CONST(0.2725131414608710),
    FRAC_CONST(0.2745717027682799),
    FRAC_CONST(0.2766368098649151),
    FRAC_CONST(0.2787084132397296),
    FRAC_CONST(0.2807864628944707),
    FRAC_CONST(0.2828709083466482),
    FRAC_CONST(0.2849616986325523),
    FRAC_CONST(0.2870587823103237),
    FRAC_CONST(0.2891621074630737),
    FRAC_CONST(0.2912716217020546),
    FRAC_CONST(0.2933872721698803),
    FRAC_CONST(0.2955090055437973),
    FRAC_CONST(0.2976367680390041),
    FRAC_CONST(0.2997705054120213),
    FRAC_CONST(0.3019101629641097),
    FRAC_CONST(0.3040556855447379),
    FRAC_CONST(0.3062070175550981),
    FRAC_CONST(0.3083641029516701),
    FRAC_CONST(0.3105268852498334),
    FRAC_CONST(0.3126953075275265),
    FRAC_CONST(0.3148693124289546),
    FRAC_CONST(0.3170488421683428),
    FRAC_CONST(0.3192338385337370),
    FRAC_CONST(0.3214242428908514),
    FRAC_CONST(0.3236199961869606),
    FRAC_CONST(0.3258210389548392),
    FRAC_CONST(0.3280273113167459),
    FRAC_CONST(0.3302387529884521),
    FRAC_CONST(0.3324553032833160),
    FRAC_CONST(0.3346769011164010),
    FRAC_CONST(0.3369034850086373),
    FRAC_CONST(0.3391349930910280),
    FRAC_CONST(0.3413713631088974),
    FRAC_CONST(0.3436125324261830),
    FRAC_CONST(0.3458584380297697),
    FRAC_CONST(0.3481090165338656),
    FRAC_CONST(0.3503642041844199),
    FRAC_CONST(0.3526239368635820),
    FRAC_CONST(0.3548881500942010),
    FRAC_CONST(0.3571567790443668),
    FRAC_CONST(0.3594297585319891),
    FRAC_CONST(0.3617070230294185),
    FRAC_CONST(0.3639885066681048),
    FRAC_CONST(0.3662741432432950),
    FRAC_CONST(0.3685638662187693),
    FRAC_CONST(0.3708576087316147),
    FRAC_CONST(0.3731553035970366),
    FRAC_CONST(0.3754568833132069),
    FRAC_CONST(0.3777622800661488),
    FRAC_CONST(0.3800714257346570),
    FRAC_CONST(0.3823842518952546),
    FRAC_CONST(0.3847006898271841),
    FRAC_CONST(0.3870206705174334),
    FRAC_CONST(0.3893441246657958),
    FRAC_CONST(0.3916709826899639),
    FRAC_CONST(0.3940011747306560),
    FRAC_CONST(0.3963346306567764),
    FRAC_CONST(0.3986712800706062),
    FRAC_CONST(0.4010110523130271),
    FRAC_CONST(0.4033538764687756),
    FRAC_CONST(0.4056996813717284),
    FRAC_CONST(0.4080483956102172),
    FRAC_CONST(0.4103999475323736),
    FRAC_CONST(0.4127542652515031),
    FRAC_CONST(0.4151112766514873),
    FRAC_CONST(0.4174709093922143),
    FRAC_CONST(0.4198330909150365),
    FRAC_CONST(0.4221977484482556),
    FRAC_CONST(0.4245648090126334),
    FRAC_CONST(0.4269341994269293),
    FRAC_CONST(0.4293058463134616),
    FRAC_CONST(0.4316796761036958),
    FRAC_CONST(0.4340556150438547),
    FRAC_CONST(0.4364335892005536),
    FRAC_CONST(0.4388135244664580),
    FRAC_CONST(0.4411953465659639),
    FRAC_CONST(0.4435789810609000),
    FRAC_CONST(0.4459643533562509),
    FRAC_CONST(0.4483513887059016),
    FRAC_CONST(0.4507400122184019),
    FRAC_CONST(0.4531301488627497),
    FRAC_CONST(0.4555217234741947),
    FRAC_CONST(0.4579146607600593),
    FRAC_CONST(0.4603088853055777),
    FRAC_CONST(0.4627043215797521),
    FRAC_CONST(0.4651008939412254),
    FRAC_CONST(0.4674985266441709),
    FRAC_CONST(0.4698971438441951),
    FRAC_CONST(0.4722966696042580),
    FRAC_CONST(0.4746970279006055),
    FRAC_CONST(0.4770981426287164),
    FRAC_CONST(0.4794999376092619),
    FRAC_CONST(0.4819023365940778),
    FRAC_CONST(0.4843052632721476),
    FRAC_CONST(0.4867086412755978),
    FRAC_CONST(0.4891123941857028),
    FRAC_CONST(0.4915164455388997),
    FRAC_CONST(0.4939207188328126),
    FRAC_CONST(0.4963251375322855),
    FRAC_CONST(0.4987296250754225),
    FRAC_CONST(0.5011341048796359),
    FRAC_CONST(0.5035385003477012),
    FRAC_CONST(0.5059427348738168),
    FRAC_CONST(0.5083467318496706),
    FRAC_CONST(0.5107504146705106),
    FRAC_CONST(0.5131537067412193),
    FRAC_CONST(0.5155565314823923),
    FRAC_CONST(0.5179588123364193),
    FRAC_CONST(0.5203604727735667),
    FRAC_CONST(0.5227614362980630),
    FRAC_CONST(0.5251616264541841),
    FRAC_CONST(0.5275609668323384),
    FRAC_CONST(0.5299593810751532),
    FRAC_CONST(0.5323567928835578),
    FRAC_CONST(0.5347531260228663),
    FRAC_CONST(0.5371483043288580),
    FRAC_CONST(0.5395422517138538),
    FRAC_CONST(0.5419348921727899),
    FRAC_CONST(0.5443261497892862),
    FRAC_CONST(0.5467159487417104),
    FRAC_CONST(0.5491042133092364),
    FRAC_CONST(0.5514908678778958),
    FRAC_CONST(0.5538758369466227),
    FRAC_CONST(0.5562590451332913),
    FRAC_CONST(0.5586404171807443),
    FRAC_CONST(0.5610198779628133),
    FRAC_CONST(0.5633973524903286),
    FRAC_CONST(0.5657727659171199),
    FRAC_CONST(0.5681460435460047),
    FRAC_CONST(0.5705171108347663),
    FRAC_CONST(0.5728858934021188),
    FRAC_CONST(0.5752523170336598),
    FRAC_CONST(0.5776163076878088),
    FRAC_CONST(0.5799777915017323),
    FRAC_CONST(0.5823366947972535),
    FRAC_CONST(0.5846929440867458),
    FRAC_CONST(0.5870464660790119),
    FRAC_CONST(0.5893971876851449),
    FRAC_CONST(0.5917450360243719),
    FRAC_CONST(0.5940899384298793),
    FRAC_CONST(0.5964318224546208),
    FRAC_CONST(0.5987706158771039),
    FRAC_CONST(0.6011062467071583),
    FRAC_CONST(0.6034386431916822),
    FRAC_CONST(0.6057677338203681),
    FRAC_CONST(0.6080934473314057),
    FRAC_CONST(0.6104157127171639),
    FRAC_CONST(0.6127344592298474),
    FRAC_CONST(0.6150496163871310),
    FRAC_CONST(0.6173611139777690),
    FRAC_CONST(0.6196688820671789),
    FRAC_CONST(0.6219728510029997),
    FRAC_CONST(0.6242729514206247),
    FRAC_CONST(0.6265691142487051),
    FRAC_CONST(0.6288612707146283),
    FRAC_CONST(0.6311493523499663),
    FRAC_CONST(0.6334332909958958),
    FRAC_CONST(0.6357130188085891),
    FRAC_CONST(0.6379884682645743),
    FRAC_CONST(0.6402595721660647),
    FRAC_CONST(0.6425262636462578),
    FRAC_CONST(0.6447884761746012),
    FRAC_CONST(0.6470461435620266),
    FRAC_CONST(0.6492991999661505),
    FRAC_CONST(0.6515475798964411),
    FRAC_CONST(0.6537912182193508),
    FRAC_CONST(0.6560300501634142),
    FRAC_CONST(0.6582640113243098),
    FRAC_CONST(0.6604930376698862),
    FRAC_CONST(0.6627170655451516),
    FRAC_CONST(0.6649360316772256),
    FRAC_CONST(0.6671498731802533),
    FRAC_CONST(0.6693585275602818),
    FRAC_CONST(0.6715619327200959),
    FRAC_CONST(0.6737600269640164),
    FRAC_CONST(0.6759527490026566),
    FRAC_CONST(0.6781400379576392),
    FRAC_CONST(0.6803218333662715),
    FRAC_CONST(0.6824980751861787),
    FRAC_CONST(0.6846687037998949),
    FRAC_CONST(0.6868336600194123),
    FRAC_CONST(0.6889928850906855),
    FRAC_CONST(0.6911463206980928),
    FRAC_CONST(0.6932939089688525),
    FRAC_CONST(0.6954355924773949),
    FRAC_CONST(0.6975713142496884),
    FRAC_CONST(0.6997010177675195),
    FRAC_CONST(0.7018246469727265),
    FRAC_CONST(0.7039421462713862),
    FRAC_CONST(0.7060534605379528),
    FRAC_CONST(0.7081585351193496),
    FRAC_CONST(0.7102573158390105),
    FRAC_CONST(0.7123497490008750),
    FRAC_CONST(0.7144357813933307),
    FRAC_CONST(0.7165153602931092),
    FRAC_CONST(0.7185884334691287),
    FRAC_CONST(0.7206549491862871),
    FRAC_CONST(0.7227148562092042),
    FRAC_CONST(0.7247681038059106),
    FRAC_CONST(0.7268146417514855),
    FRAC_CONST(0.7288544203316418),
    FRAC_CONST(0.7308873903462577),
    FRAC_CONST(0.7329135031128549),
    FRAC_CONST(0.7349327104700221),
    FRAC_CONST(0.7369449647807855),
    FRAC_CONST(0.7389502189359237),
    FRAC_CONST(0.7409484263572271),
    FRAC_CONST(0.7429395410007016),
    FRAC_CONST(0.7449235173597176),
    FRAC_CONST(0.7469003104681008),
    FRAC_CONST(0.7488698759031670),
    FRAC_CONST(0.7508321697887005),
    FRAC_CONST(0.7527871487978728),
    FRAC_CONST(0.7547347701561059),
    FRAC_CONST(0.7566749916438754),
    FRAC_CONST(0.7586077715994560),
    FRAC_CONST(0.7605330689216074),
    FRAC_CONST(0.7624508430722016),
    FRAC_CONST(0.7643610540787891),
    FRAC_CONST(0.7662636625371070),
    FRAC_CONST(0.7681586296135255),
    FRAC_CONST(0.7700459170474343),
    FRAC_CONST(0.7719254871535672),
    FRAC_CONST(0.7737973028242671),
    FRAC_CONST(0.7756613275316875),
    FRAC_CONST(0.7775175253299340),
    FRAC_CONST(0.7793658608571425),
    FRAC_CONST(0.7812062993374951),
    FRAC_CONST(0.7830388065831744),
    FRAC_CONST(0.7848633489962533),
    FRAC_CONST(0.7866798935705233),
    FRAC_CONST(0.7884884078932579),
    FRAC_CONST(0.7902888601469138),
    FRAC_CONST(0.7920812191107668),
    FRAC_CONST(0.7938654541624850),
    FRAC_CONST(0.7956415352796368),
    FRAC_CONST(0.7974094330411343),
    FRAC_CONST(0.7991691186286133),
    FRAC_CONST(0.8009205638277465),
    FRAC_CONST(0.8026637410294932),
    FRAC_CONST(0.8043986232312831),
    FRAC_CONST(0.8061251840381346),
    FRAC_CONST(0.8078433976637077),
    FRAC_CONST(0.8095532389312917),
    FRAC_CONST(0.8112546832747255),
    FRAC_CONST(0.8129477067392539),
    FRAC_CONST(0.8146322859823164),
    FRAC_CONST(0.8163083982742698),
    FRAC_CONST(0.8179760214990457),
    FRAC_CONST(0.8196351341547393),
    FRAC_CONST(0.8212857153541345),
    FRAC_CONST(0.8229277448251595),
    FRAC_CONST(0.8245612029112778),
    FRAC_CONST(0.8261860705718113),
    FRAC_CONST(0.8278023293821971),
    FRAC_CONST(0.8294099615341773),
    FRAC_CONST(0.8310089498359212),
    FRAC_CONST(0.8325992777120815),
    FRAC_CONST(0.8341809292037831),
    FRAC_CONST(0.8357538889685445),
    FRAC_CONST(0.8373181422801330),
    FRAC_CONST(0.8388736750283521),
    FRAC_CONST(0.8404204737187619),
    FRAC_CONST(0.8419585254723335),
    FRAC_CONST(0.8434878180250348),
    FRAC_CONST(0.8450083397273509),
    FRAC_CONST(0.8465200795437368),
    FRAC_CONST(0.8480230270520029),
    FRAC_CONST(0.8495171724426350),
    FRAC_CONST(0.8510025065180464),
    FRAC_CONST(0.8524790206917633),
    FRAC_CONST(0.8539467069875448),
    FRAC_CONST(0.8554055580384357),
    FRAC_CONST(0.8568555670857525),
    FRAC_CONST(0.8582967279780043),
    FRAC_CONST(0.8597290351697464),
    FRAC_CONST(0.8611524837203691),
    FRAC_CONST(0.8625670692928198),
    FRAC_CONST(0.8639727881522599),
    FRAC_CONST(0.8653696371646555),
    FRAC_CONST(0.8667576137953045),
    FRAC_CONST(0.8681367161072958),
    FRAC_CONST(0.8695069427599065),
    FRAC_CONST(0.8708682930069319),
    FRAC_CONST(0.8722207666949527),
    FRAC_CONST(0.8735643642615368),
    FRAC_CONST(0.8748990867333771),
    FRAC_CONST(0.8762249357243662),
    FRAC_CONST(0.8775419134336067),
    FRAC_CONST(0.8788500226433579),
    FRAC_CONST(0.8801492667169208),
    FRAC_CONST(0.8814396495964587),
    FRAC_CONST(0.8827211758007560),
    FRAC_CONST(0.8839938504229149),
    FRAC_CONST(0.8852576791279895),
    FRAC_CONST(0.8865126681505587),
    FRAC_CONST(0.8877588242922386),
    FRAC_CONST(0.8889961549191320),
    FRAC_CONST(0.8902246679592184),
    FRAC_CONST(0.8914443718996848),
    FRAC_CONST(0.8926552757841945),
    FRAC_CONST(0.8938573892100969),
    FRAC_CONST(0.8950507223255798),
    FRAC_CONST(0.8962352858267605),
    FRAC_CONST(0.8974110909547198),
    FRAC_CONST(0.8985781494924783),
    FRAC_CONST(0.8997364737619142),
    FRAC_CONST(0.9008860766206249),
    FRAC_CONST(0.9020269714587307),
    FRAC_CONST(0.9031591721956235),
    FRAC_CONST(0.9042826932766591),
    FRAC_CONST(0.9053975496697941),
    FRAC_CONST(0.9065037568621681),
    FRAC_CONST(0.9076013308566311),
    FRAC_CONST(0.9086902881682180),
    FRAC_CONST(0.9097706458205682),
    FRAC_CONST(0.9108424213422940),
    FRAC_CONST(0.9119056327632955),
    FRAC_CONST(0.9129602986110235),
    FRAC_CONST(0.9140064379066919),
    FRAC_CONST(0.9150440701614393),
    FRAC_CONST(0.9160732153724396),
    FRAC_CONST(0.9170938940189634),
    FRAC_CONST(0.9181061270583908),
    FRAC_CONST(0.9191099359221748),
    FRAC_CONST(0.9201053425117579),
    FRAC_CONST(0.9210923691944400),
    FRAC_CONST(0.9220710387992010),
    FRAC_CONST(0.9230413746124764),
    FRAC_CONST(0.9240034003738882),
    FRAC_CONST(0.9249571402719298),
    FRAC_CONST(0.9259026189396085),
    FRAC_CONST(0.9268398614500427),
    FRAC_CONST(0.9277688933120170),
    FRAC_CONST(0.9286897404654957),
    FRAC_CONST(0.9296024292770939),
    FRAC_CONST(0.9305069865355076),
    FRAC_CONST(0.9314034394469048),
    FRAC_CONST(0.9322918156302762),
    FRAC_CONST(0.9331721431127471),
    FRAC_CONST(0.9340444503248519),
    FRAC_CONST(0.9349087660957711),
    FRAC_CONST(0.9357651196485313),
    FRAC_CONST(0.9366135405951697),
    FRAC_CONST(0.9374540589318637),
    FRAC_CONST(0.9382867050340261),
    FRAC_CONST(0.9391115096513655),
    FRAC_CONST(0.9399285039029165),
    FRAC_CONST(0.9407377192720349),
    FRAC_CONST(0.9415391876013639),
    FRAC_CONST(0.9423329410877687),
    FRAC_CONST(0.9431190122772415),
    FRAC_CONST(0.9438974340597782),
    FRAC_CONST(0.9446682396642262),
    FRAC_CONST(0.9454314626531054),
    FRAC_CONST(0.9461871369174033),
    FRAC_CONST(0.9469352966713429),
    FRAC_CONST(0.9476759764471278),
    FRAC_CONST(0.9484092110896616),
    FRAC_CONST(0.9491350357512457),
    FRAC_CONST(0.9498534858862532),
    FRAC_CONST(0.9505645972457831),
    FRAC_CONST(0.9512684058722927),
    FRAC_CONST(0.9519649480942105),
    FRAC_CONST(0.9526542605205314),
    FRAC_CONST(0.9533363800353921),
    FRAC_CONST(0.9540113437926313),
    FRAC_CONST(0.9546791892103320),
    FRAC_CONST(0.9553399539653500),
    FRAC_CONST(0.9559936759878265),
    FRAC_CONST(0.9566403934556893),
    FRAC_CONST(0.9572801447891388),
    FRAC_CONST(0.9579129686451244),
    FRAC_CONST(0.9585389039118085),
    FRAC_CONST(0.9591579897030224),
    FRAC_CONST(0.9597702653527108),
    FRAC_CONST(0.9603757704093711),
    FRAC_CONST(0.9609745446304828),
    FRAC_CONST(0.9615666279769324),
    FRAC_CONST(0.9621520606074324),
    FRAC_CONST(0.9627308828729358),
    FRAC_CONST(0.9633031353110477),
    FRAC_CONST(0.9638688586404335),
    FRAC_CONST(0.9644280937552258),
    FRAC_CONST(0.9649808817194311),
    FRAC_CONST(0.9655272637613366),
    FRAC_CONST(0.9660672812679171),
    FRAC_CONST(0.9666009757792454),
    FRAC_CONST(0.9671283889829055),
    FRAC_CONST(0.9676495627084089),
    FRAC_CONST(0.9681645389216160),
    FRAC_CONST(0.9686733597191652),
    FRAC_CONST(0.9691760673229058),
    FRAC_CONST(0.9696727040743406),
    FRAC_CONST(0.9701633124290767),
    FRAC_CONST(0.9706479349512860),
    FRAC_CONST(0.9711266143081750),
    FRAC_CONST(0.9715993932644684),
    FRAC_CONST(0.9720663146769026),
    FRAC_CONST(0.9725274214887337),
    FRAC_CONST(0.9729827567242596),
    FRAC_CONST(0.9734323634833574),
    FRAC_CONST(0.9738762849360358),
    FRAC_CONST(0.9743145643170059),
    FRAC_CONST(0.9747472449202687),
    FRAC_CONST(0.9751743700937215),
    FRAC_CONST(0.9755959832337850),
    FRAC_CONST(0.9760121277800496),
    FRAC_CONST(0.9764228472099433),
    FRAC_CONST(0.9768281850334235),
    FRAC_CONST(0.9772281847876897),
    FRAC_CONST(0.9776228900319223),
    FRAC_CONST(0.9780123443420448),
    FRAC_CONST(0.9783965913055132),
    FRAC_CONST(0.9787756745161313),
    FRAC_CONST(0.9791496375688939),
    FRAC_CONST(0.9795185240548578),
    FRAC_CONST(0.9798823775560431),
    FRAC_CONST(0.9802412416403639),
    FRAC_CONST(0.9805951598565897),
    FRAC_CONST(0.9809441757293399),
    FRAC_CONST(0.9812883327541090),
    FRAC_CONST(0.9816276743923267),
    FRAC_CONST(0.9819622440664515),
    FRAC_CONST(0.9822920851550995),
    FRAC_CONST(0.9826172409882086),
    FRAC_CONST(0.9829377548422400),
    FRAC_CONST(0.9832536699354163),
    FRAC_CONST(0.9835650294229984),
    FRAC_CONST(0.9838718763926001),
    FRAC_CONST(0.9841742538595437),
    FRAC_CONST(0.9844722047622547),
    FRAC_CONST(0.9847657719576983),
    FRAC_CONST(0.9850549982168574),
    FRAC_CONST(0.9853399262202529),
    FRAC_CONST(0.9856205985535073),
    FRAC_CONST(0.9858970577029519),
    FRAC_CONST(0.9861693460512790),
    FRAC_CONST(0.9864375058732389),
    FRAC_CONST(0.9867015793313820),
    FRAC_CONST(0.9869616084718489),
    FRAC_CONST(0.9872176352202061),
    FRAC_CONST(0.9874697013773301),
    FRAC_CONST(0.9877178486153397),
    FRAC_CONST(0.9879621184735767),
    FRAC_CONST(0.9882025523546365),
    FRAC_CONST(0.9884391915204485),
    FRAC_CONST(0.9886720770884069),
    FRAC_CONST(0.9889012500275530),
    FRAC_CONST(0.9891267511548089),
    FRAC_CONST(0.9893486211312621),
    FRAC_CONST(0.9895669004585049),
    FRAC_CONST(0.9897816294750255),
    FRAC_CONST(0.9899928483526520),
    FRAC_CONST(0.9902005970930525),
    FRAC_CONST(0.9904049155242876),
    FRAC_CONST(0.9906058432974180),
    FRAC_CONST(0.9908034198831690),
    FRAC_CONST(0.9909976845686489),
    FRAC_CONST(0.9911886764541239),
    FRAC_CONST(0.9913764344498495),
    FRAC_CONST(0.9915609972729590),
    FRAC_CONST(0.9917424034444086),
    FRAC_CONST(0.9919206912859797),
    FRAC_CONST(0.9920958989173397),
    FRAC_CONST(0.9922680642531603),
    FRAC_CONST(0.9924372250002933),
    FRAC_CONST(0.9926034186550070),
    FRAC_CONST(0.9927666825002789),
    FRAC_CONST(0.9929270536031491),
    FRAC_CONST(0.9930845688121325),
    FRAC_CONST(0.9932392647546895),
    FRAC_CONST(0.9933911778347579),
    FRAC_CONST(0.9935403442303433),
    FRAC_CONST(0.9936867998911693),
    FRAC_CONST(0.9938305805363887),
    FRAC_CONST(0.9939717216523539),
    FRAC_CONST(0.9941102584904481),
    FRAC_CONST(0.9942462260649764),
    FRAC_CONST(0.9943796591511174),
    FRAC_CONST(0.9945105922829353),
    FRAC_CONST(0.9946390597514524),
    FRAC_CONST(0.9947650956027824),
    FRAC_CONST(0.9948887336363228),
    FRAC_CONST(0.9950100074030103),
    FRAC_CONST(0.9951289502036336),
    FRAC_CONST(0.9952455950872091),
    FRAC_CONST(0.9953599748494155),
    FRAC_CONST(0.9954721220310890),
    FRAC_CONST(0.9955820689167787),
    FRAC_CONST(0.9956898475333619),
    FRAC_CONST(0.9957954896487196),
    FRAC_CONST(0.9958990267704713),
    FRAC_CONST(0.9960004901447701),
    FRAC_CONST(0.9960999107551559),
    FRAC_CONST(0.9961973193214694),
    FRAC_CONST(0.9962927462988245),
    FRAC_CONST(0.9963862218766388),
    FRAC_CONST(0.9964777759777242),
    FRAC_CONST(0.9965674382574342),
    FRAC_CONST(0.9966552381028704),
    FRAC_CONST(0.9967412046321465),
    FRAC_CONST(0.9968253666937095),
    FRAC_CONST(0.9969077528657186),
    FRAC_CONST(0.9969883914554805),
    FRAC_CONST(0.9970673104989413),
    FRAC_CONST(0.9971445377602348),
    FRAC_CONST(0.9972201007312871),
    FRAC_CONST(0.9972940266314749),
    FRAC_CONST(0.9973663424073412),
    FRAC_CONST(0.9974370747323638),
    FRAC_CONST(0.9975062500067785),
    FRAC_CONST(0.9975738943574574),
    FRAC_CONST(0.9976400336378379),
    FRAC_CONST(0.9977046934279079),
    FRAC_CONST(0.9977678990342401),
    FRAC_CONST(0.9978296754900812),
    FRAC_CONST(0.9978900475554902),
    FRAC_CONST(0.9979490397175296),
    FRAC_CONST(0.9980066761905056),
    FRAC_CONST(0.9980629809162593),
    FRAC_CONST(0.9981179775645063),
    FRAC_CONST(0.9981716895332257),
    FRAC_CONST(0.9982241399490979),
    FRAC_CONST(0.9982753516679893),
    FRAC_CONST(0.9983253472754841),
    FRAC_CONST(0.9983741490874634),
    FRAC_CONST(0.9984217791507299),
    FRAC_CONST(0.9984682592436778),
    FRAC_CONST(0.9985136108770075),
    FRAC_CONST(0.9985578552944850),
    FRAC_CONST(0.9986010134737439),
    FRAC_CONST(0.9986431061271304),
    FRAC_CONST(0.9986841537025921),
    FRAC_CONST(0.9987241763846056),
    FRAC_CONST(0.9987631940951476),
    FRAC_CONST(0.9988012264947044),
    FRAC_CONST(0.9988382929833222),
    FRAC_CONST(0.9988744127016956),
    FRAC_CONST(0.9989096045322947),
    FRAC_CONST(0.9989438871005292),
    FRAC_CONST(0.9989772787759494),
    FRAC_CONST(0.9990097976734847),
    FRAC_CONST(0.9990414616547146),
    FRAC_CONST(0.9990722883291779),
    FRAC_CONST(0.9991022950557125),
    FRAC_CONST(0.9991314989438310),
    FRAC_CONST(0.9991599168551279),
    FRAC_CONST(0.9991875654047181),
    FRAC_CONST(0.9992144609627068),
    FRAC_CONST(0.9992406196556911),
    FRAC_CONST(0.9992660573682882),
    FRAC_CONST(0.9992907897446957),
    FRAC_CONST(0.9993148321902777),
    FRAC_CONST(0.9993381998731797),
    FRAC_CONST(0.9993609077259696),
    FRAC_CONST(0.9993829704473038),
    FRAC_CONST(0.9994044025036201),
    FRAC_CONST(0.9994252181308537),
    FRAC_CONST(0.9994454313361775),
    FRAC_CONST(0.9994650558997651),
    FRAC_CONST(0.9994841053765757),
    FRAC_CONST(0.9995025930981609),
    FRAC_CONST(0.9995205321744921),
    FRAC_CONST(0.9995379354958073),
    FRAC_CONST(0.9995548157344778),
    FRAC_CONST(0.9995711853468930),
    FRAC_CONST(0.9995870565753632),
    FRAC_CONST(0.9996024414500382),
    FRAC_CONST(0.9996173517908444),
    FRAC_CONST(0.9996317992094352),
    FRAC_CONST(0.9996457951111574),
    FRAC_CONST(0.9996593506970310),
    FRAC_CONST(0.9996724769657434),
    FRAC_CONST(0.9996851847156547),
    FRAC_CONST(0.9996974845468164),
    FRAC_CONST(0.9997093868630000),
    FRAC_CONST(0.9997209018737374),
    FRAC_CONST(0.9997320395963699),
    FRAC_CONST(0.9997428098581069),
    FRAC_CONST(0.9997532222980933),
    FRAC_CONST(0.9997632863694836),
    FRAC_CONST(0.9997730113415246),
    FRAC_CONST(0.9997824063016426),
    FRAC_CONST(0.9997914801575380),
    FRAC_CONST(0.9998002416392840),
    FRAC_CONST(0.9998086993014300),
    FRAC_CONST(0.9998168615251084),
    FRAC_CONST(0.9998247365201450),
    FRAC_CONST(0.9998323323271717),
    FRAC_CONST(0.9998396568197407),
    FRAC_CONST(0.9998467177064404),
    FRAC_CONST(0.9998535225330116),
    FRAC_CONST(0.9998600786844637),
    FRAC_CONST(0.9998663933871905),
    FRAC_CONST(0.9998724737110845),
    FRAC_CONST(0.9998783265716498),
    FRAC_CONST(0.9998839587321121),
    FRAC_CONST(0.9998893768055266),
    FRAC_CONST(0.9998945872568815),
    FRAC_CONST(0.9998995964051983),
    FRAC_CONST(0.9999044104256269),
    FRAC_CONST(0.9999090353515359),
    FRAC_CONST(0.9999134770765971),
    FRAC_CONST(0.9999177413568642),
    FRAC_CONST(0.9999218338128448),
    FRAC_CONST(0.9999257599315647),
    FRAC_CONST(0.9999295250686255),
    FRAC_CONST(0.9999331344502529),
    FRAC_CONST(0.9999365931753376),
    FRAC_CONST(0.9999399062174669),
    FRAC_CONST(0.9999430784269460),
    FRAC_CONST(0.9999461145328103),
    FRAC_CONST(0.9999490191448277),
    FRAC_CONST(0.9999517967554878),
    FRAC_CONST(0.9999544517419835),
    FRAC_CONST(0.9999569883681778),
    FRAC_CONST(0.9999594107865607),
    FRAC_CONST(0.9999617230401926),
    FRAC_CONST(0.9999639290646355),
    FRAC_CONST(0.9999660326898712),
    FRAC_CONST(0.9999680376422052),
    FRAC_CONST(0.9999699475461585),
    FRAC_CONST(0.9999717659263435),
    FRAC_CONST(0.9999734962093266),
    FRAC_CONST(0.9999751417254756),
    FRAC_CONST(0.9999767057107922),
    FRAC_CONST(0.9999781913087290),
    FRAC_CONST(0.9999796015719915),
    FRAC_CONST(0.9999809394643231),
    FRAC_CONST(0.9999822078622751),
    FRAC_CONST(0.9999834095569596),
    FRAC_CONST(0.9999845472557860),
    FRAC_CONST(0.9999856235841805),
    FRAC_CONST(0.9999866410872889),
    FRAC_CONST(0.9999876022316609),
    FRAC_CONST(0.9999885094069193),
    FRAC_CONST(0.9999893649274085),
    FRAC_CONST(0.9999901710338274),
    FRAC_CONST(0.9999909298948430),
    FRAC_CONST(0.9999916436086862),
    FRAC_CONST(0.9999923142047299),
    FRAC_CONST(0.9999929436450469),
    FRAC_CONST(0.9999935338259505),
    FRAC_CONST(0.9999940865795161),
    FRAC_CONST(0.9999946036750835),
    FRAC_CONST(0.9999950868207405),
    FRAC_CONST(0.9999955376647868),
    FRAC_CONST(0.9999959577971798),
    FRAC_CONST(0.9999963487509599),
    FRAC_CONST(0.9999967120036571),
    FRAC_CONST(0.9999970489786785),
    FRAC_CONST(0.9999973610466748),
    FRAC_CONST(0.9999976495268890),
    FRAC_CONST(0.9999979156884846),
    FRAC_CONST(0.9999981607518545),
    FRAC_CONST(0.9999983858899099),
    FRAC_CONST(0.9999985922293493),
    FRAC_CONST(0.9999987808519092),
    FRAC_CONST(0.9999989527955938),
    FRAC_CONST(0.9999991090558848),
    FRAC_CONST(0.9999992505869332),
    FRAC_CONST(0.9999993783027293),
    FRAC_CONST(0.9999994930782556),
    FRAC_CONST(0.9999995957506171),
    FRAC_CONST(0.9999996871201549),
    FRAC_CONST(0.9999997679515386),
    FRAC_CONST(0.9999998389748399),
    FRAC_CONST(0.9999999008865869),
    FRAC_CONST(0.9999999543507984)
};
#endif

ALIGN static const real_t kbd_short_128[] =
{
    FRAC_CONST(4.3795702929468881e-005),
    FRAC_CONST(0.00011867384265436617),
    FRAC_CONST(0.0002307165763996192),
    FRAC_CONST(0.00038947282760568383),
    FRAC_CONST(0.00060581272288302553),
    FRAC_CONST(0.00089199695169487453),
    FRAC_CONST(0.0012617254423430522),
    FRAC_CONST(0.0017301724373162003),
    FRAC_CONST(0.0023140071937421476),
    FRAC_CONST(0.0030313989666022221),
    FRAC_CONST(0.0039020049735530842),
    FRAC_CONST(0.0049469401815512024),
    FRAC_CONST(0.0061887279335368318),
    FRAC_CONST(0.0076512306364647726),
    FRAC_CONST(0.0093595599562652423),
    FRAC_CONST(0.011339966208377799),
    FRAC_CONST(0.013619706891715299),
    FRAC_CONST(0.016226894586323766),
    FRAC_CONST(0.019190324717288168),
    FRAC_CONST(0.022539283975960878),
    FRAC_CONST(0.026303340480472455),
    FRAC_CONST(0.030512117046644357),
    FRAC_CONST(0.03519504922365594),
    FRAC_CONST(0.040381130021856941),
    FRAC_CONST(0.046098643518702249),
    FRAC_CONST(0.052374889768730587),
    FRAC_CONST(0.059235903660769147),
    FRAC_CONST(0.066706170556282418),
    FRAC_CONST(0.074808341703430481),
    FRAC_CONST(0.083562952548726227),
    FRAC_CONST(0.092988147159339674),
    FRAC_CONST(0.1030994120216919),
    FRAC_CONST(0.11390932249409955),
    FRAC_CONST(0.12542730516149531),
    FRAC_CONST(0.13765941926783826),
    FRAC_CONST(0.15060816028651081),
    FRAC_CONST(0.16427228853114245),
    FRAC_CONST(0.17864668550988483),
    FRAC_CONST(0.19372224048676889),
    FRAC_CONST(0.20948576943658073),
    FRAC_CONST(0.22591996826744942),
    FRAC_CONST(0.24300340184133981),
    FRAC_CONST(0.26071052995068139),
    FRAC_CONST(0.27901177101369551),
    FRAC_CONST(0.29787360383626599),
    FRAC_CONST(0.3172587073594233),
    FRAC_CONST(0.33712613787396362),
    FRAC_CONST(0.35743154274286698),
    FRAC_CONST(0.37812740923363009),
    FRAC_CONST(0.39916334663203618),
    FRAC_CONST(0.42048639939189658),
    FRAC_CONST(0.4420413886774246),
    FRAC_CONST(0.4637712792815169),
    FRAC_CONST(0.4856175685594023),
    FRAC_CONST(0.50752069370766872),
    FRAC_CONST(0.52942045344797806),
    FRAC_CONST(0.55125643994680196),
    FRAC_CONST(0.57296847662071559),
    FRAC_CONST(0.59449705734411495),
    FRAC_CONST(0.61578378249506627),
    FRAC_CONST(0.63677178724712891),
    FRAC_CONST(0.65740615754163356),
    FRAC_CONST(0.67763432925662526),
    FRAC_CONST(0.69740646622548552),
    FRAC_CONST(0.71667581294953808),
    FRAC_CONST(0.73539901809352737),
    FRAC_CONST(0.75353642514900732),
    FRAC_CONST(0.77105232699609816),
    FRAC_CONST(0.78791518148597028),
    FRAC_CONST(0.80409778560147072),
    FRAC_CONST(0.81957740622770781),
    FRAC_CONST(0.83433586607383625),
    FRAC_CONST(0.84835958382689225),
    FRAC_CONST(0.86163956818294229),
    FRAC_CONST(0.87417136598406997),
    FRAC_CONST(0.88595496528524853),
    FRAC_CONST(0.89699465477567619),
    FRAC_CONST(0.90729884157670959),
    FRAC_CONST(0.91687983002436779),
    FRAC_CONST(0.92575356460899649),
    FRAC_CONST(0.93393934077779084),
    FRAC_CONST(0.94145948779657318),
    FRAC_CONST(0.94833902830402828),
    FRAC_CONST(0.95460531956280026),
    FRAC_CONST(0.96028768170574896),
    FRAC_CONST(0.96541701848104766),
    FRAC_CONST(0.97002543610646474),
    FRAC_CONST(0.97414586584250062),
    FRAC_CONST(0.97781169577969584),
    FRAC_CONST(0.98105641710392333),
    FRAC_CONST(0.98391328975491177),
    FRAC_CONST(0.98641503193166202),
    FRAC_CONST(0.98859353733226141),
    FRAC_CONST(0.99047962335771556),
    FRAC_CONST(0.9921028127769449),
    FRAC_CONST(0.99349115056397752),
    FRAC_CONST(0.99467105680259038),
    FRAC_CONST(0.9956672157341897),
    FRAC_CONST(0.99650250022834352),
    FRAC_CONST(0.99719793020823266),
    FRAC_CONST(0.99777266288955657),
    FRAC_CONST(0.99824401211201486),
    FRAC_CONST(0.99862749357391212),
    FRAC_CONST(0.99893689243401962),
    FRAC_CONST(0.99918434952623147),
    FRAC_CONST(0.99938046234161726),
    FRAC_CONST(0.99953439696357238),
    FRAC_CONST(0.99965400728430465),
    FRAC_CONST(0.99974595807027455),
    FRAC_CONST(0.99981584876278362),
    FRAC_CONST(0.99986833527824281),
    FRAC_CONST(0.99990724749057802),
    FRAC_CONST(0.99993570051598468),
    FRAC_CONST(0.99995619835942084),
    FRAC_CONST(0.99997072890647543),
    FRAC_CONST(0.9999808496399144),
    FRAC_CONST(0.99998776381655818),
    FRAC_CONST(0.99999238714961569),
    FRAC_CONST(0.99999540529959718),
    FRAC_CONST(0.99999732268176988),
    FRAC_CONST(0.99999850325054862),
    FRAC_CONST(0.99999920402413744),
    FRAC_CONST(0.9999996021706401),
    FRAC_CONST(0.99999981649545566),
    FRAC_CONST(0.99999992415545547),
    FRAC_CONST(0.99999997338493041),
    FRAC_CONST(0.99999999295825959),
    FRAC_CONST(0.99999999904096815)
};

#ifdef ALLOW_SMALL_FRAMELENGTH
ALIGN static const real_t kbd_short_120[] =
{
    FRAC_CONST(0.0000452320086910),
    FRAC_CONST(0.0001274564692111),
    FRAC_CONST(0.0002529398385345),
    FRAC_CONST(0.0004335140496648),
    FRAC_CONST(0.0006827100966952),
    FRAC_CONST(0.0010158708222246),
    FRAC_CONST(0.0014502162869659),
    FRAC_CONST(0.0020048865156264),
    FRAC_CONST(0.0027009618393178),
    FRAC_CONST(0.0035614590925043),
    FRAC_CONST(0.0046113018122711),
    FRAC_CONST(0.0058772627936484),
    FRAC_CONST(0.0073878776584103),
    FRAC_CONST(0.0091733284512589),
    FRAC_CONST(0.0112652966728373),
    FRAC_CONST(0.0136967855861945),
    FRAC_CONST(0.0165019120857793),
    FRAC_CONST(0.0197156688892217),
    FRAC_CONST(0.0233736582950619),
    FRAC_CONST(0.0275117992367496),
    FRAC_CONST(0.0321660098468534),
    FRAC_CONST(0.0373718682174417),
    FRAC_CONST(0.0431642544948834),
    FRAC_CONST(0.0495769778717676),
    FRAC_CONST(0.0566423924273392),
    FRAC_CONST(0.0643910061132260),
    FRAC_CONST(0.0728510874761729),
    FRAC_CONST(0.0820482749475221),
    FRAC_CONST(0.0920051937045235),
    FRAC_CONST(0.1027410852163450),
    FRAC_CONST(0.1142714546239370),
    FRAC_CONST(0.1266077410648368),
    FRAC_CONST(0.1397570159398145),
    FRAC_CONST(0.1537217139274270),
    FRAC_CONST(0.1684994012857075),
    FRAC_CONST(0.1840825856392944),
    FRAC_CONST(0.2004585710384133),
    FRAC_CONST(0.2176093615976121),
    FRAC_CONST(0.2355116164824983),
    FRAC_CONST(0.2541366584185075),
    FRAC_CONST(0.2734505372545160),
    FRAC_CONST(0.2934141494343369),
    FRAC_CONST(0.3139834135200387),
    FRAC_CONST(0.3351095011824163),
    FRAC_CONST(0.3567391223361566),
    FRAC_CONST(0.3788148623608774),
    FRAC_CONST(0.4012755686250732),
    FRAC_CONST(0.4240567828288110),
    FRAC_CONST(0.4470912150133537),
    FRAC_CONST(0.4703092544619664),
    FRAC_CONST(0.4936395121456694),
    FRAC_CONST(0.5170093888596962),
    FRAC_CONST(0.5403456627591340),
    FRAC_CONST(0.5635750896430154),
    FRAC_CONST(0.5866250090612892),
    FRAC_CONST(0.6094239491338723),
    FRAC_CONST(0.6319022228794100),
    FRAC_CONST(0.6539925088563087),
    FRAC_CONST(0.6756304090216887),
    FRAC_CONST(0.6967549769155277),
    FRAC_CONST(0.7173092095766250),
    FRAC_CONST(0.7372404969921184),
    FRAC_CONST(0.7565010233699827),
    FRAC_CONST(0.7750481150999984),
    FRAC_CONST(0.7928445309277697),
    FRAC_CONST(0.8098586906021583),
    FRAC_CONST(0.8260648390616000),
    FRAC_CONST(0.8414431440907889),
    FRAC_CONST(0.8559797262966709),
    FRAC_CONST(0.8696666212110165),
    FRAC_CONST(0.8825016743142358),
    FRAC_CONST(0.8944883707784486),
    FRAC_CONST(0.9056356027326216),
    FRAC_CONST(0.9159573778427816),
    FRAC_CONST(0.9254724739583072),
    FRAC_CONST(0.9342040454819434),
    FRAC_CONST(0.9421791879559176),
    FRAC_CONST(0.9494284680976784),
    FRAC_CONST(0.9559854271440150),
    FRAC_CONST(0.9618860658493898),
    FRAC_CONST(0.9671683198119525),
    FRAC_CONST(0.9718715339497299),
    FRAC_CONST(0.9760359449042233),
    FRAC_CONST(0.9797021798981759),
    FRAC_CONST(0.9829107801140203),
    FRAC_CONST(0.9857017559923277),
    FRAC_CONST(0.9881141809867999),
    FRAC_CONST(0.9901858292742826),
    FRAC_CONST(0.9919528617340944),
    FRAC_CONST(0.9934495632180476),
    FRAC_CONST(0.9947081327749199),
    FRAC_CONST(0.9957585271195989),
    FRAC_CONST(0.9966283562984427),
    FRAC_CONST(0.9973428292485683),
    FRAC_CONST(0.9979247458259197),
    FRAC_CONST(0.9983945309245774),
    FRAC_CONST(0.9987703055583410),
    FRAC_CONST(0.9990679892449266),
    FRAC_CONST(0.9993014277313617),
    FRAC_CONST(0.9994825400228521),
    FRAC_CONST(0.9996214788122335),
    FRAC_CONST(0.9997267987294857),
    FRAC_CONST(0.9998056273097539),
    FRAC_CONST(0.9998638341781910),
    FRAC_CONST(0.9999061946325793),
    FRAC_CONST(0.9999365445321382),
    FRAC_CONST(0.9999579241373735),
    FRAC_CONST(0.9999727092594598),
    FRAC_CONST(0.9999827287418790),
    FRAC_CONST(0.9999893678912771),
    FRAC_CONST(0.9999936579844555),
    FRAC_CONST(0.9999963523959187),
    FRAC_CONST(0.9999979902130101),
    FRAC_CONST(0.9999989484358076),
    FRAC_CONST(0.9999994840031031),
    FRAC_CONST(0.9999997669534347),
    FRAC_CONST(0.9999999060327799),
    FRAC_CONST(0.9999999680107184),
    FRAC_CONST(0.9999999918774242),
    FRAC_CONST(0.9999999989770326)
};
#endif

#ifdef __cplusplus
}
#endif
#endif
