/***************************************************************************
 *                       Stream.h  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _Stream_h_
#define _Stream_h_
#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qcolor.h>
#ifndef DECODER
#include "toUnicode.h"
#endif
#include <qtextcodec.h>
#include <qregexp.h>
#include <qdict.h>

#define TAG_ALIGN_LEFT 0
#define TAG_ALIGN_RIGHT 1
#define TAG_ALIGN_CENTER 2
#define TAG_ALIGN_JUSTIFY 3

struct tagProps {
    QColor color;
    QString href;
    QString base;
    QString imgSrc;
    QString imgAlt;
    unsigned char h;
    bool p;
    bool br;
    bool hr;
    bool ul;
    bool ol;   	//for numbered list '0l'
    unsigned char li;
    bool dl;
    bool pre;
    bool bq;
    bool address;
    bool em;
    bool cite;
    bool var;
    bool strong;
    bool code;
    bool samp;
    bool kbd;
    bool dfn;
    bool del;
    bool strike;
    bool small;
    bool i;
    bool b;
    bool tt;
    bool big;
    bool u;
    bool a;
    bool link;
    bool html;
    bool head;
    bool title;
    bool body;
    bool abbr;
    bool acronym;
    bool div;
    bool img;
    bool script;
};

struct linksProps {
    int position;
    QString name;
};

struct PdbToFileMap {
    unsigned short record;
    unsigned short offset;
    unsigned int index;
};

class Stream;

class Stream
{
    protected:
	int position,tempPos;
	QFile file;
	QTextStream *textstream;
	QChar c,tc;
	QString word, encoding, tagString, tagStringLc;
	QString tagName;
	bool tagStart;
	toUnicode *decoder;
	bool recode;
	QDict<char> entities;
	QChar entityToChar(QString);

	bool newParagraph;
	bool linksFound;
	linksProps * tempLinks; 
	linksProps * links;
	//linksProps links[200];
	int linksCount;
	tagProps tempTag;
	virtual QChar isTag(QChar);
	virtual QChar getTag(QChar);
	PdbToFileMap * pdbToIndex;
	unsigned int rimSize;
	unsigned int spacePadded;
	
    public:
	Stream();
	virtual ~Stream();
	QChar readNextChar();
	QString readWordForward(bool);
	int getPosition();
	void setPosition(int);
	void rewind();
	void gotoEnd();
	virtual bool openFile(const QString &);
	bool fileOpened;
	void closeFile();
	int getSize();
	bool atEnd();
	bool checkNewParagraph();
	bool checkNewLine();
	void setEncoding(QString);
	tagProps tag;
	bool tagChanged;
	bool newLine;
	virtual void findLinks();
	virtual int getInLinkPosition(QString);
	virtual QString findNextContent();
	void resetTags();
	QString getFileDir();
	int  getPageNumber();
	int docSize;
	int numberOfPages;
	QString fileName;

	bool reparagraph;
	bool stripCR;
	bool reorderPlucker;
	bool removeSpacePads;
};
#endif
