/*
 * AtiCore 2D acceleration API hack
 * sasha <sash@pdaXrom.org>
 * http://www.pdaXrom.org
 *
 * overlay api hack and data formats based on 
 * AGAWA Koji <kaoru-k@self-core.org>
 * and MVP player for Toshiba E740 (PocketPC)
 *
 * SolidROP and BltROP was extracted from ATI Radion headers
 *
 */

#include <inttypes.h>
#include <sys/types.h>

#ifndef __W100API_H__
#define __W100API_H__

#ifdef __cplusplus
extern "C" {
#endif

#define SolidRop_GXclear	0x00	/* 0 */
#define SolidRop_GXand		0xa0	/* src AND dst */
#define	SolidRop_GXandReverse	0x50	/* src AND NOT dst */
#define	SolidRop_GXcopy		0xf0	/* src */
#define SolidRop_GXandInverted	0x0a	/* NOT src AND dst */
#define	SolidRop_GXnoop		0xaa	/* dst */
#define	SolidRop_GXxor		0x5a	/* src XOR dst */
#define	SolidRop_GXor		0xfa	/* src OR dst */
#define	SolidRop_GXnor		0x05	/* NOT src AND NOT dst */
#define	SolidRop_GXequiv	0xa5	/* NOT src XOR dst */
#define	SolidRop_GXinvert	0x55	/* NOT dst */
#define	SolidRop_GXorReverse	0xf5	/* src OR NOT dst */
#define	SolidRop_GXcopyInverted	0x0f	/* NOT src */
#define	SolidRop_GXorInverted	0xaf	/* NOT src OR dst */
#define	SolidRop_GXnand		0x5f	/* NOT src OR NOT dst */
#define	SolidRop_GXset		0xff	/* 1 */

#define	BltRop_GXclear		0x00	/* 0 */
#define	BltRop_GXand		0x88	/* src AND dst */
#define	BltRop_GXandReverse	0x44	/* src AND NOT dst */
#define	BltRop_GXcopy		0xcc	/* src */
#define	BltRop_GXandInverted	0x22	/* NOT src AND dst */
#define	BltRop_GXnoop		0xaa	/* dst */
#define	BltRop_GXxor		0x66	/* src XOR dst */
#define	BltRop_GXor		0xee	/* src OR dst */
#define	BltRop_GXnor		0x11	/* NOT src AND NOT dst */
#define	BltRop_GXequiv		0x99	/* NOT src XOR dst */
#define	BltRop_GXinvert		0x55	/* NOT dst */
#define	BltRop_GXorReverse	0xdd	/* src OR NOT dst */
#define	BltRop_GXcopyInverted	0x33	/* NOT src */
#define	BltRop_GXorInverted	0xbb	/* NOT src OR dst */
#define	BltRop_GXnand		0x77	/* NOT src OR NOT dst */
#define	BltRop_GXset		0xff	/* 1 */

#define DSTTYPE_8BPP            1
#define DSTTYPE_16BPP_1555	3   //16 bpp aRGB 1555
#define DSTTYPE_16BPP_444	5   //16 bpp aRGB 4444

#define SRCTYPE_1BPP_OPA        0       //mono (expanded to frgd, bkgd)
#define SRCTYPE_1BPP_TRA        1       //mono (expanded to frgd, leave_alone)
#define SRCTYPE_EQU_DST         3       //color (same as DST)
#define SRCTYPE_SOLID_COLOR_BLT 4       //solid color for Blt (use frgd)
#define SRCTYPE_4BPP            5       //4 bpp
#define SRCTYPE_12BPP_PACKED    6       //12 bpp packed

#define ROP3_SRCCOPY				   0xcc
#define ROP3_PATCOPY				   0xf0

#define OVLTYPE_YUV420          7
#define OVLTYPE_RGB565          8

typedef struct {
    int16_t XCoord;
    int16_t YCoord;
} ATI_POINT;

typedef struct {
    int16_t XCoord;
    int16_t YCoord;
    int16_t Width;
    int16_t Height;
} ATI_RECT;

typedef struct {
    int16_t X_Top_Left;                  // x coordinate of top left corner
    int16_t Y_Top_Left;                  // y coordinate of top left corner
    int16_t X_Bottom_Right;              // x coordinate of bottom right corner
    int16_t Y_Bottom_Right;              // y coordinate of bottom right corner
} ATI_CLIPRECT;

typedef struct {
    uint32_t Count;                        /* +0 ֤ */
    uint8_t ScaleXFactor;                 /* +4 (16=ܡ) */
    uint8_t ScaleYFactor;                 /* +5  */
    uint8_t BlendOn;                      /* +6  */
    uint8_t dummy1;                       /* ̤ѡ */
} ATI_STRETCH;                          /* 8bytes? */

typedef struct {
    uint32_t *lpSrcBitmap;                /* եΥեå */
    uint16_t XCoord;                      /* +4  :եxɸ */
    uint16_t YCoord;                      /* +6  :եyɸ */
    uint16_t SrcPitch;                    /* +8  : */
    uint16_t SrcHeight;                   /* +10 : */
    uint16_t OverlayWidth;                /* Х쥤(SrcȰ㤦ͤˤƤ⡢ưŪ˳̾줿Ϥʤ̣Ρ) */
    uint16_t OverlayHeight;
    uint32_t lpOverlayKey;                /* +16 :(顼) */
    uint8_t OverlayFormat;               /* +20  */
    uint8_t dummy1;
    uint16_t dummy2;
} ATI_OVERLAYPROP;                      /* 24bytes? */

typedef struct {
    int HInvert;
    int VInvert;
} ATI_EXTVIDEOPROP;

typedef struct {
    ATI_EXTVIDEOPROP ExtVideoProp;
} ATI_UNKNOWN1;

typedef struct {
    uint32_t dummy1;
    uint32_t dummy2;
    uint8_t HExpansion;                   /* +8   */
    uint8_t VExpansion;                   /* +9   */
    uint8_t dummy3;
    uint8_t dummy4;
    uint8_t RConversion;                  /* +12  */
    uint8_t dummy5;
    uint8_t dummy6;
    uint8_t dummy7;
    ATI_UNKNOWN1 x;
} ATI_EXTENDEDOVERLAYPROP;              /* 16byte? */

/**
 * AtiCore initialization
 *
 * @return              1:success, 0:fail
 */
int AtiCore_ProcessAttach(void);

/**
 * AtiCore finish
 *
 * @return              **
 */
int AtiCore_ProcessDetach(void);

/**
 * եӥǥ˺롣
 * TODO: ExtRam ˳ݤˡϡ
 *
 * @arg     handle      ()եΥϥɥ
 * @arg     offset      ()եΥեå
 * @arg     size        եΥ(bytes)
 * @arg     direction   (0:̤̤, 1:̤̤)äƳ
 * @return              1:success, 0:fail
 */
int AtiCore_AllocateSurface(uint16_t *handle, uint32_t *offset,
                            uint32_t size, uint32_t direction);

/**
 * ե˴롣
 *
 * @arg     handle      եΥϥɥ
 * @return              1:success, 0:fail
 */
int AtiCore_DestroySurface(uint16_t handle);

/**
 * BitBlt ϴؿ ROP(饹ڥ졼) ꤹ롩
 *
 * @param   rop         8ӥåȤΥե饰Ȼפ
 */
int AtiCore_SetRopOperation(uint32_t rop);

/**
 * BitBlt ϴؿǻȤ륵եΥԥեޥåȤꤹ롩
 *
 */
int AtiCore_SetDstType(uint32_t);
int AtiCore_SetSrcType(uint32_t);

/**
 * BitBlt ϴؿΥåԥ󥰤ꡩ
 *
 */
int AtiCore_SetSrcClippingRect(ATI_CLIPRECT *cliprect);
int AtiCore_SetDstClippingRect(ATI_CLIPRECT *cliprect);

/**
 * BitBlt ϴؿǻȤ륵եΥԥåȥեåȤꤹ롣
 */
int AtiCore_SetSrcPitchOffset(int pitch, int offset);
int AtiCore_SetDstPitchOffset(int pitch, int offset);

/**
 * ޤ
 */
int AtiCore_BitBltFilpRotate(int flags,
                             ATI_RECT *dstRect, ATI_RECT *srcRect);

/**
 * ޤ
 */
int AtiCore_StretchBlt(ATI_STRETCH *option,
                       ATI_POINT *point, ATI_RECT *srcRect);


int AtiCore_WaitComplete(int msec);

/*
 * @param   handle      overlay
 * @return              1:success, 0:fail
 */
int AtiCore_AllocOverlay(uint16_t *handle);

/*
 * @param   handle      overlay
 */
int AtiCore_ReleaseOverlay(uint16_t handle);

/*
 * Setup overlay
 *
 * @return              1:success, 0:fail
 */
int AtiCore_SetupOverlay(uint16_t handle, ATI_OVERLAYPROP *prop);

/*
 * Setup addon overlay features
 */
int AtiCore_SetupOverlayExtended(uint16_t handle, ATI_EXTENDEDOVERLAYPROP *prop);

/*
 * Enable/Disable Overlay
 * @param   handle      overlay
 * @param   isShow      1: Show, 0: Hide
 * @return              1:success, 0:fail
 */
int AtiCore_SetOverlayOnOff(uint16_t handle, int isShow);

/*
 * Setup overlay position
 *
 * @param   handle      overlay
 * @param   x           x pos -- bug??? when x < 4 an overlay window is corrupted
 * @param   y           y pos
 */
int AtiCore_SetOverlayPos(uint16_t handle, uint16_t x, uint16_t y);

/**
 * Get pointer to VRAM address
 *
 * @param   offset      VRAM offset
 * @param   regdata     pointer to VRAM
 */
int AtiCore_SetupMemoryTransfer(uint32_t offset, uint32_t *regdata);

/*
 *
 */
int AtiCore_TerminateMemoryTransfer(void);

/*
 * @param   pitch       ()եΥԥå
 * @param   offset      ()եΥեå
 */
int AtiCore_GetFrontBufferPitchOffset(uint32_t *pitch, uint32_t *offset);

/**
 * Display brightness
 *
 * @param   brightness  -64...63
 * @return              1:success, 0:fail
 */
int AtiCore_SetDisplayBrightness(int brightness);

/*
 * @param   available Imageon internal RAM
 * @param   available external RAM
 * @return              1:success, 0:fail
 */
int GetAvailableVideoMem(uint32_t *internal, uint32_t *external);

/**
 *
 * 
 *
 
 {
    (uint32_t) 0
    (uint32_t) 0
    (uint16_t) 480
    (uint16_t) 640
    (uint16_t) 480
    (uint16_t) 640
    (uint32_t) 5
 */

typedef struct {
    uint32_t	dummy1;
    ATI_RECT	Size;
    uint16_t	Width;
    uint16_t	Height;
    uint32_t	Flag;
} ATI_GRAPHICWINDOW;
 
int AtiCore_SetupGraphicWindow(void* );

/*
 * if portret screen - mode = 0xaaab
 * else 0xaaaa
 */
 
int AtiCore_ProcessAttachSpecialMode(int mode);

/**
 * 0, 0
 */
int AtiCore_SetGraphicWindowPos(int, int);


/**
 * 0xf000000, 0, 0
 */
int AtiCore_SetFrontBuffer(int offset, int, int);

/*
 * 1 ; 0
 */
int AtiCore_SetGraphicWindowOnOff(int );

/*
 * 0x258a
 */
int AtiCore_SetFrgColour(int );

int AtiCore_BrushType(int, int);

int AtiCore_PaintRect(int, ATI_RECT*);

/*
 * 0 - no
 * 1 - no
 * 2 - normal line
 * 3 - draw line and line to previous op point
 * 4 - no
 */
int AtiCore_Polyline(int flags, ATI_CLIPRECT*);

int AtiCore_GetPitchOffsetProperty(void *, void *);

int AtiCore_CursorOnOff(int, int);

int AtiCore_BitBlt(int, ATI_RECT*, ATI_RECT*);

int AtiCore_WakeUpCall(void);

/* ================================================================ */
/* from libqte.so.2.3.2 */
/*
AtiCore_AlphaBlend
AtiCore_DrawPixel
AtiCore_Flush
AtiCore_GammaCorrection
AtiCore_GetCRC
AtiCore_GetCursorPos
AtiCore_GetDeviceInfo
AtiCore_GetGPIO_Data
AtiCore_GetGraphicExtended
AtiCore_GetGraphicWindowPos
AtiCore_GetLargestVideoMemBlock
AtiCore_GetLastError
AtiCore_GetMultiCRC
AtiCore_GetOverlayPos
AtiCore_Host
AtiCore_LoadCursorBitMap
AtiCore_PolyScanline
AtiCore_ProcessAttachMinimal(void)?
AtiCore_ProcessDetachMinimal(void)?
AtiCore_ProcessDetachSpecialMode
AtiCore_ReadCfgReg
AtiCore_ReadMem(int, int)?
AtiCore_ReadReg(int, int)?
AtiCore_ScanlineShading
AtiCore_SetApertures
AtiCore_SetBkgColour
AtiCore_SetBytePixelOrder
AtiCore_SetCursorPos
AtiCore_SetDisplayParameters
AtiCore_SetDriverBehaviour
AtiCore_SetGPIO_Data
AtiCore_SetOverlayPosUsingGraphicWindowXY
AtiCore_SetPartialCursor
AtiCore_SetupGraphicExtended
AtiCore_SetupPM4
AtiCore_SmallText
AtiCore_SubmitPM4Packet
AtiCore_TransBitBlt
AtiCore_WriteCfgReg
AtiCore_WriteMem
AtiCore_WriteReg
 */

#ifdef __cplusplus
}
#endif

#endif
