* S*Basic keyword: Convert long integer to string
* pjwitte 2oo2
*
* V0.01 April 17th 2002
* V0.02 March 19th 2004 - self-contained


        section code

        xdef lin2str

        xref cv_lin2str

        include dev8_keys_qdos_sms
        include dev8_keys_sbasic
        include dev8_keys_qlv
        include dev8_keys_err

*
lin2str
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Convert long integer to string and return to Basic
*
*       lin$ = LIN2STR$(lin)
*
* where: lin$ is the string representation of a signed long integer
*        lin  is the long integer to convert
*
        move.w sb.gtlin,a2      get long integer
        jsr (a2)
        bne.s err_exit

        subq.w #1,d3            one only
        bne.s err_bp

        move.l 0(a6,a1.l),d1    d1 = lint
        addq.l #4,sb_arthp(a6)

        bsr cv_lin2str          ret: d1.w = len; never fails

        moveq #3,d4             reserve room for str + len (+1)
        add.w d1,d4
        bclr #0,d4
        move.l d4,d1
        movea.l sb_arthp(a6),a1
        move.w  qa.resri,a2
        jsr (a2)

        tst.l d0                smsq/e
        bne.s err_exit

        sub.l d4,sb_arthp(a6)
        movea.l sb_arthp(a6),a1

*
movew01
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Moves a (padded even) string of bytes from (a6,a0.l) to (a6,a1.l)
* both a1 and a0 even
*
* input :
*        d4.w = number of bytes to move
*        a0  -> source (first byte to move)
*        a1  -> target
*
* return:  cc   ???
*        d4.w/a0-a1 all changed
*        no other registers affected
*
        lsr.w   #1,d4           ;convert to word count
        bra.s   mv_lend
mv_loop
        move.w  0(a6,a0.l),0(a6,a1.l)
        addq.l  #2,a0
        addq.l  #2,a1
mv_lend
        dbra    d4,mv_loop

        moveq   #ar.strng,d4    return code = string

        moveq #0,d0

err_exit
        rts

err_bp
        moveq #err.ipar,d0
        rts

*
        end
