
    MODULE GetKey


    INCLUDE "Defs_h"


    ; String defined in 'Errmsg_asm':
    XREF Write_Err_Msg

    ; Routines defined in this module:
    XDEF GetKey, CLI_logfile, No_keypress


; **************************************************************************************
;
;   1990, Jesper Zuschlag Madsen - Zuschlag Technology.
;
;         - modified by G.Strube, InterLogic, July 1992:
;         Screen off feature now activated from disabled interrupts.
;         Last key press feature removed - the keyboard is now re-scanned for no key
;         presses after a valid key has been pressed. Getkey returns only with key code
;         when the key has been released.
;
;
; Register status after return:
;
;       ..BCDEHL/afbcdehl/..IY  same
;       AF....../......../IX..  different
;
.GetKey           PUSH BC                   ; save all Z80 registers...
                  PUSH DE                   ; except AF
                  PUSH HL
                  EX   AF,AF'               ;
                  PUSH AF                   ;
                  EX   AF,AF'               ;
                  EXX
                  PUSH BC                   ;
                  PUSH DE
                  PUSH HL                   ;
                  EXX

.only_one_key     EXX
                  LD   DE,$0000             ; key counter & relative matrix map pointer
                  EXX
                  LD   BC,$BFB2             ; scan keyboard matrix, ROW A14
                  IN   A,(C)                ; return ROW information in A
                  BIT  4,A                  ; is <Diamond> pressed?
                  JR   Z,set_diamond
                  AND  $40                  ; left <SHIFT> key pressed?
                  LD   D,A                  ; remember key press...
                  CALL Z,set_shift_flag     ;
;
; check right <SHIFT> key...
                  RLC  B                    ; right <SHIFT> key in ROW A15
                  IN   A,(C)                ; scan keyboard row...
                  AND  $80                  ; right <SHIFT> key pressed?
                  CALL Z, set_shift_flag    ;
                  OR   D                    ; both <SHIFT> keys pressed? (BIT 7,6
                  JR   NZ, start_scan       ; no - one or both not pressed...
                  CALL OZ_DI                ; disable interrupts while SHIFT keys pressed down
                  PUSH AF
.shiftkey_loop    IN   A,(C)                ; read A15 until
                  AND  $80                  ; right SHIFT key
                  JR   Z,shiftkey_loop      ; is released
                  POP  AF
                  CALL OZ_EI                ; RSH released - switch off screen...
                  CALL_OZ(Os_Off)           ;
                  JR   only_one_key         ; screen back on, scan keyboard...

.set_shift_flag   EXX                       ; use alternate set...
                  LD   E,$40                ; set rel. pointer to 2. keyboard mat
                  EXX                       ; (for <SHIFT> key return codes)
                  RET                       ;

.set_diamond      EXX                       ; use alternate set...
                  LD   E,$80                ; set rel. pointer to 3. keyboard mat
                  EXX                       ; (for <DIAMOND> return codes)
                  RLC  B
                  JR   start_scan

.start_scan       LD   D,$08                ; scan keyboard matrix, 8 rows
.row_loop         LD   E,$08
                  RLC  B                    ; rows from A8 to A15
                  IN   A,(C)
                  BIT  6,B                  ; reached ROW A14?
                  JR   NZ,check_row_7       ; no
                  OR   80                   ; Yes, 'un-press' left <SHIFT> key an
                  JR   end_shift_set        ; and <DIAMOND> key.

.check_row_7      BIT  7,B                  ; reached ROW A15?
                  JR   NZ,end_shift_set     ; no
                  OR   @10000000            ; Yes, 'un-press' right <SHIFT> key..
.end_shift_set
.column_loop      SRL  A                    ; test a key press in ROW B, A7 - A0
                  JR   C,key_not_pressed    ; 1 = key not pressed...
                  EXX
                  INC  D                    ; key pressed, count key presses...
                  EXX
                  LD   H,D                  ; remember key coordinate in
                  LD   L,E                  ; matrix (D,E) = (row, column)

.key_not_pressed  DEC  E                    ; column loop counter A7 - A0
                  JR   NZ,column_loop       ; check all columns in row for key pr
                  DEC  D                    ; all columns checked - check new row
                  JR   NZ,row_loop
                  EXX                       ; keyboard scan finished
                  LD   A,D                  ; get number of key presses
                  EXX
                  CP   1                    ; only one key pressed?
                  JR   Z,one_key            ; Yes...
                  JP   only_one_key         ; more than one key pressed - illegal

.one_key          DEC  H                    ; adjust row 0 - 7, column 0 - 7
                  DEC  L
                  LD   BC, key_table        ; base of keyboard return codes
                  LD   A,H
                  LD   H,0
                  ADD  HL,BC                ; calculate column lookup
                  SLA  A
                  SLA  A
                  SLA  A                    ; row * 8 (each row = 8 columns)
                  LD   B,0
                  LD   C,A
                  ADD  HL,BC                ; calculate row lookup
                  EXX
                  LD   A,E                  ; get rel. pointer to keyboard matrix
                  EXX                       ; ( for <SHIFT> or <DIAMOND> )
                  LD   C,A
                  ADD  HL,BC                ; calc. matrix to match <SHIFT> or <D
                  LD   A,(HL)               ; key return code
                  CALL No_keypress
                  CP   19                   ; <Diamond>S pressed?
                  JR   Z, CLI_facility      ; Yes, call CLI...
                  CP   0                    ;
                  JP   Z, only_one_key      ; no key pressed or not defined
                  PUSH AF                   ;
                  CALL_OZ(Os_Pur)           ;
                  POP  AF                   ;
                  EXX
                  POP  HL                   ;
                  POP  DE
                  POP  BC                   ;
                  EXX
                  EX   AF,AF'               ;
                  POP  AF                   ;
                  EX   AF,AF'               ;
                  POP  HL
                  POP  DE
                  POP  BC
                  RET

.No_keypress      PUSH AF                   ;
.rescan_keyboard  LD   D,$08                ; scan keyboard matrix, 8 rows
                  LD   E,0                  ; number of rows with key pressed
                  LD   BC,$BFB2             ; scan keyboard matrix, ROW A14
.test_row_loop    RLC  B                    ; rows from A8 to A15
                  IN   A,(C)                ; get row

                  ; all keys except SHIFT keys must not be pressed
                  PUSH AF                   ; remember key row for a while
                  LD   A,B
                  CP   @01111111            ; column A15?
                  JR   Z, unset_RSH
                  CP   @10111111            ; column A14?
                  JR   Z,unset_LSH
                  POP  AF                   ; restore keyrow from A8 - A13
                  JR   check_keyrow
.unset_RSH        POP  AF                   ; restore keyrow
                  SET  7,A                  ; right Shift key unpressed...
                  JR   check_keyrow
.unset_LSH        POP  AF                   ; restore keyrow
                  SET  6,A                  ; left Shift key unpressed...
.check_keyrow     CP   255                  ; any keys pressed?
                  CALL NZ, keypress_found   ; Yes,
                  DEC  D                    ; no keys in row pressed - scan next column
                  JR   NZ,test_row_loop     ; check all rows for key presses
                  LD   A,E                  ;
                  CP   0                    ; no keys?
                  JR   NZ, rescan_keyboard  ; no - check again...
                  LD   BC,$0002             ;
                  CALL_OZ(Os_Dly)           ; delay next keyboard scan with 2 centiseconds
                  POP  AF                   ; restore return code
                  RET                       ; return only when no key is pressed
.keypress_found   INC  E
                  RET

.CLI_facility     CALL CLI_logfile
                  JP   only_one_key         ; back to main keyboard routine



; ***********************************************************************************************************
;
; Install local Error Handler (avoid using application Error handler),
; or restore application Error handler
;
; IN: HL = pointer to Error handler
;
.Install_ERH      LD   B,0
                  CALL_OZ(Os_Erh)
                  RET

.tmp_ERH          CP   A                    ; dummy error handler
                  RET                       ; - return no errors...



; ***********************************************************************************************************
;
; ^S pressed, activate CLI and execute '.T>:RAM.1/log.x' in CLI file 'clilog'.
; or de-activate current CLI logfile.
;
.CLI_logfile      LD   HL, tmp_ERH          ; local error handler
                  XOR  A
                  CALL Install_ERH
                  PUSH AF
                  PUSH HL                   ; preserve pointer to old ERH.
                  CALL Toggle_CLI           ; call CLI                                  ** V0.26d
                  CALL C, Write_Err_Msg
                  POP  HL
                  POP  AF
                  CALL Install_ERH          ; restore appl. Error handler
                  RET


; execute CLI routines
.Toggle_CLI       BIT  0,(IY+76)
                  JP   Z, Create_logfile

.Close_logfile    LD   IX,0                 ; close file and quit CLI.
                  LD   A,4                  ; T-output code
                  CALL_OZ(Dc_Rbd)
                  LD   BC,2                 ; dummy key read to allow CLI
                  CALL_OZ(Os_Tin)
                  RES  0,(IY+76)            ; indicate no CLI running
                  CP   A                    ; signal success
                  RET

.Create_logfile   LD   HL,0
                  ADD  HL,SP
                  LD   D,H
                  LD   E,L
                  LD   BC,10
                  CP   A
                  SBC  HL,BC                      ; make 18 bytes room for logfilename
                  LD   SP,HL                      ; set SP below logfilename buffer
                  PUSH DE                         ; remember current SP
                  PUSH HL                         ; remember start of filename buffer

                  LD   DE,CLI_file                ; ptr. to CLI filename
                  EX   DE,HL                      ; HL = source, DE = dest.
                  LD   BC,5                       ; copy standard filename into tmp buffer
                  LDIR                            ; DE = ptr. to end of name +1
                  LD   HL,2                       ; indicate BC = integer to be converted
                  LD   A, @00000001               ; to ASCII
                  INC  (IY + LogfileNr)           ; Update log file number
                  LD   C,(IY + LogfileNr)         ; BC = log file number
                  CALL_OZ(Gn_Pdn)                 ; convert log number into ASCII representation
                  XOR  A
                  LD   (DE),A                     ; then null terminate file name

                  POP  HL
                  PUSH HL
                  LD   A,OP_OUT
                  LD   D,H
                  LD   E,L                        ; also scratch buffer...
                  LD   BC,5
                  CALL_OZ(Gn_Opf)                 ; log file 'log.xxx' & 0
                  POP  DE
                  JR   C, exit_logfile            ; Ups - open error, return immediately

                  PUSH DE
                  LD   HL, CLI_command            ; 2. command to the CLI file
                  LD   BC,2                       ;
                  LDIR                            ; copy CLI command to buffer
                  POP  HL                         ; point at CLI command
                  LD   C,2
                  CALL_OZ(Dc_Icl)                 ; activate '.S' CLI redirection
                  JR   C, exit_logfile
                  LD   BC,2                       ; dummy key read to allow execute CLI
                  CALL_OZ(Os_Tin)
                  LD   A,4
                  CALL_OZ(DC_Rbd)                 ; rebind stream to T-output screen, file
                  JR   C, exit_logfile
                  SET  Flg_CLI,(IY + FlagStat1)   ; indicate CLI running...
                  CP   A                          ; signal success
.exit_logfile     POP  HL                         ; get old SP
                  LD   SP,HL                      ; install old SP
                  RET


; ***********************************************************************
;
; UK Z88 keyboard layout with <SHIFT>, <DIAMOND> and <SQUARE> sequenses.
; This layout is defined with inverted Caps Lock, i.e. all lower case letters
; are accessed with <SHIFT>.
;
; Each layer uses 64 bytes (8 rows with 8 columns)
.key_table

; Direct key press:
; Row #0
                  DEFB $02                  ; Right <SHIFT> key
                  DEFB 0                    ; <SQUARE> key
                  DEFB 27                   ; <ESC>  key
                  DEFB 0                    ; <INDEX> key
                  DEFB 0                    ; <CAPS>                        ** V0.19c
                  DEFM "./" & 163

; Row #1
                  DEFB 0                    ; <HELP> key                    ** V0.19c
                  DEFB $01                  ; Left <SHIFT> key
                  DEFB $09                  ; <TAB> key
                  DEFB 0                    ; <DIAMOND> key
                  DEFB 0                    ; <MENU> key
                  DEFB 44                   ; ","
                  DEFB 59                   ; ";"
                  DEFB 39                   ; "'"

; Row #2
                  DEFM "[ 1QAZL0"

; Row #3
                  DEFB ']'
                  DEFB $FC                  ; <Left Cursor>                   ** V0.18
                  DEFM "2WSXMP"

; Row #4
                  DEFB '-'
                  DEFB $FD                  ; <Right Cursor>                  ** V0.18
                  DEFM "3EDCK9"

; Row #5
                  DEFB '='
                  DEFB $FE                  ; <Down Cursor>                   ** V0.18
                  DEFM "4RFVJO"

; Row #6
                  DEFM '\'
                  DEFB $FF                  ; <Up Cursor>                     ** V0.18
                  DEFM "5TGBUI"

; Row #7
                  DEFB 127                  ; <DEL>
                  DEFB 13                   ; <ENTER>
                  DEFM "6YHN78"

; with <SHIFT> key pressed down:
; Row #0
                  DEFB $02                  ; Right <SHIFT> key
                  DEFB 0                    ; <SQUARE> key
                  DEFB 27                   ; <ESC>  key
                  DEFB 0                    ; <INDEX> key
                  DEFB 0                    ; <CAPS>                          ** V0.19c
                  DEFM ">?~"
; Row #1
                  DEFB 0                    ;                                 ** V0.19c
                  DEFB 0
                  DEFB $D2                  ; <SHIFT> <TAB>                   ** V0.18
                  DEFB 0
                  DEFB 0
                  DEFM "<:" & 34

; Row #2
                  DEFM "{ !qazl)"

; Row #3
                  DEFM '}'
                  DEFB $F8                  ; <SHIFT> <Left cursor>           ** V0.18
                  DEFM "@wsxmp"

; Row #4
                  DEFB '_'
                  DEFB $F9                  ; <SHIFT> <Right Cursor>          ** V0.18
                  DEFM "#edck("

; Row #5
                  DEFB '+'
                  DEFB $FA                  ; <SHIFT> <Down Cursor>           ** V0.18
                  DEFM "$rfvjo"

; Row #6
                  DEFB '|'
                  DEFB $FB                  ; <SHIFT> <Up Cursor>             ** V0.18
                  DEFM "%tgbui"

; Row #7
                  DEFB $D3                  ; <SHIFT> <DEL>                   ** V0.18
                  DEFB $D1                  ; <SHIFT> <ENTER>                 ** V0.18
                  DEFM "^yhn&*"


; with <DIAMOND> '^':
                  DS 4                      ; Row #0
                  DEFB  0,   0,   0,  30
                  ;                   ^`

                  DS 8                      ; Row #1

                  DEFB 27, 160,   0,  17    ; Row #2
                  ;    ^[             ^Q
                  DEFB  1,  26,  12,   0
                  ;    ^A   ^Z   ^L

                  DEFB 29,   0,   0,  23    ; Row #3
                  ;    ^]             ^W
                  DEFB 19,  24,  13,  16
                  ;    ^S,  ^X,  ^M,  ^P

                  DEFB  0,   0,   0,   5    ; Row #4
                  ;                   ^E
                  DEFB  4,   3,  11,   0
                  ;    ^D   ^C   ^K

                  DEFB  0,   0,   0,  18    ; Row #5
                  ;                   ^R
                  DEFB  6,  22,  10,  15
                  ;    ^F   ^V   ^J   ^O

                  DEFB  0,   0,   0,  20    ; Row #6
                  ;                   ^T
                  DEFB  7,   2,  21,   9
                  ;    ^G   ^B   ^U   ^I

                  DEFB 28,   0,   0,  25    ; Row #7
                  ;    ^\             ^Y
                  DEFB  8,  14,   0,   0
                  ;    ^H   ^N


.CLI_file         DEFM "/log."                  ; standard CLI logfile 1, 5 bytes long
.CLI_command      DEFM ".S" & 0
