
    MODULE ED_instructions


    ; Routines defined in 'debugger_asm'
    XREF Unknown_instr

    ; Routines defined in 'ArithLog_asm'
    XREF Arithm_HL

    XREF RestoreMainReg

    ; Routines defined in 'Stdinstr_asm'
    XREF Opcode_201

    XDEF Opcode_237


    INCLUDE "Defs_h"          ; assembly directives & various constants



; ***************************************************************************
;
; Additional Z80 instructions:
;                                       r = A, B, C, D, E, H, L
; IN   r,(C)                           dd = BC, DE, HL, SP
; OUT  (C),r                           nn = 16 bit address
; SBC  HL,dd
; ADC  HL,dd
; LD   (nn),dd
; NEG
; RETN, RETI
; IM  0, IM  1, IM  2
; LD I,A  ;  LD R,A  ;  LD A,I  ;  LD A,R
; RRD, RLD
;
; LDI, LDIR, LDD, LDDR
; CPI, CPIR, CPD, CPDR
; INI, INIR, IND, INDR
; OUTI, OTIR, OUTD, OTDR
;
.Opcode_237       EXX                       ;                                               ** V0.28
                  LD   A,(HL)               ; get 2. opcode
                  INC  HL                   ; ready for next byte-fetch...
                  EXX                       ; back to main                                  ** V0.28
                  LD   B,A                  ; get a copy of A into main set ** V0.16
                  AND  @11000000            ; mask out bit 5 - 0
                  CP   @10000000            ; block instruction group?
                  JP   Z, block_instruct
                  CP   @01000000            ; check for the rest...
                  JP   NZ, Unknown_instr
                  LD   A,B
                  AND  @00000111
                  CP   3                    ; LD  (nn),dd ?
                  JP   Z, LD_indirect_dd
                  CP   2
                  JR   Z, HL_arithm_dd      ; SBC / ADC HL,dd ?
                  CP   4                    ; NEG
                  JR   Z, NEG_instr
                  CP   0
                  JP   Z, IN_r_instr
                  CP   1
                  JR   Z, OUT_r_instr
                  CP   5
                  JP   Z, RET_intrpt_instr
                  CP   6
                  RET  Z                    ; IM instructions ignored          ** V0.16
                  JP   LD_interruptReg      ; @01000111


; ********************************************************************************
.HL_arithm_dd     LD   A,B                  ; get original 2. opcode
                  AND  @00110000
                  CP   0
                  JR   Z, arith_HL_BC
                  CP   @00010000
                  JR   Z, arith_HL_DE
                  CP   @00100000
                  JR   Z, arith_HL_HL
                  LD   A,B                  ; restore 2. opcode               ** V0.16
                  LD   C,20
                  EXX                       ;                                 ** V0.28
                  LD   (IY+20),E            ;                                 ** V0.23
                  LD   (IY+21),D            ; save current virtual SP         ** V0.23
                  EXX                       ;                                 ** V0.28
                  JP   Arithm_HL            ; which is fetched by Arithm_HL   ** V0.16

.arith_HL_BC      LD   A,B                  ; restore 2. opcode               ** V0.16
                  LD   C,0                  ;                                 ** V0.17
                  JP   Arithm_HL            ; BC...                           ** V0.17

.arith_HL_DE      LD   A,B                  ;                                 ** V0.16
                  LD   C,2                  ;                                 ** V0.17
                  JP   Arithm_HL            ; DE...                           ** V0.17

.arith_HL_HL      LD   A,B                  ;                                 ** V0.16
                  LD   C,4                  ;                                 ** V0.17
                  JP   Arithm_HL            ; HL...                           ** V0.17


; ***************************************************************************
.NEG_instr        EX   AF,AF'               ;                                 ** V0.23
                  NEG
                  EX   AF,AF'               ;                                 ** V0.23
                  RET


; ****************************************************************************
.OUT_r_instr      LD   A,B
                  AND  @00111000            ; mask out the register operand
                  CP   0
                  JR   Z, Out_B
                  CP   @00001000
                  JR   Z, Out_C
                  CP   @00010000
                  JR   Z, Out_D
                  CP   @00011000
                  JR   Z, Out_E
                  CP   @00100000
                  JR   Z, Out_H
                  CP   @00101000
                  JR   Z, Out_L
                  CP   @00111000
                  JR   Z, Out_A
                  JP   Unknown_instr        ; @110 , unknown instruction

.Out_B            LD   D,(IY+1)
                  JR   Out_direction

.Out_C            LD   D,(IY+0)
                  JR   Out_direction

.Out_D            LD   D,(IY+3)
                  JR   Out_direction

.Out_E            LD   D,(IY+2)
                  JR   Out_direction

.Out_H            LD   D,(IY+5)
                  JR   Out_direction

.Out_L            LD   D,(IY+4)
                  JR   Out_direction

.Out_A            EX   AF,AF'               ;                                 ** V0.27d
                  LD   D,A                  ;                                 ** V0.27d
                  EX   AF,AF'               ;                                 ** V0.27d

.Out_direction    LD   B,(IY+1)
                  LD   C,(IY+0)             ; port (C)
                  OUT  (C),D                ; no flags affected.
                  RET


; ****************************************************************************
.IN_r_instr       LD   A,B                  ; save original opcode
                  LD   B,(IY+1)             ; get A8 to A15
                  LD   C,(IY+0)             ; port (C)
                  EX   AF,AF'               ;                                 ** V0.23
                  IN   C,(C)                ; receive byte into C
                  EX   AF,AF'               ;                                 ** V0.23
                  AND  @00111000            ; mask out the register operand
                  CP   0
                  JR   Z, In_B
                  CP   @00001000
                  JR   Z, In_C
                  CP   @00010000
                  JR   Z, In_D
                  CP   @00011000
                  JR   Z, In_E
                  CP   @00100000
                  JR   Z, In_H
                  CP   @00101000
                  JR   Z, In_L
                  CP   @00111000
                  JR   Z, In_A
                  RET                       ; @110 , only Flag register affected...     ** V0.17

.In_B             LD   (IY+1),C
                  RET

.In_C             LD   (IY+0),C
                  RET

.In_D             LD   (IY+3),C
                  RET

.In_E             LD   (IY+2),C
                  RET

.In_H             LD   (IY+5),C
                  RET

.In_L             LD   (IY+4),C
                  RET

.In_A             EX   AF,AF'               ;                                 ** V0.27d
                  LD   A,C                  ;                                 ** V0.27d
                  EX   AF,AF'               ;                                 ** V0.27d
                  RET


; ****************************************************************************
;
; RETI, RETN                                2 bytes
;
.RET_intrpt_instr JP   Opcode_201           ; execute a standard RET instruction


; **********************************************************************************************
;
; LD   (nn),BC
; LD   (nn),DE
; LD   (nn),HL
; LD   (nn),SP
; LD   BC,(nn)
; LD   DE,(nn)
; LD   HL,(nn)
; LD   SP,(nn)
;
.LD_indirect_dd   EXX                       ;                                 ** V0.28
                  LD   C,(HL)               ; get low byte of address
                  INC  HL
                  LD   B,(HL)               ; get high byte of address
                  INC  HL
                  PUSH BC                   ;                                 ** V0.18
                  EXX                       ; back to main registers          ** V0.16
                  POP  HL                   ; HL = nn                         ** V0.18
                  LD   A,B                  ; get original 2. opcode
                  AND  @00111000
                  BIT  3,A
                  JR   Z, LD_indd_nn_dd     ; LD  (nn),dd
.LD_indd_dd_nn    RES  3,A                  ; LD  dd,(nn)
                  LD   C,(HL)
                  INC  HL
                  LD   B,(HL)               ; BC = (nn)
                  CP   0
                  JR   Z, store_BC_reg      ; LD  BC,(nn)
                  CP   @00010000
                  JR   Z, store_DE_reg      ; LD  DE,(nn)
                  CP   @00100000
                  JR   Z, store_HL_reg      ; LD  HL,(nn)

                  LD   H,B
                  LD   L,C
                  POP  IX                   ; get return address              ** V0.16
                  LD   SP,HL                ; set new SP
                  PUSH BC
                  EXX
                  POP  DE                   ; new v.p. SP installed           ** V0.23
                  EXX                       ;                                 ** V0.28
                  JP   (IX)                 ; fetch next Z80 instruction      ** V0.16

.store_BC_reg     LD   (IY+0),C
                  LD   (IY+1),B             ; store (nn) into BC
                  RET

.store_DE_reg     LD   (IY+2),C
                  LD   (IY+3),B             ; store (nn) into DE
                  RET

.store_HL_reg     LD   (IY+4),C
                  LD   (IY+5),B             ; store (nn) into HL
                  RET

.LD_indd_nn_dd    CP   0
                  JR   Z, LD_indd_nn_BC     ; LD  (nn),BC
                  CP   @00010000
                  JR   Z, LD_indd_nn_DE     ; LD  (nn),DE
                  CP   @00100000
                  JR   Z, LD_indd_nn_HL     ; LD  (nn),HL

.LD_indd_nn_SP    EXX                       ;                                 ** V0.28
                  PUSH DE                   ; get virtual SP                  ** V0.28
                  EXX                       ;                                 ** V0.28
                  POP  BC                   ; into...                         ** V0.28
                  JR   Indirect_nn_dd

.LD_indd_nn_BC    LD   C,(IY+0)
                  LD   B,(IY+1)             ; get BC
                  JR   Indirect_nn_dd

.LD_indd_nn_DE    LD   C,(IY+2)
                  LD   B,(IY+3)             ; get DE
                  JR   Indirect_nn_dd

.LD_indd_nn_HL    LD   C,(IY+4)
                  LD   B,(IY+5)             ; get HL

.Indirect_nn_dd   LD   (HL),C
                  INC  HL
                  LD   (HL),B               ; LD  (nn),dd !
                  RET


; *****************************************************************************************
;
; LD   A,I
; LD   I,A
; LD   A,R
; LD   R,A
;
.LD_interruptReg  LD   A,B                  ; get interrupt registers into A
                  AND  @00111000            ; etc...
                  CP   @00000000            ; LD  I,A ?
                  RET  Z                    ; instruction ignored...
                  CP   @00001000            ; LD  R,A ?
                  RET  Z                    ; instruction ignored...
                  CP   @00010000            ; LD  A,I ?
                  JR   Z, LD_I_into_A
                  CP   @00011000            ; LD  A,R ?
                  JR   Z, LD_R_into_A
                  CP   @00100000            ; RRD ?
                  JR   Z, RRD_instruction
                  CP   @00101000            ; RLD ?
                  JR   Z, RLD_instruction
                  JP   Unknown_instr

.LD_I_into_A      EX   AF,AF'               ;                                 ** V0.23
                  LD   A,I
                  EX   AF,AF'               ;                                 ** V0.23
                  RET

.LD_R_into_A      EX   AF,AF'               ;                                 ** V0.23
                  LD   A,R
                  EX   AF,AF'               ;                                 ** V0.23
                  RET

.RRD_instruction  LD   L,(IY+4)
                  LD   H,(IY+5)
                  EX   AF,AF'               ;                                 ** V0.23
                  RRD
                  EX   AF,AF'               ;                                 ** V0.23
                  RET

.RLD_instruction  LD   L,(IY+4)
                  LD   H,(IY+5)
                  EX   AF,AF'               ;                                 ** V0.23
                  RLD
                  EX   AF,AF'               ;                                 ** V0.23
                  RET


; ***********************************************************************************
.block_instruct   LD   A,B
                  AND  @00000111            ; get opcode in bits 2 - 0
                  CP   0
                  JR   Z, BlockLoad_instr
                  CP   1
                  JR   Z, BlockCmp_instr
                  CP   2
                  JP   Z, BlockInp_instr
                  CP   3
                  JP   Z, BlockOutp_instr

.BlockLoad_instr  LD   A,B
                  AND  @00111000
                  CP   @00100000
                  JR   Z, LDI_instr
                  CP   @00110000
                  JR   Z, LDIR_instr
                  CP   @00101000
                  JR   Z, LDD_instr
                  CP   @00111000
                  JR   Z, LDDR_instr
                  JP   Unknown_instr

.LDI_instr        CALL FetchBlockRegs
                  LDI
                  JP   SaveBlockRegs

.LDIR_instr       CALL FetchBlockRegs
                  LDIR
                  JP   SaveBlockRegs

.LDD_instr        CALL FetchBlockRegs
                  LDD
                  JP   SaveBlockRegs

.LDDR_instr       CALL FetchBlockRegs
                  LDDR
                  JP   SaveBlockRegs


.BlockCmp_instr   LD   A,B
                  AND  @00111000
                  CP   @00100000
                  JR   Z, CPI_instr
                  CP   @00110000
                  JR   Z, CPIR_instr
                  CP   @00101000
                  JR   Z, CPD_instr
                  CP   @00111000
                  JR   Z, CPDR_instr
                  JP   Unknown_instr

.CPI_instr        CALL FetchBlockRegs
                  CPI
                  JP   SaveBlockRegs

.CPIR_instr       CALL FetchBlockRegs
                  CPIR
                  JP   SaveBlockRegs

.CPD_instr        CALL FetchBlockRegs
                  CPD
                  JP   SaveBlockRegs

.CPDR_instr       CALL FetchBlockRegs
                  CPDR
                  JP   SaveBlockRegs


.BlockInp_instr   LD   A,B
                  AND  @00111000
                  CP   @00100000
                  JR   Z, INI_instr
                  CP   @00110000
                  JR   Z, INIR_instr
                  CP   @00101000
                  JR   Z, IND_instr
                  CP   @00111000
                  JR   Z, INDR_instr
                  JP   Unknown_instr

.INI_instr        CALL FetchBlockRegs
                  INI
                  JP   SaveBlockRegs

.INIR_instr       CALL FetchBlockRegs
                  INIR
                  JP   SaveBlockRegs

.IND_instr        CALL FetchBlockRegs
                  IND
                  JP   SaveBlockRegs

.INDR_instr       CALL FetchBlockRegs
                  INDR
                  JP   SaveBlockRegs


.BlockOutp_instr  LD   A,B
                  AND  @00111000
                  CP   @00100000
                  JR   Z, OUTI_instr
                  CP   @00110000
                  JR   Z, OTIR_instr
                  CP   @00101000
                  JR   Z, OUTD_instr
                  CP   @00111000
                  JR   Z, OTDR_instr
                  JP   Unknown_instr

.OUTI_instr       CALL FetchBlockRegs
                  OUTI
                  JP   SaveBlockRegs

.OTIR_instr       CALL FetchBlockRegs
                  OTIR
                  JP   SaveBlockRegs

.OUTD_instr       CALL FetchBlockRegs
                  OUTD
                  JP   SaveBlockRegs

.OTDR_instr       CALL FetchBlockRegs
                  OTDR
                  JP   SaveBlockRegs


.FetchBlockRegs   EXX
                  PUSH HL
                  EXX
                  CALL RestoreMainReg
                  EXX
                  POP  HL
                  EXX
                  EX   AF,AF'
                  RET

.SaveBlockRegs    EX   AF,AF'
                  LD   (IY+4),L
                  LD   (IY+5),H             ; save HL
                  LD   (IY+0),C
                  LD   (IY+1),B             ;      BC
                  LD   (IY+2),E
                  LD   (IY+3),D             ;      DE
                  RET

