	XLIB FlashStore_NextPartitionID

	LIB FlashStore_CheckPartitionID

; ************************************************************************
;
; Internal support library routine.
; Get pointer to next Partition Identifier, or to Free space.
; 
; ----------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Apr 1998
;
; ----------------------------------------------------------------------
; Version History:
;
; $Header: /Z88/StdLib/FlashStore/FStNxPid.asm 2     16-08-98 16:16 Gbs $
;
; $History: FStNxPid.asm $
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 16-08-98   Time: 16:16
; Updated in $/Z88/StdLib/FlashStore
; changes in comments.
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 16-04-98   Time: 21:01
; Created in $/Z88/StdLib/FlashStore
; ----------------------------------------------------------------------
;
; IN:
;	BHL = (absolute) pointer to current (valid) Partition Identifier
;		 (or "oz" File Eprom section)
;	D = size of current Partition in 16K banks
;
; OUT:
;	Fc = 0, 
;		Next Partition ID found, or pointer to free space
;		Fz = 1, Partition Identifier found at BHL.
;			A = Intel Chip Device Code
;			C = size of physical Card in 16K banks (defined by Device Code)
;			D = Size of Partition in 16K banks
;		Fz = 0, Partition Identifier not found (potential free space)
;			A undefined
;			C undefined
;			D undefined
;	Fc = 1,
;		No next partition ID or free space.
;		The entry Partition ID was the last on the card.
;
; Registers changed after return:
;	.....EHL/IXIY same
;	AFBCD.../.... different
;
.FlashStore_NextPartitionID
				LD	A,B				; $xFFC, D = size of partition in banks
				AND	@00111111			; calculate for slot boundary
				SUB	D
				RET	C				; this partition uses the last space available...

				LD	A,B
				SUB	D
				LD	B,A				; B = bank to next partition (or free space)
				CALL FlashStore_CheckPartitionID
				RET
