	XLIB FlashStoreDelSpace

	LIB FlashStoreFileEpr
	LIB FlashStoreFirstFile
	LIB FlashStoreFileEntryInfo


; ************************************************************************
;
; FlashStore File Eprom Format.
;
; Return amount of deleted file space on File Eprom, inserted in slot C.
;
; ------------------------------------------------------------------------
;
; $Header: /Z88/StdLib/FlashStore/FstDelSp.asm 2     24-01-98 20:42 Gbs $
;
; $History: FstDelSp.asm $
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:42
; Updated in $/Z88/StdLib/FlashStore
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 9:24
; Created in $/Z88/StdLib/FlashStore
; Added to SourceSafe
; 
; ------------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Jan. 1998
;
; ------------------------------------------------------------------------
;
; IN:
;	C = slot number containing File Eprom
;
; OUT:
;	Fc = 0, File Eprom available
;		DEBC = Amount of deleted file space used on File Eprom
;
;	Fc = 1, File Eprom was not found in slot C.
;
; Registers changed after return:
;	......HL/IXIY same
;	AFBCDE../.... different
;
.FlashStoreDelSpace
				CALL FlashStoreFileEpr
				RET	C					; File Eprom not available in slot

				EXX
				LD	BC,0
				LD	D,B
				LD	E,C					; Deleted File Space = 0
				EXX

				PUSH HL					; preserve original HL
				CALL FlashStoreFirstFile
				JR	C, exit_delspace		; no File Entry...

				LD	A,C
				AND	@00000011				; slots (0), 1, 2 or 3 possible
				RRCA
				RRCA						; converted to Slot mask $40, $80 or $C0
				RES	7,H
				SET	6,H					; HL defined for segment 1
.scan_eprom
				CALL FlashStoreFileEntryInfo	; scan all file entries...
				JR	C, exit_delspace

				CALL CalcDelFileSpace		; add file space (for deleted file entry)
				LD	B,C
				EX	DE,HL				; BHL = pointer to next File Entry in slot C
				JR	NC, scan_eprom			; look in next File Entry...
.exit_delspace
				EXX						; return DEBC (amount of deleted file space)
				POP	HL					; restore original HL
				CP	A					; Fc = 0, FlashStore File Eprom parsed...
				RET


; ************************************************************************
;
; Add file space to current sum, if file is marked as deleted.
;
; IN:
;	Fc = 0,
;		A = File Entry status (active or deleted)
;		BHL = pointer to current
;		CDE = Pointer to next File Entry
;
; OUT:
;	(Amount of deleted file space updated)
;
; Registers changed after return:
;	AFBCDEHL/IXIY af...... same
;	......../.... ..bcdehl different
;
.CalcDelFileSpace
				PUSH AF					; preserve Z80 status flags

				CP	$11
				JR	NZ, exit_calcdelfile	; active file...

				PUSH BC
				PUSH DE
				EXX
				POP	HL
				ADD	HL,BC
				LD	B,H
				LD	C,L
				POP	HL
				LD	A,E
				ADC	A,L
				LD	E,A					; delspace (DEBC) += <file length>
				EXX
.exit_calcdelfile
				POP	AF
				RET
