/****************************************************************************
*                                                                           *
*                                                                           *
*                                                                           *
*                                                                           *
****************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "uart.h"
#include "seriel.h"

#define STACKSIZE 0x10000
#define TSRE 0x40
#define LSR  5
#define BUFFERSIZE 2000
#define interruptsoff _asm cli
#define interruptson _asm sti

typedef struct
	{
	volatile unsigned int read;      /* nste data der skal lses */
	volatile unsigned int write;     /* nste ledige position */
	volatile unsigned int count;     /* antal bytes i buffer*/
	unsigned char data[ BUFFERSIZE ];   /*buffer */
	} BUFFER;


BUFFER far RX_buffer, TX_buffer;

extern void Tstart_timer (int milliseconds);
extern int Ttimer_expired (void);

extern BYTE Iparity;
extern BYTE Idbits;
extern BYTE Isbits;
extern unsigned int Ibaud;
extern BYTE Iport;
char ch='0';
char rx_ch=' ';
int COMPORT = 0;


unsigned int Hxmit_isr_cnt(void)
	{
	return( TX_buffer.count );
	}

int Hopen_port(void)
   {
   int Baud;
   char Parity;
   int Stopbit;
   int Databit;
   if (Iport != COMPORT)
	    {
	    if (COMPORT != 0)
		Hclose_port();
		COMPORT = Iport;

		RX_buffer.count = RX_buffer.read = RX_buffer.write = 0;
	    TX_buffer.count = TX_buffer.read = TX_buffer.write = 0;
	    switch ( COMPORT )
		{
    	        case 1:

   	             InstallCharHandler(1,&put_rx_byte,&get_tx_byte);
   	             Install_IrqLevel(4,1,0);
   	             /* Tx interrupt bliver enabled, nr der skrives i tx bufferen */
   	             break;

    	        case 2:

          	     InstallCharHandler(2,&put_rx_byte,&get_tx_byte);
           	     Install_IrqLevel(3,2,0);
                  /* Tx interrupt bliver enabled, nr der skrives i tx bufferen */
                 break;
    	        case 3:

   	             InstallCharHandler(3,&put_rx_byte,&get_tx_byte);
   	             Install_IrqLevel(4,0,3);
		     /* Tx interrupt bliver enabled, nr der skrives i tx bufferen */
   	             break;

    	        case 4:

          	     InstallCharHandler(4,&put_rx_byte,&get_tx_byte);
           	     Install_IrqLevel(3,0,4);
                  /* Tx interrupt bliver enabled, nr der skrives i tx bufferen */
                 break;
            }

     }


     Stopbit = Isbits;
     Databit = Idbits;
     switch (Iparity)
	{
	case 0: Parity = 'n';
		break;
	case 1: Parity = 'e';
		break;
	default: Parity = 'o';
	}

     Baud = Ibaud/10;
     SetBaudrate(COMPORT,Baud,Parity,Databit,Stopbit);


     Set_DTR(COMPORT,ON);
	 Set_RTS(COMPORT, ON);

     EnableRxIrq(COMPORT);

     return( 1 );
    }

void far put_rx_byte( int com_no, char rx_byte )
     {

     com_no++;  /* do nothing */
     com_no--;
     if ( RX_buffer.count < BUFFERSIZE )
	{

	RX_buffer.count++;
	RX_buffer.data[RX_buffer.write]= rx_byte;
	RX_buffer.write++;
	if (RX_buffer.write > (BUFFERSIZE-1))
	   {
	   RX_buffer.write = 0;
	   }
	}
     }

static short far get_tx_byte( int com_no )
     {
     unsigned char tempval = 0;
     com_no++;   /* do nothing */
     com_no--;

     if ( TX_buffer.count > 0 )
        {
        tempval = 0x00ff & TX_buffer.data[ TX_buffer.read ];
        TX_buffer.count--;
        if ( TX_buffer.read > BUFFERSIZE-2 )
           TX_buffer.read=0;
        else
	    TX_buffer.read++;

	return( tempval );
	}
     else
	return ( 0xff00 );
     }


BOOLEAN Hsend_char( unsigned char tx_byte )
	{
	interruptsoff;
	if (TX_buffer.count < BUFFERSIZE)
	   {
	   TX_buffer.count++;
	   TX_buffer.data[TX_buffer.write]= tx_byte /*&& 0xff*/;
	   if ( TX_buffer.write > BUFFERSIZE-2 )
	      TX_buffer.write = 0;
	   else
	       TX_buffer.write++;
	   EnableTxIrq( COMPORT );
	   interruptson;
	   return( TRUE );
	   }
	else
	   {
	   interruptson;
	   return( FALSE );
	   }
	}

BOOLEAN Hsend_byte( char *next_ch, unsigned int count)
	{
	int send_count;

	for (send_count = 0; send_count < count; send_count++)
		{
		while( Hsend_char(*next_ch) );
		next_ch++;
		}
	}

BOOLEAN Hget_byte( unsigned char *rx_char )
	{
	interruptsoff;
	if ( RX_buffer.count > 0 )
	   {
	   *rx_char = RX_buffer.data[ RX_buffer.read ];
	   RX_buffer.count--;
	   if (RX_buffer.read > BUFFERSIZE-2 )
	      RX_buffer.read = 0;
	   else
	       RX_buffer.read ++;
	   interruptson;
	   /*printf(" R %x ",*rx_char);  */
	   return ( 0 );
	   }
	else
				{
				interruptson;
				return( -1 );
				}
}


void Hreset_recv_buffer(void)
	{
	_disable();
	RX_buffer.count=RX_buffer.read=RX_buffer.write = 0;
	_enable();
	}

#if 0
int Hsend_break(void)
	{

	_disable();
	TX_buffer.count = TX_buffer.read = TX_buffer.write = 0;
	_enable();
	outp(peek(0x40,2*(COMPORT-1)),0);      /* send et '0'  p transmitter */
	SetBreak( COMPORT, 1 );            /* set break                   */
#if 0
	while( inp(peek(__Seg0040,2*(COMPORT-1)+LSR)) && TSRE  );
#else
	#if 0
	// hvad er egentlig meningen med dette ?
	while( inp(peek(0x40,2*(COMPORT-1))+LSR) & TSRE  );
	#endif
#endif
	Tstart_timer(10);
	while ( !Ttimer_expired());
	SetBreak( COMPORT, 0 );
	return( 0 );
	}
#endif

int Hport_exists(int port)
     {
     unsigned tp;

     tp = port-1;
     tp = tp * 2;
     if ( peek(0x0040, tp) )
	return( 1 );
     else
        return( 0 );
     }

int Hclose_port( void )
   {
    while( TX_buffer.count ) sleep(1);

    switch (COMPORT)
    {

    case 4:
    case 2:
	   {
	   DisableRxIrq(COMPORT);
	   Set_DTR(COMPORT,OFF);
	   Set_RTS(COMPORT,OFF);
	   Remove_IrqLevel(3);  // ERAJ: 3, ikke 4 !
           break;
           }
    case 3:
    case 1:
           {
           DisableRxIrq(COMPORT);
           Set_DTR(COMPORT,OFF);
           Set_RTS(COMPORT,OFF);
           Remove_IrqLevel(4);  // ERAJ: 4, ikke 3 !
           break;
           }
		 }
		 COMPORT = 0;			/*ERAJ*/
     return ( 1 );
   }


int Hchk_line_status(void)
	{


#if 0
	if ( inp(peek(__Seg0040,2*(COMPORT-1)+LSR)) && 0x0E  )
#else
	if ( inp(peek(0x40,2*(COMPORT-1))+LSR) & 0x0E  )
#endif
		return( 0 );
	else
		return (-1 );

	}
