

#include "writer.h"

#include <unistd.h>
#include <fcntl.h>


cPvr350Writer::cPvr350Writer(cRingBufferLinear *ring, int fd)
{
    output = fd;

    m_RingBuffer = ring;

    Start();
}



cPvr350Writer::~cPvr350Writer()
{
    Cancel();
}



void cPvr350Writer::Action()
{ 
    unsigned char *buf;
    int length;
    printf("Writer started pid %d\n",getpid());
        while(1) {
        if ( (buf = m_RingBuffer->Get(length) ) != NULL ) {
            /* Writing a length of 4000 seems to keep ivtv happy */
            if ( length >= 4000 ) {
                length = 4000;
                safe_write(output,buf,length);                           
                m_RingBuffer->Del(length);  
            } else {
                usleep(1);
            }
        } else {
            usleep(1);
        }
                         
    }       
}

