
#ifndef PVR350_DEVICE_H
#define PVR350_DEVICE_H

#include "mpeg2decoder.h"
#include <vdr/device.h>
#include <vdr/thread.h>
#include "pvr350osd.h"

class cPvr350Device: public cDevice {
private:
    int       fd_out;
    int       fbfd;
    int       mute;
    int storedglobalalpha;
    unsigned long initglobalalpha;
    int osdbufsize;
    unsigned char *osdbuffer;
    unsigned char *osdbuf_aligned;
    int stride;
    int       output_mode;


    ePlayMode m_PlayMode;  
    cMpeg2Decoder  *decoder;

public:
    cPvr350Device(void);
    ~cPvr350Device();
    void MakePrimaryDevice(bool On);
    int ProvidesCa(int Ca);
    virtual bool HasDecoder(void) const;

    virtual bool CanReplay(void) const;
    virtual bool SetPlayMode(ePlayMode PlayMode);


    //   virtual int64_t GetSTC(void);

    virtual void TrickSpeed(int Speed);
    virtual void Clear(void);
    virtual void Play(void);
    virtual void Freeze(void);
    virtual void Mute(void);
    virtual void StillPicture(const uchar *Data, int Length);
    virtual int PlayVideo(const uchar *Data, int Length);
    virtual void SetVideoFormat(bool VideoFormat16_9);
    virtual void SetVolumeDevice(int Volume);

    virtual bool Poll(cPoller &Poller, int TimeoutMs = 0);
    virtual cOsdBase *NewOsd(int x, int y);
};

#endif
