/*
 * hello.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: mediamvp.c,v 1.8 2004/06/08 08:58:08 dom Exp $
 */

#include "mediamvp.h"
#include "setup.h"
#include "server.h"
#include "i18n.h"
#include <getopt.h>



const char *cPluginMediamvp::VERSION        = SERVER_VERSION;
const char *cPluginMediamvp::DESCRIPTION    = "Mediamvp Support";


// --- cPluginMediamvp ----------------------------------------------------------

cPluginMediamvp::cPluginMediamvp(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginMediamvp::~cPluginMediamvp()
{
  // Clean up after yourself!
}

const char *cPluginMediamvp::CommandLineHelp(void)
{
    return "  -f fontfile,  --aaa=fontfile   Use specified font for menus\n";
}

bool cPluginMediamvp::ProcessArgs(int argc, char *argv[])
{
    static struct option long_options[] = {
        { "font",      required_argument, NULL, 'f' },
        { NULL }
    };
    int c;

    while ((c = getopt_long(argc, argv, "f:", long_options, NULL)) != -1) {
        switch ( c ) {
        case 'f':
            c_font_file = optarg;
            break;
        default:
            return false;
        }
    }


    return true;
}

bool cPluginMediamvp::Start(void)
{
    // Start any background activities the plugin shall perform.

    /* Start up the server here.. */
    RegisterI18n(Phrases);
    cMediamvpServer::Init();
    return true;
}

void cPluginMediamvp::Housekeeping(void)
{

  // Perform any cleanup or other regular tasks.
}


cMenuSetupPage *cPluginMediamvp::SetupMenu(void)
{
    // Return a setup menu in case the plugin supports one.
    return new cMediamvpMenuSetupPage;
}

bool cPluginMediamvp::SetupParse(const char *Name, const char *Value)
{
    return ConfigParse(Name,Value);
}

VDRPLUGINCREATOR(cPluginMediamvp); // Don't touch this!
