/*
 *   MediaMVP Server Render Library
 *
 *   (C) 2004 Dominic Morris
 *
 *   $Id: mvprender.h,v 1.1 2004/04/22 18:37:09 dom Exp $
 *   $Date: 2004/04/22 18:37:09 $
 *
 *   Break out render_t into a separate library
 *
 */


#ifndef MVPRENDER_H
#define MVPRENDER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "libmvp.h"

#include <stdio.h>     /* We need NULL */

typedef struct _render render_t;
typedef struct _glyph          glyph_t;
typedef struct _font           font_t;

#define MVPFONT_MAGIC  "mvpfont-"


extern void           delete_glyph(glyph_t *glyph);
extern void           glyph_add_bitmap(glyph_t *glyph, int bitmap);
extern int           *glyph_get_bitmap(glyph_t *glyph);
extern void           glyph_set_height(glyph_t *glyph, int height);
extern int            glyph_get_height(glyph_t *glyph);
extern void           glyph_set_width(glyph_t *glyph, int width);
extern int            glyph_get_width(glyph_t *glyph);
extern font_t        *new_font();
extern int            font_is_defined(font_t *font, int glyph_id);
extern font_t        *font_load(char *font_name);
extern void           font_set_name(font_t *font, char *display_name);
extern int            font_get_height(font_t *font);
extern int            font_get_width(font_t *font);
extern int            font_get_glyph_max(font_t *font);
extern int            font_get_glyph_num(font_t *font);
extern glyph_t       *font_get_glyph(font_t *font, int glyph_id);
extern void           delete_font(font_t *font);
extern font_t        *font_read(char *data);





extern render_t       *new_render(int width, int depth);
extern void            delete_render(render_t *render);
extern void           *render_rgb2yvuy(render_t *render, int *size);
extern void            render_set_fgcol(render_t *render, uint32_t rgb);
extern void            render_set_bgcol(render_t *render, uint32_t rgb);
extern void            render_printrow(render_t *render, int row, char *text);
extern void            render_clear(render_t *render);
extern void            render_printrow_width(render_t *render, int row, int x, int width, char *text);
extern int             render_get_maxrows(render_t *render);
extern int             render_get_depth(render_t *render);
extern int             render_get_width(render_t *render);
extern int             render_get_textspace(render_t *render, char *text);
extern int             render_get_xoffset(render_t *render);
extern int             render_get_yoffset(render_t *render);
extern void            render_mark_dirty(render_t *render);
extern surface_t      *render_attach_surface(render_t *render,surface_t *sfc);
extern int             render_get_font_width(render_t *render);
extern void            render_set_font(render_t *render, font_t *font);
extern font_t         *render_get_font(render_t *render);
extern font_t         *render_swap_font(render_t *render, font_t *font);



#ifdef __cplusplus
}
#endif


#endif /* MVPRENDER_H */
