
/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: mvp.c,v 1.11 2004/05/07 21:15:20 dom Exp $
 *   $Date: 2004/05/07 21:15:20 $
 *
 *
 *   More wrapping up of the C code, this effectively a version of
 *   the main code.
 *
 */

#include "libmvp_internal.h"


mvpinit_t         *initparams;


int mediamvp_server_init(mvpinit_t *init)
{

    initparams = init;

    if ( initparams->logfile == NULL ) {
        initparams->logfile = stderr;
    }
    Dprintf(INFO,"MediaMVP server %s starting\n",SERVER_VERSION);

    if ( initparams->main_interfaceip == 0 ) {
         char hostbuf[1024];
         if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
                 return -1;
         }
         if ( ( initparams->main_interfaceip = host_resolve(hostbuf) ) == - 1 ) {
            return -1;
         }
     }

    if ( initparams->main_interfaceip == htonl(0x7f000001) ) {
        fprintf(stderr,"Check /etc/hosts - my hostname resolves to 127.0.0.1\n");
        return -1;
    }


    event_init();
    udp_init();
    if ( gui_init() < 0 ) {
        return -1;
    }

    if ( stream_init() < 0 ) {
        return -1;
    }
    urlhandler_init();

    return 0;
}


void mediamvp_server_stop()
{
    udp_exit();
    gui_exit();
    stream_exit();
    dongle_closeall();
}

