/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: keys.c,v 1.6 2004/09/16 19:37:04 dom Exp $
 *   $Date: 2004/09/16 19:37:04 $
 *
 *
 *   Handle keys
 */

#include "libmvp_internal.h"

typedef struct {
    int          code;
    char        *name;
    int          internal_code;
} mvpkey_t;

static mvpkey_t defkeys[] = {
    { 0x01, "0", key0 },
    { 0x02, "1", key1 },
    { 0x03, "2", key2 },
    { 0x04, "3", key3 },
    { 0x05, "4", key4 },
    { 0x06, "5", key5 },
    { 0x07, "6", key6 },
    { 0x08, "7", key7 },
    { 0x09, "8", key8 },
    { 0x0a, "9", key9 },
    { 0x0d, "OK", keyOk },
    { 0x0e, "Rewind", keyFastRew },
    { 0x0f, "Forward", keyFastFwd },
    { 0x10, "Vol-", keyVolDn },
    { 0x11, "Vol+", keyVolUp },
    { 0x12, "Ch+", keyChanUp },
    { 0x13, "Ch-", keyChanDn },
    { 0x14, "Power", keyPower },
    { 0x15, "Mute", keyMute },
    { 0x19, "Play", keyPlay },
    { 0x1a, "Record", keyRecord },
    { 0x1b, "Stop", keyStop },
    { 0x1c, "Pause", keyPause },
    { 0x1e, "Menu", keyMenu },
    { 0x20, "Back", keyBack },
    { 0x23, "Go", keyGo },
    { 0x24, "Red", keyRed },
    { 0x25, "Green", keyGreen },
    { 0x26, "Yellow", keyYellow },
    { 0x27, "Blue", keyBlue },
    { 0x28, "Blank", keyBlank },
    { 0x29, "Full", keyFull },
    { 0x2a, "Replay", keyReplay },
    { 0x2b, "Skip", keySkip },
    { 0x00, NULL, }
};


static mvpkey_t *find_key(int code)
{
    mvpkey_t *key;

    key = &defkeys[0];
    while ( key->code ) {
        if ( key->code == code ) {
            return key;
        }
        key++;
    }

    return NULL;
}


int key_code(int ircode)
{
    mvpkey_t *key = find_key(ircode);

    if ( key == NULL ) {
        Dprintf(INFO,"Unknown key code %d\n",ircode);
        return 0;
    }

    return key->internal_code;
}

char *key_string(int ircode)
{   
    mvpkey_t *key = find_key(ircode);

    if ( key == NULL ) {
        Dprintf(INFO,"Unknown key code %d\n",ircode);
        return 0;
    }
    
    return key->name;
}

char *key_name(int keycode)
{   
    mvpkey_t *key;

    key = &defkeys[0];
    while ( key->code ) {
        if ( key->internal_code == keycode ) {
            break;
        }
        key++;
    }

    if ( key->code == 0 ) {
        key = NULL;
    }

    if ( key == NULL ) {
        Dprintf(INFO,"Unknown key code %d\n",keycode);
        return 0;
    }
    
    return key->name;
}
